/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.auto.value.AutoValue;
import com.google.common.base.Ascii;
import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.squareup.javapoet.AnnotationSpec;
import dagger.internal.GenerationOptions;
import dagger.internal.codegen.AutoValue_CompilerOptions;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.FeatureStatus;
import dagger.internal.codegen.ValidationType;
import dagger.producers.Produces;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.tools.Diagnostic;

@AutoValue
abstract class CompilerOptions {
    static final ImmutableSet<String> SUPPORTED_OPTIONS = Stream.concat(Arrays.stream(Feature.values()), Arrays.stream(Validation.values())).filter(Option::useCommandLineOption).map(Object::toString).collect(DaggerStreams.toImmutableSet());

    CompilerOptions() {
    }

    abstract boolean usesProducers();

    abstract boolean fastInit();

    abstract boolean formatGeneratedSource();

    abstract boolean writeProducerNameInToken();

    abstract Diagnostic.Kind nullableValidationKind();

    boolean doCheckForNulls() {
        return this.nullableValidationKind().equals((Object)Diagnostic.Kind.ERROR);
    }

    abstract Diagnostic.Kind privateMemberValidationKind();

    abstract Diagnostic.Kind staticMemberValidationKind();

    abstract boolean ignorePrivateAndStaticInjectionForComponent();

    abstract ValidationType scopeCycleValidationType();

    abstract boolean warnIfInjectionFactoryNotGeneratedUpstream();

    abstract boolean headerCompilation();

    abstract boolean aheadOfTimeSubcomponents();

    abstract boolean useGradleIncrementalProcessing();

    abstract ValidationType moduleBindingValidationType();

    abstract Diagnostic.Kind moduleHasDifferentScopesDiagnosticKind();

    abstract ValidationType explicitBindingConflictsWithInjectValidationType();

    static Builder builder() {
        return new AutoValue_CompilerOptions.Builder().headerCompilation(false).useGradleIncrementalProcessing(false);
    }

    static CompilerOptions create(ProcessingEnvironment processingEnv) {
        AutoValue_CompilerOptions.Builder builder = new AutoValue_CompilerOptions.Builder();
        for (Option option : Iterables.concat(EnumSet.allOf(Feature.class), EnumSet.allOf(Validation.class))) {
            option.set(builder, processingEnv);
        }
        return builder.build();
    }

    abstract Builder toBuilder();

    CompilerOptions withGenerationOptions(GenerationOptions generationOptions) {
        return this.toBuilder().fastInit(generationOptions.fastInit()).build();
    }

    AnnotationSpec toGenerationOptionsAnnotation() {
        return AnnotationSpec.builder(GenerationOptions.class).addMember("fastInit", "$L", new Object[]{this.fastInit()}).build();
    }

    private static String optionName(String enumName) {
        return "dagger." + CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, enumName);
    }

    private static <T extends Enum<T>> T valueOf(ProcessingEnvironment processingEnv, String key, T defaultValue, Set<T> validValues) {
        Map<String, String> options = processingEnv.getOptions();
        if (options.containsKey(key)) {
            String optionValue = options.get(key);
            if (optionValue == null) {
                processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Processor option -A" + key + " needs a value");
            } else {
                try {
                    T type = Enum.valueOf(defaultValue.getDeclaringClass(), Ascii.toUpperCase((String)optionValue));
                    if (!validValues.contains(type)) {
                        throw new IllegalArgumentException();
                    }
                    return type;
                }
                catch (IllegalArgumentException e) {
                    processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Processor option -A%s may only have the values %s (case insensitive), found: %s", key, validValues, options.get(key)));
                }
            }
        }
        return defaultValue;
    }

    private static enum Validation implements Option
    {
        DISABLE_INTER_COMPONENT_SCOPE_VALIDATION(Builder::scopeCycleValidationType),
        NULLABLE_VALIDATION((BiConsumer)Validation.kindSetter(Builder::nullableValidationKind), ValidationType.ERROR, new ValidationType[]{ValidationType.WARNING}){}
        ,
        PRIVATE_MEMBER_VALIDATION(Validation.kindSetter(Builder::privateMemberValidationKind), ValidationType.ERROR, ValidationType.WARNING),
        STATIC_MEMBER_VALIDATION(Validation.kindSetter(Builder::staticMemberValidationKind), ValidationType.ERROR, ValidationType.WARNING),
        MODULE_BINDING_VALIDATION(Builder::moduleBindingValidationType, ValidationType.NONE, ValidationType.ERROR, ValidationType.WARNING),
        MODULE_HAS_DIFFERENT_SCOPES_VALIDATION(Validation.kindSetter(Builder::moduleHasDifferentScopesDiagnosticKind), ValidationType.ERROR, ValidationType.WARNING),
        EXPLICIT_BINDING_CONFLICTS_WITH_INJECT(Builder::explicitBindingConflictsWithInjectValidationType, ValidationType.WARNING, ValidationType.ERROR, ValidationType.NONE);

        final ValidationType defaultType;
        final ImmutableSet<ValidationType> validTypes;
        final BiConsumer<Builder, ValidationType> setter;

        static BiConsumer<Builder, ValidationType> kindSetter(BiConsumer<Builder, Diagnostic.Kind> setter) {
            return (builder, validationType) -> setter.accept((Builder)builder, validationType.diagnosticKind().get());
        }

        private Validation(BiConsumer<Builder, ValidationType> setter) {
            this(setter, ValidationType.ERROR, ValidationType.WARNING, ValidationType.NONE);
        }

        private Validation(BiConsumer<Builder, ValidationType> setter, ValidationType defaultType, ValidationType ... moreValidTypes) {
            this.setter = setter;
            this.defaultType = defaultType;
            this.validTypes = Sets.immutableEnumSet((Enum)defaultType, (Enum[])moreValidTypes);
        }

        @Override
        public void set(Builder builder, ProcessingEnvironment processingEnvironment) {
            this.setter.accept(builder, this.validationType(processingEnvironment));
        }

        ValidationType validationType(ProcessingEnvironment processingEnvironment) {
            return (ValidationType)CompilerOptions.valueOf(processingEnvironment, this.toString(), this.defaultType, this.validTypes);
        }

        public String toString() {
            return CompilerOptions.optionName(this.name());
        }
    }

    private static enum Feature implements Option
    {
        HEADER_COMPILATION(Builder::headerCompilation){

            @Override
            boolean isEnabled(ProcessingEnvironment processingEnvironment) {
                return processingEnvironment.getOptions().containsKey(this.toString());
            }

            @Override
            public String toString() {
                return "experimental_turbine_hjar";
            }
        }
        ,
        FAST_INIT(Builder::fastInit),
        EXPERIMENTAL_ANDROID_MODE((builder, ignoredValue) -> {}){

            @Override
            public void set(Builder builder, ProcessingEnvironment processingEnvironment) {
                this.noLongerRecognizedWarning(processingEnvironment);
            }
        }
        ,
        FORMAT_GENERATED_SOURCE(Builder::formatGeneratedSource, FeatureStatus.ENABLED),
        WRITE_PRODUCER_NAME_IN_TOKEN(Builder::writeProducerNameInToken),
        WARN_IF_INJECTION_FACTORY_NOT_GENERATED_UPSTREAM(Builder::warnIfInjectionFactoryNotGeneratedUpstream),
        IGNORE_PRIVATE_AND_STATIC_INJECTION_FOR_COMPONENT(Builder::ignorePrivateAndStaticInjectionForComponent),
        EXPERIMENTAL_AHEAD_OF_TIME_SUBCOMPONENTS(Builder::aheadOfTimeSubcomponents),
        FLOATING_BINDS_METHODS((builder, ignoredValue) -> {}){

            @Override
            public void set(Builder builder, ProcessingEnvironment processingEnvironment) {
                this.noLongerRecognizedWarning(processingEnvironment);
            }
        }
        ,
        USE_GRADLE_INCREMENTAL_PROCESSING(Builder::useGradleIncrementalProcessing){

            @Override
            boolean isEnabled(ProcessingEnvironment processingEnvironment) {
                return processingEnvironment.getOptions().containsKey(this.toString());
            }

            @Override
            public String toString() {
                return "dagger.gradle.incremental";
            }
        }
        ,
        USES_PRODUCERS(Builder::usesProducers){

            @Override
            boolean isEnabled(ProcessingEnvironment processingEnvironment) {
                return processingEnvironment.getElementUtils().getTypeElement(Produces.class.getCanonicalName()) != null;
            }

            @Override
            public boolean useCommandLineOption() {
                return false;
            }
        };

        final FeatureStatus defaultValue;
        final BiConsumer<Builder, Boolean> setter;

        private Feature(BiConsumer<Builder, Boolean> setter) {
            this(setter, FeatureStatus.DISABLED);
        }

        private Feature(BiConsumer<Builder, Boolean> setter, FeatureStatus defaultValue) {
            this.setter = setter;
            this.defaultValue = defaultValue;
        }

        @Override
        public void set(Builder builder, ProcessingEnvironment processingEnvironment) {
            this.setter.accept(builder, this.isEnabled(processingEnvironment));
        }

        boolean isEnabled(ProcessingEnvironment processingEnvironment) {
            return ((FeatureStatus)CompilerOptions.valueOf(processingEnvironment, this.toString(), this.defaultValue, EnumSet.allOf(FeatureStatus.class))).equals((Object)FeatureStatus.ENABLED);
        }

        public String toString() {
            return CompilerOptions.optionName(this.name());
        }

        void noLongerRecognizedWarning(ProcessingEnvironment processingEnvironment) {
            if (processingEnvironment.getOptions().containsKey(this.toString())) {
                processingEnvironment.getMessager().printMessage(Diagnostic.Kind.WARNING, this.toString() + " is no longer a recognized option by Dagger");
            }
        }
    }

    private static interface Option {
        public void set(Builder var1, ProcessingEnvironment var2);

        default public boolean useCommandLineOption() {
            return true;
        }
    }

    @AutoValue.Builder
    @CanIgnoreReturnValue
    static interface Builder {
        public Builder usesProducers(boolean var1);

        public Builder headerCompilation(boolean var1);

        public Builder fastInit(boolean var1);

        public Builder formatGeneratedSource(boolean var1);

        public Builder writeProducerNameInToken(boolean var1);

        public Builder nullableValidationKind(Diagnostic.Kind var1);

        public Builder privateMemberValidationKind(Diagnostic.Kind var1);

        public Builder staticMemberValidationKind(Diagnostic.Kind var1);

        public Builder ignorePrivateAndStaticInjectionForComponent(boolean var1);

        public Builder scopeCycleValidationType(ValidationType var1);

        public Builder warnIfInjectionFactoryNotGeneratedUpstream(boolean var1);

        public Builder aheadOfTimeSubcomponents(boolean var1);

        public Builder useGradleIncrementalProcessing(boolean var1);

        public Builder moduleBindingValidationType(ValidationType var1);

        public Builder moduleHasDifferentScopesDiagnosticKind(Diagnostic.Kind var1);

        public Builder explicitBindingConflictsWithInjectValidationType(ValidationType var1);

        @CheckReturnValue
        public CompilerOptions build();
    }
}

