/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.BindsInstance;
import dagger.internal.codegen.ComponentKind;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.ErrorMessages;
import dagger.internal.codegen.ValidationReport;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

class ComponentCreatorValidator {
    private final DaggerElements elements;
    private final DaggerTypes types;

    @Inject
    ComponentCreatorValidator(DaggerElements elements, DaggerTypes types) {
        this.elements = elements;
        this.types = types;
    }

    public ValidationReport<TypeElement> validate(TypeElement subject) {
        Set<Modifier> modifiers;
        ValidationReport.Builder<TypeElement> builder = ValidationReport.about(subject);
        ComponentKind componentKind = ComponentKind.forAnnotatedBuilderElement(subject).get();
        Element componentElement = subject.getEnclosingElement();
        ErrorMessages.ComponentCreatorMessages msgs = ErrorMessages.creatorMessagesFor(componentKind);
        Preconditions.checkArgument((boolean)MoreElements.isAnnotationPresent(subject, componentKind.builderAnnotation().get()));
        if (!MoreElements.isAnnotationPresent(componentElement, componentKind.annotation())) {
            builder.addError(msgs.mustBeInComponent(), subject);
        }
        switch (subject.getKind()) {
            case CLASS: {
                List<? extends Element> allElements = subject.getEnclosedElements();
                List<ExecutableElement> cxtors = ElementFilter.constructorsIn(allElements);
                if (cxtors.size() == 1 && ((ExecutableElement)Iterables.getOnlyElement(cxtors)).getParameters().size() == 0) break;
                builder.addError(msgs.cxtorOnlyOneAndNoArgs(), subject);
                break;
            }
            case INTERFACE: {
                break;
            }
            default: {
                builder.addError(msgs.mustBeClassOrInterface(), subject);
                return builder.build();
            }
        }
        if (!subject.getTypeParameters().isEmpty()) {
            builder.addError(msgs.generics(), subject);
        }
        if ((modifiers = subject.getModifiers()).contains((Object)Modifier.PRIVATE)) {
            builder.addError(msgs.isPrivate(), subject);
        }
        if (!modifiers.contains((Object)Modifier.STATIC)) {
            builder.addError(msgs.mustBeStatic(), subject);
        }
        if (!modifiers.contains((Object)Modifier.ABSTRACT)) {
            builder.addError(msgs.mustBeAbstract(), subject);
        }
        ExecutableElement factoryMethod = null;
        block8: for (ExecutableElement method : this.elements.getUnimplementedMethods(subject)) {
            ExecutableType resolvedMethodType = MoreTypes.asExecutable(this.types.asMemberOf(MoreTypes.asDeclared(subject.asType()), method));
            TypeMirror returnType = resolvedMethodType.getReturnType();
            switch (method.getParameters().size()) {
                case 0: {
                    if (this.types.isSubtype(componentElement.asType(), returnType)) {
                        this.validateFactoryMethodReturnType(builder, MoreElements.asType(componentElement), msgs, method, returnType);
                        if (factoryMethod != null) {
                            ComponentCreatorValidator.error(builder, method, msgs.twoBuildMethods(), msgs.inheritedTwoBuildMethods(), factoryMethod);
                        }
                    } else {
                        ComponentCreatorValidator.error(builder, method, msgs.buildMustReturnComponentType(), msgs.inheritedBuildMustReturnComponentType(), new Object[0]);
                    }
                    factoryMethod = method;
                    continue block8;
                }
                case 1: {
                    if (returnType.getKind() != TypeKind.VOID && !this.types.isSubtype(subject.asType(), returnType)) {
                        ComponentCreatorValidator.error(builder, method, msgs.methodsMustReturnVoidOrBuilder(), msgs.inheritedMethodsMustReturnVoidOrBuilder(), new Object[0]);
                    }
                    if (!method.getTypeParameters().isEmpty()) {
                        ComponentCreatorValidator.error(builder, method, msgs.methodsMayNotHaveTypeParameters(), msgs.inheritedMethodsMayNotHaveTypeParameters(), new Object[0]);
                    }
                    if (DaggerElements.isAnyAnnotationPresent(method, BindsInstance.class, new Class[0]) || !method.getParameters().get(0).asType().getKind().isPrimitive()) continue block8;
                    ComponentCreatorValidator.error(builder, method, msgs.nonBindsInstanceMethodsMayNotTakePrimitives(), msgs.inheritedNonBindsInstanceMethodsMayNotTakePrimitives(), new Object[0]);
                    continue block8;
                }
            }
            ComponentCreatorValidator.error(builder, method, msgs.methodsMustTakeOneArg(), msgs.inheritedMethodsMustTakeOneArg(), new Object[0]);
        }
        if (factoryMethod == null) {
            builder.addError(msgs.missingBuildMethod(), subject);
        }
        return builder.build();
    }

    private void validateFactoryMethodReturnType(ValidationReport.Builder<TypeElement> builder, TypeElement componentElement, ErrorMessages.ComponentCreatorMessages msgs, ExecutableElement method, TypeMirror returnType) {
        if (this.types.isSameType(componentElement.asType(), returnType)) {
            return;
        }
        ImmutableSet<ExecutableElement> methodsOnlyInComponent = this.methodsOnlyInComponent(componentElement);
        if (!methodsOnlyInComponent.isEmpty()) {
            builder.addWarning(msgs.buildMethodReturnsSupertypeWithMissingMethods(componentElement, builder.getSubject(), returnType, method, (Set<ExecutableElement>)methodsOnlyInComponent), method);
        }
    }

    private static void error(ValidationReport.Builder<TypeElement> builder, ExecutableElement method, String enclosedError, String inheritedError, Object ... extraArgs) {
        if (method.getEnclosingElement().equals(builder.getSubject())) {
            builder.addError(String.format(enclosedError, extraArgs), method);
        } else {
            builder.addError(String.format(inheritedError, ComponentCreatorValidator.append(extraArgs, method)));
        }
    }

    private static Object[] append(Object[] initial, Object additional) {
        Object[] newArray = Arrays.copyOf(initial, initial.length + 1);
        newArray[initial.length] = additional;
        return newArray;
    }

    private ImmutableSet<ExecutableElement> methodsOnlyInComponent(TypeElement componentType) {
        return ImmutableSet.copyOf(ElementFilter.methodsIn(componentType.getEnclosedElements()));
    }
}

