/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.BindsInstance;
import dagger.internal.codegen.ComponentAnnotation;
import dagger.internal.codegen.FrameworkTypes;
import dagger.internal.codegen.ModuleAnnotation;
import dagger.internal.codegen.TypeCheckingProcessingStep;
import dagger.internal.codegen.ValidationReport;
import dagger.shaded.auto.common.MoreElements;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;

final class BindsInstanceProcessingStep
extends TypeCheckingProcessingStep<Element> {
    private final Messager messager;

    @Inject
    BindsInstanceProcessingStep(Messager messager) {
        super((Element element) -> element);
        this.messager = messager;
    }

    @Override
    public Set<? extends Class<? extends Annotation>> annotations() {
        return ImmutableSet.of(BindsInstance.class);
    }

    @Override
    protected void process(Element element, ImmutableSet<Class<? extends Annotation>> annotations) {
        ValidationReport.Builder<Element> report = ValidationReport.about(element);
        switch (element.getKind()) {
            case METHOD: {
                ExecutableElement method = MoreElements.asExecutable(element);
                this.validateBindsInstanceMethod(method, report);
                break;
            }
            case PARAMETER: {
                VariableElement parameter = MoreElements.asVariable(element);
                this.validateBindsInstanceParameterType(parameter, report);
                this.validateBindsInstanceParameterEnclosingMethod(parameter, report);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        report.build().printMessagesTo(this.messager);
    }

    private void validateBindsInstanceMethod(ExecutableElement method, ValidationReport.Builder<Element> report) {
        if (!method.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            report.addError("@BindsInstance methods must be abstract");
        }
        if (method.getParameters().size() != 1) {
            report.addError("@BindsInstance methods should have exactly one parameter for the bound type");
        } else {
            this.validateBindsInstanceParameterType((VariableElement)Iterables.getOnlyElement(method.getParameters()), report);
        }
        TypeElement enclosingType = MoreElements.asType(method.getEnclosingElement());
        ModuleAnnotation.moduleAnnotation(enclosingType).ifPresent(moduleAnnotation -> report.addError(BindsInstanceProcessingStep.didYouMeanBinds(moduleAnnotation)));
        ComponentAnnotation.anyComponentAnnotation(enclosingType).ifPresent(componentAnnotation -> report.addError(String.format("@BindsInstance methods should not be included in @%1$ss. Did you mean to put it in a @%1$s.Builder?", componentAnnotation.simpleName())));
    }

    private static String didYouMeanBinds(ModuleAnnotation moduleAnnotation) {
        return String.format("@BindsInstance methods should not be included in @%ss. Did you mean @Binds?", moduleAnnotation.annotationClass().getSimpleName());
    }

    private void validateBindsInstanceParameterType(VariableElement parameter, ValidationReport.Builder<Element> report) {
        if (FrameworkTypes.isFrameworkType(parameter.asType())) {
            report.addError("@BindsInstance parameters may not be framework types", parameter);
        }
    }

    private void validateBindsInstanceParameterEnclosingMethod(VariableElement parameter, ValidationReport.Builder<Element> report) {
        TypeKind returnKind;
        Element enclosing = parameter.getEnclosingElement();
        if (!enclosing.getKind().equals((Object)ElementKind.METHOD)) {
            report.addError("@BindsInstance should only be applied to methods or parameters of methods");
            return;
        }
        ExecutableElement method = MoreElements.asExecutable(enclosing);
        if (!method.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            report.addError("@BindsInstance parameters may only be used in abstract methods");
        }
        if (!(returnKind = method.getReturnType().getKind()).equals((Object)TypeKind.DECLARED) && !returnKind.equals((Object)TypeKind.TYPEVAR)) {
            report.addError("@BindsInstance parameters may not be used in methods with a void, array or primitive return type");
        }
    }
}

