/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import dagger.BindsOptionalOf;
import dagger.Module;
import dagger.internal.codegen.BindingMethodValidator;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.DependencyRequestValidator;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.internal.codegen.Keys;
import dagger.internal.codegen.ValidationReport;
import dagger.producers.ProducerModule;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;

final class BindsOptionalOfMethodValidator
extends BindingMethodValidator {
    private final DaggerTypes types;

    @Inject
    BindsOptionalOfMethodValidator(DaggerElements elements, DaggerTypes types, DependencyRequestValidator dependencyRequestValidator) {
        super(elements, types, BindsOptionalOf.class, (Iterable<? extends Class<? extends Annotation>>)ImmutableSet.of(Module.class, ProducerModule.class), dependencyRequestValidator, BindingMethodValidator.Abstractness.MUST_BE_ABSTRACT, BindingMethodValidator.ExceptionSuperclass.NO_EXCEPTIONS, BindingMethodValidator.AllowsMultibindings.NO_MULTIBINDINGS, BindingMethodValidator.AllowsScoping.NO_SCOPING);
        this.types = types;
    }

    @Override
    protected void checkMethod(ValidationReport.Builder<ExecutableElement> builder) {
        super.checkMethod(builder);
        this.checkParameters(builder);
    }

    @Override
    protected void checkKeyType(ValidationReport.Builder<ExecutableElement> builder, TypeMirror keyType) {
        super.checkKeyType(builder, keyType);
        if (Keys.isValidImplicitProvisionKey(InjectionAnnotations.getQualifiers(builder.getSubject()).stream().findFirst(), keyType, this.types) && !InjectionAnnotations.injectedConstructors(MoreElements.asType(MoreTypes.asDeclared(keyType).asElement())).isEmpty()) {
            builder.addError("@BindsOptionalOf methods cannot return unqualified types that have an @Inject-annotated constructor because those are always present");
        }
    }

    @Override
    protected void checkParameters(ValidationReport.Builder<ExecutableElement> builder) {
        if (!builder.getSubject().getParameters().isEmpty()) {
            builder.addError("@BindsOptionalOf methods cannot have parameters");
        }
    }
}

