/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingGraphFactory;
import dagger.internal.codegen.ClearableCache;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentGenerator;
import dagger.internal.codegen.ComponentImplementation;
import dagger.internal.codegen.CurrentImplementationSubcomponent;
import dagger.internal.codegen.KeyFactory;
import dagger.internal.codegen.SubcomponentNames;
import dagger.internal.codegen.TopLevelImplementationComponent;
import dagger.internal.codegen.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.lang.model.element.TypeElement;

@Singleton
final class ComponentImplementationFactory
implements ClearableCache {
    private final Map<TypeElement, ComponentImplementation> topLevelComponentCache = new HashMap<TypeElement, ComponentImplementation>();
    private final KeyFactory keyFactory;
    private final CompilerOptions compilerOptions;
    private final BindingGraphFactory bindingGraphFactory;
    private final TopLevelImplementationComponent.Builder topLevelImplementationComponentBuilder;

    @Inject
    ComponentImplementationFactory(KeyFactory keyFactory, CompilerOptions compilerOptions, BindingGraphFactory bindingGraphFactory, TopLevelImplementationComponent.Builder topLevelImplementationComponentBuilder) {
        this.keyFactory = keyFactory;
        this.compilerOptions = compilerOptions;
        this.bindingGraphFactory = bindingGraphFactory;
        this.topLevelImplementationComponentBuilder = topLevelImplementationComponentBuilder;
    }

    ComponentImplementation createComponentImplementation(BindingGraph bindingGraph) {
        return Util.reentrantComputeIfAbsent(this.topLevelComponentCache, bindingGraph.componentTypeElement(), component -> this.createComponentImplementationUncached(bindingGraph));
    }

    private ComponentImplementation createComponentImplementationUncached(BindingGraph bindingGraph) {
        ComponentImplementation componentImplementation = ComponentImplementation.topLevelComponentImplementation(bindingGraph, ComponentGenerator.componentName(bindingGraph.componentTypeElement()), new SubcomponentNames(bindingGraph, this.keyFactory));
        CurrentImplementationSubcomponent currentImplementationSubcomponent = this.topLevelImplementationComponentBuilder.topLevelComponent(componentImplementation).build().currentImplementationSubcomponentBuilder().componentImplementation(componentImplementation).bindingGraph(bindingGraph).parentBuilder(Optional.empty()).parentBindingExpressions(Optional.empty()).parentRequirementExpressions(Optional.empty()).build();
        if (componentImplementation.isAbstract()) {
            Preconditions.checkState((boolean)this.compilerOptions.aheadOfTimeSubcomponents(), (String)"Calling 'componentImplementation()' on %s when not generating ahead-of-time subcomponents.", (Object)bindingGraph.componentTypeElement());
            return currentImplementationSubcomponent.subcomponentBuilder().build();
        }
        return currentImplementationSubcomponent.rootComponentBuilder().build();
    }

    ComponentImplementation findChildSuperclassImplementation(ComponentDescriptor child, ComponentImplementation parentImplementation) {
        Optional<ComponentImplementation> parent = parentImplementation.superclassImplementation();
        while (parent.isPresent()) {
            Optional<ComponentImplementation> superclass = parent.get().childImplementation(child);
            if (superclass.isPresent()) {
                return superclass.get();
            }
            parent = parent.get().superclassImplementation();
        }
        BindingGraph truncatedBindingGraph = this.bindingGraphFactory.create(child, false);
        return this.createComponentImplementation(truncatedBindingGraph);
    }

    @Override
    public void clearCache() {
        this.topLevelComponentCache.clear();
    }
}

