/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.MethodSpec;
import dagger.internal.codegen.BindingExpression;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingRequest;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentBindingExpressions;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentImplementation;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.DeferredModifiableBindingExpression;
import dagger.internal.codegen.MethodBindingExpression;
import dagger.internal.codegen.MissingBindingExpression;
import dagger.internal.codegen.ModifiableBindingMethods;
import dagger.internal.codegen.ModifiableBindingType;
import dagger.internal.codegen.ModifiableConcreteMethodBindingExpression;
import dagger.internal.codegen.PrunedConcreteMethodBindingExpression;
import dagger.internal.codegen.RequestKinds;
import dagger.internal.codegen.ResolvedBindings;
import dagger.model.BindingKind;
import dagger.model.DependencyRequest;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;

final class ModifiableBindingExpressions {
    private final Optional<ModifiableBindingExpressions> parent;
    private final ComponentBindingExpressions bindingExpressions;
    private final BindingGraph graph;
    private final ComponentImplementation componentImplementation;
    private final CompilerOptions compilerOptions;
    private final DaggerTypes types;

    ModifiableBindingExpressions(Optional<ModifiableBindingExpressions> parent, ComponentBindingExpressions bindingExpressions, BindingGraph graph, ComponentImplementation componentImplementation, CompilerOptions compilerOptions, DaggerTypes types) {
        this.parent = parent;
        this.bindingExpressions = bindingExpressions;
        this.graph = graph;
        this.componentImplementation = componentImplementation;
        this.compilerOptions = compilerOptions;
        this.types = types;
    }

    ModifiableBindingType registerComponentMethodIfModifiable(ComponentDescriptor.ComponentMethodDescriptor componentMethod, MethodSpec method) {
        BindingRequest request = BindingRequest.bindingRequest(componentMethod.dependencyRequest().get());
        ModifiableBindingType modifiableBindingType = this.getModifiableBindingType(request);
        if (modifiableBindingType.isModifiable()) {
            this.componentImplementation.registerModifiableBindingMethod(modifiableBindingType, request, componentMethod.resolvedReturnType(this.types), method, this.newModifiableBindingWillBeFinalized(modifiableBindingType, request));
        }
        return modifiableBindingType;
    }

    Optional<ModifiableBindingMethods.ModifiableBindingMethod> possiblyReimplementedMethod(ModifiableBindingMethods.ModifiableBindingMethod modifiableBindingMethod) {
        Preconditions.checkState((boolean)this.componentImplementation.superclassImplementation().isPresent());
        BindingRequest request = modifiableBindingMethod.request();
        ModifiableBindingType newModifiableBindingType = this.getModifiableBindingType(request);
        ModifiableBindingType oldModifiableBindingType = modifiableBindingMethod.type();
        boolean modifiableBindingTypeChanged = !newModifiableBindingType.equals((Object)oldModifiableBindingType);
        ResolvedBindings resolvedBindings = this.graph.resolvedBindings(request);
        if ((modifiableBindingTypeChanged || newModifiableBindingType.equals((Object)ModifiableBindingType.MULTIBINDING)) && resolvedBindings != null && resolvedBindings.bindingType().equals((Object)BindingType.PRODUCTION) && !request.canBeSatisfiedByProductionBinding()) {
            return oldModifiableBindingType.hasBaseClassImplementation() ? Optional.empty() : Optional.of(this.reimplementedMethod(modifiableBindingMethod, newModifiableBindingType, new PrunedConcreteMethodBindingExpression(), this.componentImplementation.isAbstract()));
        }
        if (modifiableBindingTypeChanged && !newModifiableBindingType.hasBaseClassImplementation() && (oldModifiableBindingType.hasBaseClassImplementation() || this.componentImplementation.isAbstract())) {
            return Optional.empty();
        }
        if (modifiableBindingTypeChanged || this.shouldModifyImplementation(newModifiableBindingType, request)) {
            boolean markMethodFinal = this.knownModifiableBindingWillBeFinalized(modifiableBindingMethod) && this.componentImplementation.isAbstract();
            return Optional.of(this.reimplementedMethod(modifiableBindingMethod, newModifiableBindingType, this.bindingExpressions.getBindingExpression(request), markMethodFinal));
        }
        return Optional.empty();
    }

    private ModifiableBindingMethods.ModifiableBindingMethod reimplementedMethod(ModifiableBindingMethods.ModifiableBindingMethod supertypeMethod, ModifiableBindingType newModifiableBindingType, BindingExpression bindingExpression, boolean markMethodFinal) {
        MethodSpec baseMethod = supertypeMethod.methodSpec();
        return supertypeMethod.reimplement(newModifiableBindingType, MethodSpec.methodBuilder((String)baseMethod.name).addModifiers(new Modifier[]{baseMethod.modifiers.contains((Object)Modifier.PUBLIC) ? Modifier.PUBLIC : Modifier.PROTECTED}).addModifiers((Iterable)(markMethodFinal ? ImmutableSet.of((Object)((Object)Modifier.FINAL)) : ImmutableSet.of())).returns(baseMethod.returnType).addAnnotation(Override.class).addCode(bindingExpression.getModifiableBindingMethodImplementation(supertypeMethod, this.componentImplementation, this.types)).build(), markMethodFinal);
    }

    private boolean knownModifiableBindingWillBeFinalized(ModifiableBindingMethods.ModifiableBindingMethod modifiableBindingMethod) {
        ModifiableBindingType newModifiableBindingType = this.getModifiableBindingType(modifiableBindingMethod.request());
        if (!newModifiableBindingType.isModifiable()) {
            return true;
        }
        return this.modifiableBindingWillBeFinalized(newModifiableBindingType, this.shouldModifyImplementation(newModifiableBindingType, modifiableBindingMethod.request()));
    }

    private boolean newModifiableBindingWillBeFinalized(ModifiableBindingType modifiableBindingType, BindingRequest request) {
        return this.modifiableBindingWillBeFinalized(modifiableBindingType, this.shouldModifyImplementation(modifiableBindingType, request));
    }

    private boolean modifiableBindingWillBeFinalized(ModifiableBindingType modifiableBindingType, boolean modifyingBinding) {
        switch (modifiableBindingType) {
            case MISSING: 
            case BINDS_METHOD_WITH_MISSING_DEPENDENCY: 
            case GENERATED_INSTANCE: 
            case OPTIONAL: 
            case INJECTION: {
                return modifyingBinding;
            }
            case MULTIBINDING: {
                return false;
            }
        }
        throw new IllegalStateException(String.format("Building binding expression for unsupported ModifiableBindingType [%s].", new Object[]{modifiableBindingType}));
    }

    Optional<BindingExpression> maybeCreateModifiableBindingExpression(BindingRequest request) {
        ModifiableBindingType type = this.getModifiableBindingType(request);
        if (!type.isModifiable()) {
            return Optional.empty();
        }
        return Optional.of(this.createModifiableBindingExpression(type, request));
    }

    private BindingExpression createModifiableBindingExpression(ModifiableBindingType type, BindingRequest request) {
        ResolvedBindings resolvedBindings = this.graph.resolvedBindings(request);
        Optional<ModifiableBindingMethods.ModifiableBindingMethod> matchingModifiableBindingMethod = this.componentImplementation.getModifiableBindingMethod(request);
        Optional<ComponentDescriptor.ComponentMethodDescriptor> matchingComponentMethod = this.graph.componentDescriptor().firstMatchingComponentMethod(request);
        switch (type) {
            case GENERATED_INSTANCE: {
                if (this.componentImplementation.isAbstract()) {
                    return new DeferredModifiableBindingExpression(this.componentImplementation, type, resolvedBindings.contributionBinding(), request, matchingModifiableBindingMethod, matchingComponentMethod, this.types);
                }
                return this.bindingExpressions.createBindingExpression(resolvedBindings, request);
            }
            case MISSING: {
                if (this.componentImplementation.isAbstract()) {
                    return new MissingBindingExpression(this.componentImplementation, request, matchingModifiableBindingMethod, matchingComponentMethod, this.types);
                }
                return new PrunedConcreteMethodBindingExpression();
            }
            case BINDS_METHOD_WITH_MISSING_DEPENDENCY: {
                Preconditions.checkState((boolean)this.componentImplementation.isAbstract());
                return new DeferredModifiableBindingExpression(this.componentImplementation, type, resolvedBindings.contributionBinding(), request, matchingModifiableBindingMethod, matchingComponentMethod, this.types);
            }
            case OPTIONAL: 
            case INJECTION: 
            case MULTIBINDING: {
                return this.bindingExpressions.wrapInMethod(resolvedBindings, request, this.bindingExpressions.createBindingExpression(resolvedBindings, request));
            }
        }
        throw new IllegalStateException(String.format("Building binding expression for unsupported ModifiableBindingType [%s].", new Object[]{type}));
    }

    ModifiableBindingType getModifiableBindingType(BindingRequest request) {
        if (!this.compilerOptions.aheadOfTimeSubcomponents()) {
            return ModifiableBindingType.NONE;
        }
        if (!this.componentImplementation.componentDescriptor().isSubcomponent()) {
            return ModifiableBindingType.NONE;
        }
        if (request.requestKind().filter(RequestKinds::isDerivedFromProvider).isPresent()) {
            return ModifiableBindingType.NONE;
        }
        if (this.resolvedInThisComponent(request)) {
            ResolvedBindings resolvedBindings = this.graph.resolvedBindings(request);
            if (resolvedBindings.contributionBindings().isEmpty()) {
                return ModifiableBindingType.NONE;
            }
            ContributionBinding binding = resolvedBindings.contributionBinding();
            if (binding.requiresGeneratedInstance()) {
                return ModifiableBindingType.GENERATED_INSTANCE;
            }
            if (binding.kind().equals((Object)BindingKind.DELEGATE) && ((ResolvedBindings)this.graph.contributionBindings().get((Object)((DependencyRequest)Iterables.getOnlyElement(binding.dependencies())).key())).isEmpty()) {
                return ModifiableBindingType.BINDS_METHOD_WITH_MISSING_DEPENDENCY;
            }
            if (binding.kind().equals((Object)BindingKind.OPTIONAL) && binding.dependencies().isEmpty()) {
                return ModifiableBindingType.OPTIONAL;
            }
            if (binding.isSyntheticMultibinding()) {
                return ModifiableBindingType.MULTIBINDING;
            }
            if (binding.kind().equals((Object)BindingKind.INJECTION)) {
                return ModifiableBindingType.INJECTION;
            }
        } else if (!this.resolvableBinding(request)) {
            return ModifiableBindingType.MISSING;
        }
        return ModifiableBindingType.NONE;
    }

    private boolean shouldModifyImplementation(ModifiableBindingType modifiableBindingType, BindingRequest request) {
        ResolvedBindings resolvedBindings = this.graph.resolvedBindings(request);
        if (request.requestKind().isPresent()) {
            switch (request.requestKind().get()) {
                case FUTURE: {
                    if (this.componentImplementation.superclassImplementation().isPresent()) {
                        return this.bindingTypeChanged(request, resolvedBindings);
                    }
                    return false;
                }
                case LAZY: 
                case PROVIDER_OF_LAZY: {
                    return false;
                }
                case MEMBERS_INJECTION: 
                case PRODUCED: {
                    throw new AssertionError(request);
                }
            }
        }
        switch (modifiableBindingType) {
            case GENERATED_INSTANCE: {
                return !this.componentImplementation.isAbstract();
            }
            case MISSING: {
                return this.resolvableBinding(request) || !this.componentImplementation.isAbstract();
            }
            case BINDS_METHOD_WITH_MISSING_DEPENDENCY: {
                DependencyRequest dependency = (DependencyRequest)Iterables.getOnlyElement(resolvedBindings.contributionBinding().dependencies());
                return !((ResolvedBindings)this.graph.contributionBindings().get((Object)dependency.key())).isEmpty();
            }
            case OPTIONAL: {
                return !resolvedBindings.contributionBinding().dependencies().isEmpty();
            }
            case MULTIBINDING: {
                return !this.componentImplementation.superclassContributionsMade(request).containsAll((Collection)resolvedBindings.contributionBinding().dependencies().stream().map(DependencyRequest::key).collect(Collectors.toList()));
            }
            case INJECTION: {
                return !resolvedBindings.contributionBinding().kind().equals((Object)BindingKind.INJECTION);
            }
        }
        throw new IllegalStateException(String.format("Overriding modifiable binding method with unsupported ModifiableBindingType [%s].", new Object[]{modifiableBindingType}));
    }

    private boolean bindingTypeChanged(BindingRequest request, ResolvedBindings resolvedBindings) {
        BindingGraph superclassGraph = this.componentImplementation.superclassImplementation().get().graph();
        ResolvedBindings superclassBindings = superclassGraph.resolvedBindings(request);
        return superclassBindings != null && resolvedBindings != null && !superclassBindings.bindingType().equals((Object)resolvedBindings.bindingType());
    }

    private boolean resolvableBinding(BindingRequest request) {
        ModifiableBindingExpressions expressions = this;
        while (expressions != null) {
            if (expressions.resolvedInThisComponent(request)) {
                return true;
            }
            expressions = expressions.parent.orElse(null);
        }
        return false;
    }

    private boolean resolvedInThisComponent(BindingRequest request) {
        ResolvedBindings resolvedBindings = this.graph.resolvedBindings(request);
        return resolvedBindings != null && !resolvedBindings.bindingsOwnedBy(this.graph.componentDescriptor()).isEmpty();
    }

    BindingExpression wrapInModifiableMethodBindingExpression(BindingRequest request, ResolvedBindings resolvedBindings, MethodBindingExpression.MethodImplementationStrategy methodImplementationStrategy, BindingExpression wrappedBindingExpression) {
        ModifiableBindingType modifiableBindingType = this.getModifiableBindingType(request);
        Preconditions.checkState((boolean)modifiableBindingType.isModifiable());
        return new ModifiableConcreteMethodBindingExpression(request, resolvedBindings, methodImplementationStrategy, wrappedBindingExpression, modifiableBindingType, this.componentImplementation, this.newModifiableBindingWillBeFinalized(modifiableBindingType, request), this.types);
    }
}

