/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.Traverser;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import dagger.internal.codegen.AutoValue_ValidationReport;
import dagger.internal.codegen.AutoValue_ValidationReport_Item;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.DaggerStreams;
import java.util.Optional;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;

@AutoValue
abstract class ValidationReport<T extends Element> {
    private static final Traverser<ValidationReport<?>> SUBREPORTS = Traverser.forTree(ValidationReport::subreports);

    ValidationReport() {
    }

    abstract T subject();

    abstract ImmutableSet<Item> items();

    ImmutableSet<Item> allItems() {
        return this.allReports().stream().flatMap(report -> report.items().stream()).collect(DaggerStreams.toImmutableSet());
    }

    abstract ImmutableSet<ValidationReport<?>> subreports();

    ImmutableSet<ValidationReport<?>> allReports() {
        return ImmutableSet.copyOf((Iterable)SUBREPORTS.depthFirstPreOrder((Object)this));
    }

    abstract boolean markedDirty();

    boolean isClean() {
        if (this.markedDirty()) {
            return false;
        }
        for (Item item : this.items()) {
            switch (item.kind()) {
                case ERROR: {
                    return false;
                }
            }
        }
        for (ValidationReport subreport : this.subreports()) {
            if (subreport.isClean()) continue;
            return false;
        }
        return true;
    }

    void printMessagesTo(Messager messager) {
        for (Item item : this.items()) {
            if (ValidationReport.isEnclosedIn(this.subject(), item.element())) {
                if (item.annotation().isPresent()) {
                    if (item.annotationValue().isPresent()) {
                        messager.printMessage(item.kind(), item.message(), item.element(), item.annotation().get(), item.annotationValue().get());
                        continue;
                    }
                    messager.printMessage(item.kind(), item.message(), item.element(), item.annotation().get());
                    continue;
                }
                messager.printMessage(item.kind(), item.message(), item.element());
                continue;
            }
            String message = String.format("[%s] %s", DaggerElements.elementToString(item.element()), item.message());
            messager.printMessage(item.kind(), message, (Element)this.subject());
        }
        for (ValidationReport subreport : this.subreports()) {
            subreport.printMessagesTo(messager);
        }
    }

    private static boolean isEnclosedIn(Element parent, Element child) {
        for (Element current = child; current != null; current = current.getEnclosingElement()) {
            if (!current.equals(parent)) continue;
            return true;
        }
        return false;
    }

    static <T extends Element> Builder<T> about(T subject) {
        return new Builder(subject, null);
    }

    @CanIgnoreReturnValue
    static final class Builder<T extends Element> {
        private final T subject;
        private final ImmutableSet.Builder<Item> items = ImmutableSet.builder();
        private final ImmutableSet.Builder<ValidationReport<?>> subreports = ImmutableSet.builder();
        private boolean markedDirty;

        private Builder(T subject) {
            this.subject = subject;
        }

        @CheckReturnValue
        T getSubject() {
            return this.subject;
        }

        Builder<T> addItems(Iterable<Item> newItems) {
            this.items.addAll(newItems);
            return this;
        }

        Builder<T> addError(String message) {
            return this.addError(message, (Element)this.subject);
        }

        Builder<T> addError(String message, Element element) {
            return this.addItem(message, Diagnostic.Kind.ERROR, element);
        }

        Builder<T> addError(String message, Element element, AnnotationMirror annotation) {
            return this.addItem(message, Diagnostic.Kind.ERROR, element, annotation);
        }

        Builder<T> addError(String message, Element element, AnnotationMirror annotation, AnnotationValue annotationValue) {
            return this.addItem(message, Diagnostic.Kind.ERROR, element, annotation, annotationValue);
        }

        Builder<T> addWarning(String message) {
            return this.addWarning(message, (Element)this.subject);
        }

        Builder<T> addWarning(String message, Element element) {
            return this.addItem(message, Diagnostic.Kind.WARNING, element);
        }

        Builder<T> addWarning(String message, Element element, AnnotationMirror annotation) {
            return this.addItem(message, Diagnostic.Kind.WARNING, element, annotation);
        }

        Builder<T> addWarning(String message, Element element, AnnotationMirror annotation, AnnotationValue annotationValue) {
            return this.addItem(message, Diagnostic.Kind.WARNING, element, annotation, annotationValue);
        }

        Builder<T> addNote(String message) {
            return this.addNote(message, (Element)this.subject);
        }

        Builder<T> addNote(String message, Element element) {
            return this.addItem(message, Diagnostic.Kind.NOTE, element);
        }

        Builder<T> addNote(String message, Element element, AnnotationMirror annotation) {
            return this.addItem(message, Diagnostic.Kind.NOTE, element, annotation);
        }

        Builder<T> addNote(String message, Element element, AnnotationMirror annotation, AnnotationValue annotationValue) {
            return this.addItem(message, Diagnostic.Kind.NOTE, element, annotation, annotationValue);
        }

        Builder<T> addItem(String message, Diagnostic.Kind kind, Element element) {
            return this.addItem(message, kind, element, Optional.empty(), Optional.empty());
        }

        Builder<T> addItem(String message, Diagnostic.Kind kind, Element element, AnnotationMirror annotation) {
            return this.addItem(message, kind, element, Optional.of(annotation), Optional.empty());
        }

        Builder<T> addItem(String message, Diagnostic.Kind kind, Element element, AnnotationMirror annotation, AnnotationValue annotationValue) {
            return this.addItem(message, kind, element, Optional.of(annotation), Optional.of(annotationValue));
        }

        private Builder<T> addItem(String message, Diagnostic.Kind kind, Element element, Optional<AnnotationMirror> annotation, Optional<AnnotationValue> annotationValue) {
            this.items.add((Object)new AutoValue_ValidationReport_Item(message, kind, element, annotation, annotationValue));
            return this;
        }

        void markDirty() {
            this.markedDirty = true;
        }

        Builder<T> addSubreport(ValidationReport<?> subreport) {
            this.subreports.add(subreport);
            return this;
        }

        @CheckReturnValue
        ValidationReport<T> build() {
            return new AutoValue_ValidationReport<T>(this.subject, (ImmutableSet<Item>)this.items.build(), this.subreports.build(), this.markedDirty);
        }

        /* synthetic */ Builder(Element x0, 1 x1) {
            this(x0);
        }
    }

    @AutoValue
    static abstract class Item {
        Item() {
        }

        abstract String message();

        abstract Diagnostic.Kind kind();

        abstract Element element();

        abstract Optional<AnnotationMirror> annotation();

        abstract Optional<AnnotationValue> annotationValue();
    }
}

