
package dagger.internal.codegen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.Optional;
import javax.annotation.Generated;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_InjectionMethod extends InjectionMethod {

  private final String name;
  private final boolean varargs;
  private final ImmutableList<TypeVariableName> typeVariables;
  private final ImmutableMap<ParameterSpec, TypeMirror> parameters;
  private final Optional<TypeMirror> returnType;
  private final Optional<DeclaredType> nullableAnnotation;
  private final ImmutableList<TypeMirror> exceptions;
  private final CodeBlock methodBody;
  private final ClassName enclosingClass;

  private AutoValue_InjectionMethod(
      String name,
      boolean varargs,
      ImmutableList<TypeVariableName> typeVariables,
      ImmutableMap<ParameterSpec, TypeMirror> parameters,
      Optional<TypeMirror> returnType,
      Optional<DeclaredType> nullableAnnotation,
      ImmutableList<TypeMirror> exceptions,
      CodeBlock methodBody,
      ClassName enclosingClass) {
    this.name = name;
    this.varargs = varargs;
    this.typeVariables = typeVariables;
    this.parameters = parameters;
    this.returnType = returnType;
    this.nullableAnnotation = nullableAnnotation;
    this.exceptions = exceptions;
    this.methodBody = methodBody;
    this.enclosingClass = enclosingClass;
  }

  @Override
  String name() {
    return name;
  }

  @Override
  boolean varargs() {
    return varargs;
  }

  @Override
  ImmutableList<TypeVariableName> typeVariables() {
    return typeVariables;
  }

  @Override
  ImmutableMap<ParameterSpec, TypeMirror> parameters() {
    return parameters;
  }

  @Override
  Optional<TypeMirror> returnType() {
    return returnType;
  }

  @Override
  Optional<DeclaredType> nullableAnnotation() {
    return nullableAnnotation;
  }

  @Override
  ImmutableList<TypeMirror> exceptions() {
    return exceptions;
  }

  @Override
  CodeBlock methodBody() {
    return methodBody;
  }

  @Override
  ClassName enclosingClass() {
    return enclosingClass;
  }

  @Override
  public String toString() {
    return "InjectionMethod{"
        + "name=" + name + ", "
        + "varargs=" + varargs + ", "
        + "typeVariables=" + typeVariables + ", "
        + "parameters=" + parameters + ", "
        + "returnType=" + returnType + ", "
        + "nullableAnnotation=" + nullableAnnotation + ", "
        + "exceptions=" + exceptions + ", "
        + "methodBody=" + methodBody + ", "
        + "enclosingClass=" + enclosingClass
        + "}";
  }

  static final class Builder extends InjectionMethod.Builder {
    private String name;
    private Boolean varargs;
    private ImmutableList.Builder<TypeVariableName> typeVariablesBuilder$;
    private ImmutableList<TypeVariableName> typeVariables;
    private ImmutableMap.Builder<ParameterSpec, TypeMirror> parametersBuilder$;
    private ImmutableMap<ParameterSpec, TypeMirror> parameters;
    private Optional<TypeMirror> returnType = Optional.empty();
    private Optional<DeclaredType> nullableAnnotation = Optional.empty();
    private ImmutableList<TypeMirror> exceptions;
    private CodeBlock methodBody;
    private ClassName enclosingClass;
    Builder() {
      this.typeVariables = ImmutableList.of();
      this.parameters = ImmutableMap.of();
    }
    Builder(InjectionMethod source) {
      this.name = source.name();
      this.varargs = source.varargs();
      this.typeVariables = source.typeVariables();
      this.parameters = source.parameters();
      this.returnType = source.returnType();
      this.nullableAnnotation = source.nullableAnnotation();
      this.exceptions = source.exceptions();
      this.methodBody = source.methodBody();
      this.enclosingClass = source.enclosingClass();
    }
    @Override
    public InjectionMethod.Builder name(String name) {
      this.name = name;
      return this;
    }
    @Override
    public InjectionMethod.Builder varargs(boolean varargs) {
      this.varargs = varargs;
      return this;
    }
    @Override
    public ImmutableList.Builder<TypeVariableName> typeVariablesBuilder() {
      if (typeVariablesBuilder$ == null) {
        typeVariablesBuilder$ = ImmutableList.builder();
        typeVariablesBuilder$.addAll(typeVariables);
        typeVariables = null;
      }
      return typeVariablesBuilder$;
    }
    @Override
    public ImmutableMap.Builder<ParameterSpec, TypeMirror> parametersBuilder() {
      if (parametersBuilder$ == null) {
        parametersBuilder$ = ImmutableMap.builder();
        parametersBuilder$.putAll(parameters);
        parameters = null;
      }
      return parametersBuilder$;
    }
    @Override
    public InjectionMethod.Builder returnType(TypeMirror returnType) {
      this.returnType = Optional.of(returnType);
      return this;
    }
    @Override
    public InjectionMethod.Builder nullableAnnotation(Optional<DeclaredType> nullableAnnotation) {
      this.nullableAnnotation = nullableAnnotation;
      return this;
    }
    @Override
    public InjectionMethod.Builder exceptions(Iterable<? extends TypeMirror> exceptions) {
      this.exceptions = ImmutableList.copyOf(exceptions);
      return this;
    }
    @Override
    public InjectionMethod.Builder methodBody(CodeBlock methodBody) {
      this.methodBody = methodBody;
      return this;
    }
    @Override
    public InjectionMethod.Builder enclosingClass(ClassName enclosingClass) {
      this.enclosingClass = enclosingClass;
      return this;
    }
    @Override
    public InjectionMethod buildInternal() {
      if (typeVariablesBuilder$ != null) {
        typeVariables = typeVariablesBuilder$.build();
      }
      if (parametersBuilder$ != null) {
        parameters = parametersBuilder$.build();
      }
      String missing = "";
      if (name == null) {
        missing += " name";
      }
      if (varargs == null) {
        missing += " varargs";
      }
      if (exceptions == null) {
        missing += " exceptions";
      }
      if (methodBody == null) {
        missing += " methodBody";
      }
      if (enclosingClass == null) {
        missing += " enclosingClass";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_InjectionMethod(
          this.name,
          this.varargs,
          this.typeVariables,
          this.parameters,
          this.returnType,
          this.nullableAnnotation,
          this.exceptions,
          this.methodBody,
          this.enclosingClass);
    }
  }

}
