package dagger.internal.codegen;

import com.google.auto.common.BasicAnnotationProcessor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import dagger.internal.SetFactory;
import dagger.internal.SingleCheck;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.langmodel.DaggerTypes_Factory;
import dagger.spi.BindingGraphPlugin;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.processing.Filer;
import javax.inject.Provider;
import javax.lang.model.element.TypeElement;

@Generated(
  value = "dagger.internal.codegen.ComponentProcessor",
  comments = "https://google.github.io/dagger"
)
public final class DaggerComponentProcessor_ProcessorComponent
    implements ComponentProcessor.ProcessorComponent {
  private SourceFileGeneratorsModule.ProvisionModule provisionModule;

  private ProcessingEnvironmentModule processingEnvironmentModule;

  private SourceFileGeneratorsModule.MembersInjectionModule membersInjectionModule;

  private SourceFileGeneratorsModule.ProductionModule productionModule;

  private SourceFileGeneratorsModule.ComponentModule componentModule;

  private ProcessingEnvironmentModule_DaggerElementsFactory daggerElementsProvider;

  private ProcessingEnvironmentModule_TypesFactory typesProvider;

  private DaggerTypes_Factory daggerTypesProvider;

  private ProcessingEnvironmentModule_MessagerFactory messagerProvider;

  private DependencyRequestValidator_Factory dependencyRequestValidatorProvider;

  private Provider<CompilerOptions> compilerOptionsProvider;

  private InjectValidator_Factory injectValidatorProvider;

  private TypeProtoConverter_Factory typeProtoConverterProvider;

  private AnnotationProtoConverter_Factory annotationProtoConverterProvider;

  private KeyFactory_Factory keyFactoryProvider;

  private DependencyRequestFactory_Factory dependencyRequestFactoryProvider;

  private InjectionSiteFactory_Factory injectionSiteFactoryProvider;

  private BindingFactory_Factory bindingFactoryProvider;

  private Provider<InjectBindingRegistryImpl> injectBindingRegistryImplProvider;

  private ProvidesMethodValidator_Factory providesMethodValidatorProvider;

  private ProducesMethodValidator_Factory producesMethodValidatorProvider;

  private BindsMethodValidator_Factory bindsMethodValidatorProvider;

  private MultibindsMethodValidator_Factory multibindsMethodValidatorProvider;

  private BindsOptionalOfMethodValidator_Factory bindsOptionalOfMethodValidatorProvider;

  private Provider<Set<BindingMethodValidator>> setOfBindingMethodValidatorProvider;

  private BindingMethodValidatorsModule_IndexValidatorsFactory indexValidatorsProvider;

  private AnyBindingMethodValidator_Factory anyBindingMethodValidatorProvider;

  private MethodSignatureFormatter_Factory methodSignatureFormatterProvider;

  private MultibindingDeclaration_Factory_Factory factoryProvider;

  private DelegateDeclaration_Factory_Factory factoryProvider2;

  private SubcomponentDeclaration_Factory_Factory factoryProvider3;

  private OptionalBindingDeclaration_Factory_Factory factoryProvider4;

  private Provider<ModuleDescriptor.Factory> factoryProvider5;

  private ComponentDescriptorFactory_Factory componentDescriptorFactoryProvider;

  private Provider<BindingGraphFactory> bindingGraphFactoryProvider;

  private BindingDeclarationFormatter_Factory bindingDeclarationFormatterProvider;

  private BindingGraphConverter_Factory bindingGraphConverterProvider;

  private DependencyRequestFormatter_Factory dependencyRequestFormatterProvider;

  private DependencyCycleValidator_Factory dependencyCycleValidatorProvider;

  private DependsOnProductionExecutorValidator_Factory dependsOnProductionExecutorValidatorProvider;

  private DuplicateBindingsValidator_Factory duplicateBindingsValidatorProvider;

  private IncompatiblyScopedBindingsValidator_Factory incompatiblyScopedBindingsValidatorProvider;

  private InjectBindingValidator_Factory injectBindingValidatorProvider;

  private MapMultibindingValidator_Factory mapMultibindingValidatorProvider;

  private MissingBindingValidator_Factory missingBindingValidatorProvider;

  private NullableBindingValidator_Factory nullableBindingValidatorProvider;

  private SubcomponentFactoryMethodValidator_Factory subcomponentFactoryMethodValidatorProvider;

  private Provider<Set<BindingGraphPlugin>> validationSetOfBindingGraphPluginProvider;

  private Provider<Optional<ImmutableSet<BindingGraphPlugin>>> testingPluginsProvider;

  private Provider<ImmutableSet<BindingGraphPlugin>> externalPluginsProvider;

  private DiagnosticReporterFactory_Factory diagnosticReporterFactoryProvider;

  private Provider<BindingGraphValidator> bindingGraphValidatorProvider;

  private Provider<ModuleValidator> moduleValidatorProvider;

  private Provider<TopLevelImplementationComponent.Builder>
      topLevelImplementationComponentBuilderProvider;

  private ComponentCreatorImplementationFactory_Factory
      componentCreatorImplementationFactoryProvider;

  private DeserializedComponentImplementationBuilder_Factory
      deserializedComponentImplementationBuilderProvider;

  private Provider<ComponentImplementationFactory> componentImplementationFactoryProvider;

  private ProcessingEnvironmentModule_DaggerStatisticsRecorderFactory
      daggerStatisticsRecorderProvider;

  private Provider<DaggerStatisticsCollector> daggerStatisticsCollectorProvider;

  private ProcessingEnvironmentModule_SourceVersionFactory sourceVersionProvider;

  private DaggerComponentProcessor_ProcessorComponent(Builder builder) {
    initialize(builder);
  }

  public static ComponentProcessor.ProcessorComponent.Builder builder() {
    return new Builder();
  }

  private Filer getFiler() {
    return ProcessingEnvironmentModule_FilerFactory.proxyFiler(
        processingEnvironmentModule, compilerOptionsProvider.get());
  }

  private DaggerTypes getDaggerTypes() {
    return new DaggerTypes(
        ProcessingEnvironmentModule_TypesFactory.proxyTypes(processingEnvironmentModule),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule));
  }

  private FactoryGenerator getFactoryGenerator() {
    return new FactoryGenerator(
        getFiler(),
        ProcessingEnvironmentModule_SourceVersionFactory.proxySourceVersion(
            processingEnvironmentModule),
        getDaggerTypes(),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        compilerOptionsProvider.get());
  }

  private SourceFileGenerator<ProvisionBinding> getSourceFileGeneratorOfProvisionBinding() {
    return SourceFileGeneratorsModule_GeneratorModule_GeneratorFactory.proxyGenerator(
        provisionModule, getFactoryGenerator(), compilerOptionsProvider.get());
  }

  private MembersInjectorGenerator getMembersInjectorGenerator() {
    return new MembersInjectorGenerator(
        getFiler(),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        getDaggerTypes(),
        ProcessingEnvironmentModule_SourceVersionFactory.proxySourceVersion(
            processingEnvironmentModule));
  }

  private SourceFileGenerator<MembersInjectionBinding>
      getSourceFileGeneratorOfMembersInjectionBinding() {
    return SourceFileGeneratorsModule_GeneratorModule_GeneratorFactory.proxyGenerator(
        membersInjectionModule, getMembersInjectorGenerator(), compilerOptionsProvider.get());
  }

  private MapKeyValidator getMapKeyValidator() {
    return new MapKeyValidator(
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule));
  }

  private AnnotationCreatorGenerator getAnnotationCreatorGenerator() {
    return new AnnotationCreatorGenerator(
        getFiler(),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_SourceVersionFactory.proxySourceVersion(
            processingEnvironmentModule));
  }

  private UnwrappedMapKeyGenerator getUnwrappedMapKeyGenerator() {
    return new UnwrappedMapKeyGenerator(
        getFiler(),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_SourceVersionFactory.proxySourceVersion(
            processingEnvironmentModule));
  }

  private MapKeyProcessingStep getMapKeyProcessingStep() {
    return new MapKeyProcessingStep(
        ProcessingEnvironmentModule_MessagerFactory.proxyMessager(processingEnvironmentModule),
        getDaggerTypes(),
        getMapKeyValidator(),
        getAnnotationCreatorGenerator(),
        getUnwrappedMapKeyGenerator());
  }

  private InjectProcessingStep getInjectProcessingStep() {
    return new InjectProcessingStep(injectBindingRegistryImplProvider.get());
  }

  private MonitoringModuleGenerator getMonitoringModuleGenerator() {
    return new MonitoringModuleGenerator(
        getFiler(),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_SourceVersionFactory.proxySourceVersion(
            processingEnvironmentModule));
  }

  private MonitoringModuleProcessingStep getMonitoringModuleProcessingStep() {
    return new MonitoringModuleProcessingStep(
        ProcessingEnvironmentModule_MessagerFactory.proxyMessager(processingEnvironmentModule),
        getMonitoringModuleGenerator());
  }

  private DependencyRequestValidator getDependencyRequestValidator() {
    return new DependencyRequestValidator(new MembersInjectionValidator());
  }

  private ProvidesMethodValidator getProvidesMethodValidator() {
    return new ProvidesMethodValidator(
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        getDaggerTypes(),
        getDependencyRequestValidator());
  }

  private ProducesMethodValidator getProducesMethodValidator() {
    return new ProducesMethodValidator(
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        getDaggerTypes(),
        getDependencyRequestValidator());
  }

  private BindsMethodValidator getBindsMethodValidator() {
    return new BindsMethodValidator(
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        getDaggerTypes(),
        getDependencyRequestValidator());
  }

  private MultibindsMethodValidator getMultibindsMethodValidator() {
    return new MultibindsMethodValidator(
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        getDaggerTypes(),
        getDependencyRequestValidator());
  }

  private BindsOptionalOfMethodValidator getBindsOptionalOfMethodValidator() {
    return new BindsOptionalOfMethodValidator(
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        getDaggerTypes(),
        getDependencyRequestValidator());
  }

  private Set<BindingMethodValidator> getSetOfBindingMethodValidator() {
    return ImmutableSet.<BindingMethodValidator>of(
        getProvidesMethodValidator(),
        getProducesMethodValidator(),
        getBindsMethodValidator(),
        getMultibindsMethodValidator(),
        getBindsOptionalOfMethodValidator());
  }

  private ImmutableMap<Class<? extends Annotation>, BindingMethodValidator>
      getImmutableMapOfClassOfAndBindingMethodValidator() {
    return BindingMethodValidatorsModule_IndexValidatorsFactory.proxyIndexValidators(
        getSetOfBindingMethodValidator());
  }

  private AnyBindingMethodValidator getAnyBindingMethodValidator() {
    return new AnyBindingMethodValidator(getImmutableMapOfClassOfAndBindingMethodValidator());
  }

  private MultibindingAnnotationsProcessingStep getMultibindingAnnotationsProcessingStep() {
    return new MultibindingAnnotationsProcessingStep(
        getAnyBindingMethodValidator(),
        ProcessingEnvironmentModule_MessagerFactory.proxyMessager(processingEnvironmentModule));
  }

  private BindsInstanceProcessingStep getBindsInstanceProcessingStep() {
    return new BindsInstanceProcessingStep(
        new BindsInstanceMethodValidator(),
        new BindsInstanceParameterValidator(),
        ProcessingEnvironmentModule_MessagerFactory.proxyMessager(processingEnvironmentModule));
  }

  private TypeProtoConverter getTypeProtoConverter() {
    return new TypeProtoConverter(
        getDaggerTypes(),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule));
  }

  private AnnotationProtoConverter getAnnotationProtoConverter() {
    return new AnnotationProtoConverter(getTypeProtoConverter());
  }

  private KeyFactory getKeyFactory() {
    return new KeyFactory(
        getDaggerTypes(),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        getTypeProtoConverter(),
        getAnnotationProtoConverter());
  }

  private DependencyRequestFactory getDependencyRequestFactory() {
    return new DependencyRequestFactory(getKeyFactory(), getDaggerTypes());
  }

  private InjectionSiteFactory getInjectionSiteFactory() {
    return new InjectionSiteFactory(
        getDaggerTypes(),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        getDependencyRequestFactory());
  }

  private BindingFactory getBindingFactory() {
    return new BindingFactory(
        getDaggerTypes(),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        getKeyFactory(),
        getDependencyRequestFactory(),
        getInjectionSiteFactory());
  }

  private ProducerFactoryGenerator getProducerFactoryGenerator() {
    return new ProducerFactoryGenerator(
        getFiler(),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_SourceVersionFactory.proxySourceVersion(
            processingEnvironmentModule),
        compilerOptionsProvider.get(),
        getKeyFactory());
  }

  private SourceFileGenerator<ProductionBinding> getSourceFileGeneratorOfProductionBinding() {
    return SourceFileGeneratorsModule_GeneratorModule_GeneratorFactory.proxyGenerator(
        productionModule, getProducerFactoryGenerator(), compilerOptionsProvider.get());
  }

  private ModuleConstructorProxyGenerator getModuleConstructorProxyGenerator() {
    return new ModuleConstructorProxyGenerator(
        getFiler(),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_SourceVersionFactory.proxySourceVersion(
            processingEnvironmentModule));
  }

  private SourceFileGenerator<TypeElement> getModuleGeneratorSourceFileGeneratorOfTypeElement() {
    return SourceFileGeneratorsModule_GeneratorFactory.proxyGenerator(
        getModuleConstructorProxyGenerator(), compilerOptionsProvider.get());
  }

  private InaccessibleMapKeyProxyGenerator getInaccessibleMapKeyProxyGenerator() {
    return new InaccessibleMapKeyProxyGenerator(
        getFiler(),
        getDaggerTypes(),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_SourceVersionFactory.proxySourceVersion(
            processingEnvironmentModule));
  }

  private DelegateDeclaration.Factory getFactory() {
    return new DelegateDeclaration.Factory(
        getDaggerTypes(), getKeyFactory(), getDependencyRequestFactory());
  }

  private ModuleProcessingStep getModuleProcessingStep() {
    return new ModuleProcessingStep(
        ProcessingEnvironmentModule_MessagerFactory.proxyMessager(processingEnvironmentModule),
        moduleValidatorProvider.get(),
        getBindingFactory(),
        getSourceFileGeneratorOfProvisionBinding(),
        getSourceFileGeneratorOfProductionBinding(),
        getModuleGeneratorSourceFileGeneratorOfTypeElement(),
        getInaccessibleMapKeyProxyGenerator(),
        getFactory());
  }

  private ComponentCreatorValidator getComponentCreatorValidator() {
    return new ComponentCreatorValidator(
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        getDaggerTypes());
  }

  private MethodSignatureFormatter getMethodSignatureFormatter() {
    return new MethodSignatureFormatter(getDaggerTypes());
  }

  private ComponentValidator getComponentValidator() {
    return new ComponentValidator(
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        getDaggerTypes(),
        moduleValidatorProvider.get(),
        getComponentCreatorValidator(),
        getDependencyRequestValidator(),
        new MembersInjectionValidator(),
        getMethodSignatureFormatter(),
        getDependencyRequestFactory());
  }

  private ComponentHierarchyValidator getComponentHierarchyValidator() {
    return new ComponentHierarchyValidator(compilerOptionsProvider.get());
  }

  private ComponentDescriptorValidator getComponentDescriptorValidator() {
    return new ComponentDescriptorValidator(
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        getDaggerTypes(),
        compilerOptionsProvider.get(),
        getMethodSignatureFormatter(),
        getComponentHierarchyValidator());
  }

  private ComponentDescriptorFactory getComponentDescriptorFactory() {
    return new ComponentDescriptorFactory(
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        getDaggerTypes(),
        getDependencyRequestFactory(),
        factoryProvider5.get());
  }

  private ComponentGenerator getComponentGenerator() {
    return new ComponentGenerator(
        getFiler(),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_SourceVersionFactory.proxySourceVersion(
            processingEnvironmentModule),
        componentImplementationFactoryProvider.get());
  }

  private SourceFileGenerator<BindingGraph> getSourceFileGeneratorOfBindingGraph() {
    return SourceFileGeneratorsModule_GeneratorModule_GeneratorFactory.proxyGenerator(
        componentModule, getComponentGenerator(), compilerOptionsProvider.get());
  }

  private BindingDeclarationFormatter getBindingDeclarationFormatter() {
    return new BindingDeclarationFormatter(getMethodSignatureFormatter());
  }

  private BindingGraphConverter getBindingGraphConverter() {
    return new BindingGraphConverter(getBindingDeclarationFormatter());
  }

  private ComponentProcessingStep getComponentProcessingStep() {
    return new ComponentProcessingStep(
        ProcessingEnvironmentModule_MessagerFactory.proxyMessager(processingEnvironmentModule),
        getComponentValidator(),
        getComponentCreatorValidator(),
        getComponentDescriptorValidator(),
        getComponentDescriptorFactory(),
        bindingGraphFactoryProvider.get(),
        getSourceFileGeneratorOfBindingGraph(),
        getBindingGraphConverter(),
        bindingGraphValidatorProvider.get(),
        compilerOptionsProvider.get());
  }

  private ComponentHjarProcessingStep getComponentHjarProcessingStep() {
    return new ComponentHjarProcessingStep(
        ProcessingEnvironmentModule_SourceVersionFactory.proxySourceVersion(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        getDaggerTypes(),
        getFiler(),
        ProcessingEnvironmentModule_MessagerFactory.proxyMessager(processingEnvironmentModule),
        getComponentValidator(),
        getComponentDescriptorFactory());
  }

  private BindingMethodProcessingStep getBindingMethodProcessingStep() {
    return new BindingMethodProcessingStep(
        ProcessingEnvironmentModule_MessagerFactory.proxyMessager(processingEnvironmentModule),
        getAnyBindingMethodValidator());
  }

  private ImmutableList<BasicAnnotationProcessor.ProcessingStep>
      getImmutableListOfProcessingStep() {
    return ComponentProcessor_ProcessingStepsModule_ProcessingStepsFactory.proxyProcessingSteps(
        getMapKeyProcessingStep(),
        getInjectProcessingStep(),
        getMonitoringModuleProcessingStep(),
        getMultibindingAnnotationsProcessingStep(),
        getBindsInstanceProcessingStep(),
        getModuleProcessingStep(),
        getComponentProcessingStep(),
        getComponentHjarProcessingStep(),
        getBindingMethodProcessingStep(),
        compilerOptionsProvider.get());
  }

  private DependencyRequestFormatter getDependencyRequestFormatter() {
    return new DependencyRequestFormatter(getDaggerTypes());
  }

  private DependencyCycleValidator getDependencyCycleValidator() {
    return new DependencyCycleValidator(getDependencyRequestFormatter());
  }

  private DependsOnProductionExecutorValidator getDependsOnProductionExecutorValidator() {
    return new DependsOnProductionExecutorValidator(compilerOptionsProvider.get(), getKeyFactory());
  }

  private DuplicateBindingsValidator getDuplicateBindingsValidator() {
    return new DuplicateBindingsValidator(
        getBindingDeclarationFormatter(), compilerOptionsProvider.get());
  }

  private IncompatiblyScopedBindingsValidator getIncompatiblyScopedBindingsValidator() {
    return new IncompatiblyScopedBindingsValidator(
        getMethodSignatureFormatter(), compilerOptionsProvider.get());
  }

  private InjectValidator getInjectValidator() {
    return new InjectValidator(
        getDaggerTypes(),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        getDependencyRequestValidator(),
        compilerOptionsProvider.get());
  }

  private InjectBindingValidator getInjectBindingValidator() {
    return new InjectBindingValidator(getInjectValidator());
  }

  private MapMultibindingValidator getMapMultibindingValidator() {
    return new MapMultibindingValidator(getBindingDeclarationFormatter(), getKeyFactory());
  }

  private MissingBindingValidator getMissingBindingValidator() {
    return new MissingBindingValidator(getDaggerTypes(), injectBindingRegistryImplProvider.get());
  }

  private NullableBindingValidator getNullableBindingValidator() {
    return new NullableBindingValidator(compilerOptionsProvider.get());
  }

  private SubcomponentFactoryMethodValidator getSubcomponentFactoryMethodValidator() {
    return new SubcomponentFactoryMethodValidator(getDaggerTypes());
  }

  private Set<BindingGraphPlugin> getValidationSetOfBindingGraphPlugin() {
    return ImmutableSet.<BindingGraphPlugin>of(
        getDependencyCycleValidator(),
        getDependsOnProductionExecutorValidator(),
        getDuplicateBindingsValidator(),
        getIncompatiblyScopedBindingsValidator(),
        getInjectBindingValidator(),
        getMapMultibindingValidator(),
        getMissingBindingValidator(),
        getNullableBindingValidator(),
        new ProvisionDependencyOnProducerBindingValidator(),
        getSubcomponentFactoryMethodValidator());
  }

  private BindingGraphPlugins getBindingGraphPlugins() {
    return new BindingGraphPlugins(
        getValidationSetOfBindingGraphPlugin(),
        externalPluginsProvider.get(),
        getFiler(),
        getDaggerTypes(),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_ProcessingOptionsFactory.proxyProcessingOptions(
            processingEnvironmentModule));
  }

  private Set<ClearableCache> getSetOfClearableCache() {
    return ImmutableSet.<ClearableCache>of(
        factoryProvider5.get(),
        bindingGraphFactoryProvider.get(),
        componentImplementationFactoryProvider.get());
  }

  private ComponentCreatorImplementationFactory getComponentCreatorImplementationFactory() {
    return new ComponentCreatorImplementationFactory(
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        getDaggerTypes());
  }

  @SuppressWarnings("unchecked")
  private void initialize(final Builder builder) {
    this.daggerElementsProvider =
        ProcessingEnvironmentModule_DaggerElementsFactory.create(
            builder.processingEnvironmentModule);
    this.typesProvider =
        ProcessingEnvironmentModule_TypesFactory.create(builder.processingEnvironmentModule);
    this.daggerTypesProvider = DaggerTypes_Factory.create(typesProvider, daggerElementsProvider);
    this.messagerProvider =
        ProcessingEnvironmentModule_MessagerFactory.create(builder.processingEnvironmentModule);
    this.dependencyRequestValidatorProvider =
        DependencyRequestValidator_Factory.create(MembersInjectionValidator_Factory.create());
    this.compilerOptionsProvider =
        SingleCheck.provider(
            ProcessingEnvironmentModule_CompilerOptionsFactory.create(
                builder.processingEnvironmentModule));
    this.injectValidatorProvider =
        InjectValidator_Factory.create(
            daggerTypesProvider,
            daggerElementsProvider,
            dependencyRequestValidatorProvider,
            compilerOptionsProvider);
    this.typeProtoConverterProvider =
        TypeProtoConverter_Factory.create(daggerTypesProvider, daggerElementsProvider);
    this.annotationProtoConverterProvider =
        AnnotationProtoConverter_Factory.create(typeProtoConverterProvider);
    this.keyFactoryProvider =
        KeyFactory_Factory.create(
            daggerTypesProvider,
            daggerElementsProvider,
            typeProtoConverterProvider,
            annotationProtoConverterProvider);
    this.dependencyRequestFactoryProvider =
        DependencyRequestFactory_Factory.create(keyFactoryProvider, daggerTypesProvider);
    this.injectionSiteFactoryProvider =
        InjectionSiteFactory_Factory.create(
            daggerTypesProvider, daggerElementsProvider, dependencyRequestFactoryProvider);
    this.bindingFactoryProvider =
        BindingFactory_Factory.create(
            daggerTypesProvider,
            daggerElementsProvider,
            keyFactoryProvider,
            dependencyRequestFactoryProvider,
            injectionSiteFactoryProvider);
    this.injectBindingRegistryImplProvider =
        DoubleCheck.provider(
            InjectBindingRegistryImpl_Factory.create(
                daggerElementsProvider,
                daggerTypesProvider,
                messagerProvider,
                injectValidatorProvider,
                keyFactoryProvider,
                bindingFactoryProvider,
                compilerOptionsProvider));
    this.provisionModule = builder.provisionModule;
    this.processingEnvironmentModule = builder.processingEnvironmentModule;
    this.membersInjectionModule = builder.membersInjectionModule;
    this.providesMethodValidatorProvider =
        ProvidesMethodValidator_Factory.create(
            daggerElementsProvider, daggerTypesProvider, dependencyRequestValidatorProvider);
    this.producesMethodValidatorProvider =
        ProducesMethodValidator_Factory.create(
            daggerElementsProvider, daggerTypesProvider, dependencyRequestValidatorProvider);
    this.bindsMethodValidatorProvider =
        BindsMethodValidator_Factory.create(
            daggerElementsProvider, daggerTypesProvider, dependencyRequestValidatorProvider);
    this.multibindsMethodValidatorProvider =
        MultibindsMethodValidator_Factory.create(
            daggerElementsProvider, daggerTypesProvider, dependencyRequestValidatorProvider);
    this.bindsOptionalOfMethodValidatorProvider =
        BindsOptionalOfMethodValidator_Factory.create(
            daggerElementsProvider, daggerTypesProvider, dependencyRequestValidatorProvider);
    this.setOfBindingMethodValidatorProvider =
        SetFactory.<BindingMethodValidator>builder(5, 0)
            .addProvider((Provider) providesMethodValidatorProvider)
            .addProvider((Provider) producesMethodValidatorProvider)
            .addProvider((Provider) bindsMethodValidatorProvider)
            .addProvider((Provider) multibindsMethodValidatorProvider)
            .addProvider((Provider) bindsOptionalOfMethodValidatorProvider)
            .build();
    this.indexValidatorsProvider =
        BindingMethodValidatorsModule_IndexValidatorsFactory.create(
            setOfBindingMethodValidatorProvider);
    this.anyBindingMethodValidatorProvider =
        AnyBindingMethodValidator_Factory.create(indexValidatorsProvider);
    this.methodSignatureFormatterProvider =
        MethodSignatureFormatter_Factory.create(daggerTypesProvider);
    this.factoryProvider =
        MultibindingDeclaration_Factory_Factory.create(daggerTypesProvider, keyFactoryProvider);
    this.factoryProvider2 =
        DelegateDeclaration_Factory_Factory.create(
            daggerTypesProvider, keyFactoryProvider, dependencyRequestFactoryProvider);
    this.factoryProvider3 = SubcomponentDeclaration_Factory_Factory.create(keyFactoryProvider);
    this.factoryProvider4 = OptionalBindingDeclaration_Factory_Factory.create(keyFactoryProvider);
    this.factoryProvider5 =
        DoubleCheck.provider(
            ModuleDescriptor_Factory_Factory.create(
                daggerElementsProvider,
                bindingFactoryProvider,
                factoryProvider,
                factoryProvider2,
                factoryProvider3,
                factoryProvider4));
    this.componentDescriptorFactoryProvider =
        ComponentDescriptorFactory_Factory.create(
            daggerElementsProvider,
            daggerTypesProvider,
            dependencyRequestFactoryProvider,
            factoryProvider5);
    this.bindingGraphFactoryProvider =
        DoubleCheck.provider(
            BindingGraphFactory_Factory.create(
                daggerElementsProvider,
                (Provider) injectBindingRegistryImplProvider,
                keyFactoryProvider,
                bindingFactoryProvider,
                factoryProvider5));
    this.bindingDeclarationFormatterProvider =
        BindingDeclarationFormatter_Factory.create(methodSignatureFormatterProvider);
    this.bindingGraphConverterProvider =
        BindingGraphConverter_Factory.create(bindingDeclarationFormatterProvider);
    this.dependencyRequestFormatterProvider =
        DependencyRequestFormatter_Factory.create(daggerTypesProvider);
    this.dependencyCycleValidatorProvider =
        DependencyCycleValidator_Factory.create(dependencyRequestFormatterProvider);
    this.dependsOnProductionExecutorValidatorProvider =
        DependsOnProductionExecutorValidator_Factory.create(
            compilerOptionsProvider, keyFactoryProvider);
    this.duplicateBindingsValidatorProvider =
        DuplicateBindingsValidator_Factory.create(
            bindingDeclarationFormatterProvider, compilerOptionsProvider);
    this.incompatiblyScopedBindingsValidatorProvider =
        IncompatiblyScopedBindingsValidator_Factory.create(
            methodSignatureFormatterProvider, compilerOptionsProvider);
    this.injectBindingValidatorProvider =
        InjectBindingValidator_Factory.create(injectValidatorProvider);
    this.mapMultibindingValidatorProvider =
        MapMultibindingValidator_Factory.create(
            bindingDeclarationFormatterProvider, keyFactoryProvider);
    this.missingBindingValidatorProvider =
        MissingBindingValidator_Factory.create(
            daggerTypesProvider, (Provider) injectBindingRegistryImplProvider);
    this.nullableBindingValidatorProvider =
        NullableBindingValidator_Factory.create(compilerOptionsProvider);
    this.subcomponentFactoryMethodValidatorProvider =
        SubcomponentFactoryMethodValidator_Factory.create(daggerTypesProvider);
    this.validationSetOfBindingGraphPluginProvider =
        SetFactory.<BindingGraphPlugin>builder(10, 0)
            .addProvider((Provider) dependencyCycleValidatorProvider)
            .addProvider((Provider) dependsOnProductionExecutorValidatorProvider)
            .addProvider((Provider) duplicateBindingsValidatorProvider)
            .addProvider((Provider) incompatiblyScopedBindingsValidatorProvider)
            .addProvider((Provider) injectBindingValidatorProvider)
            .addProvider((Provider) mapMultibindingValidatorProvider)
            .addProvider((Provider) missingBindingValidatorProvider)
            .addProvider((Provider) nullableBindingValidatorProvider)
            .addProvider((Provider) ProvisionDependencyOnProducerBindingValidator_Factory.create())
            .addProvider((Provider) subcomponentFactoryMethodValidatorProvider)
            .build();
    this.testingPluginsProvider = InstanceFactory.create(builder.testingPlugins);
    this.externalPluginsProvider =
        DoubleCheck.provider(SpiModule_ExternalPluginsFactory.create(testingPluginsProvider));
    this.diagnosticReporterFactoryProvider =
        DiagnosticReporterFactory_Factory.create(
            daggerTypesProvider,
            messagerProvider,
            dependencyRequestFormatterProvider,
            ElementFormatter_Factory.create(),
            compilerOptionsProvider);
    this.bindingGraphValidatorProvider =
        DoubleCheck.provider(
            BindingGraphValidator_Factory.create(
                validationSetOfBindingGraphPluginProvider,
                externalPluginsProvider,
                diagnosticReporterFactoryProvider));
    this.moduleValidatorProvider =
        DoubleCheck.provider(
            ModuleValidator_Factory.create(
                daggerTypesProvider,
                daggerElementsProvider,
                anyBindingMethodValidatorProvider,
                methodSignatureFormatterProvider,
                componentDescriptorFactoryProvider,
                bindingGraphFactoryProvider,
                bindingGraphConverterProvider,
                bindingGraphValidatorProvider,
                compilerOptionsProvider));
    this.productionModule = builder.productionModule;
    this.componentModule = builder.componentModule;
    this.topLevelImplementationComponentBuilderProvider =
        new Provider<TopLevelImplementationComponent.Builder>() {
          @Override
          public TopLevelImplementationComponent.Builder get() {
            return new TopLevelImplementationComponentBuilder();
          }
        };
    this.componentCreatorImplementationFactoryProvider =
        ComponentCreatorImplementationFactory_Factory.create(
            daggerElementsProvider, daggerTypesProvider);
    this.deserializedComponentImplementationBuilderProvider =
        DeserializedComponentImplementationBuilder_Factory.create(
            compilerOptionsProvider,
            componentCreatorImplementationFactoryProvider,
            typeProtoConverterProvider,
            keyFactoryProvider);
    this.componentImplementationFactoryProvider =
        DoubleCheck.provider(
            ComponentImplementationFactory_Factory.create(
                keyFactoryProvider,
                compilerOptionsProvider,
                bindingGraphFactoryProvider,
                topLevelImplementationComponentBuilderProvider,
                deserializedComponentImplementationBuilderProvider,
                daggerElementsProvider,
                messagerProvider));
    this.daggerStatisticsRecorderProvider =
        ProcessingEnvironmentModule_DaggerStatisticsRecorderFactory.create(
            builder.processingEnvironmentModule);
    this.daggerStatisticsCollectorProvider =
        DoubleCheck.provider(
            DaggerStatisticsCollector_Factory.create(
                SystemComponentsModule_TickerFactory.create(), daggerStatisticsRecorderProvider));
    this.sourceVersionProvider =
        ProcessingEnvironmentModule_SourceVersionFactory.create(
            builder.processingEnvironmentModule);
  }

  @Override
  public void inject(ComponentProcessor processor) {
    injectComponentProcessor(processor);
  }

  @CanIgnoreReturnValue
  private ComponentProcessor injectComponentProcessor(ComponentProcessor instance) {
    ComponentProcessor_MembersInjector.injectInjectBindingRegistry(
        instance, injectBindingRegistryImplProvider.get());
    ComponentProcessor_MembersInjector.injectFactoryGenerator(
        instance, getSourceFileGeneratorOfProvisionBinding());
    ComponentProcessor_MembersInjector.injectMembersInjectorGenerator(
        instance, getSourceFileGeneratorOfMembersInjectionBinding());
    ComponentProcessor_MembersInjector.injectProcessingSteps(
        instance, getImmutableListOfProcessingStep());
    ComponentProcessor_MembersInjector.injectBindingGraphPlugins(
        instance, getBindingGraphPlugins());
    ComponentProcessor_MembersInjector.injectCompilerOptions(
        instance, compilerOptionsProvider.get());
    ComponentProcessor_MembersInjector.injectStatisticsCollector(
        instance, daggerStatisticsCollectorProvider.get());
    ComponentProcessor_MembersInjector.injectClearableCaches(instance, getSetOfClearableCache());
    return instance;
  }

  private static final class Builder implements ComponentProcessor.ProcessorComponent.Builder {
    private ProcessingEnvironmentModule processingEnvironmentModule;

    private SourceFileGeneratorsModule.ProvisionModule provisionModule;

    private SourceFileGeneratorsModule.MembersInjectionModule membersInjectionModule;

    private SourceFileGeneratorsModule.ProductionModule productionModule;

    private SourceFileGeneratorsModule.ComponentModule componentModule;

    private Optional<ImmutableSet<BindingGraphPlugin>> testingPlugins;

    @Override
    public ComponentProcessor.ProcessorComponent build() {
      if (processingEnvironmentModule == null) {
        throw new IllegalStateException(
            ProcessingEnvironmentModule.class.getCanonicalName() + " must be set");
      }
      if (provisionModule == null) {
        this.provisionModule = new SourceFileGeneratorsModule.ProvisionModule();
      }
      if (membersInjectionModule == null) {
        this.membersInjectionModule = new SourceFileGeneratorsModule.MembersInjectionModule();
      }
      if (productionModule == null) {
        this.productionModule = new SourceFileGeneratorsModule.ProductionModule();
      }
      if (componentModule == null) {
        this.componentModule = new SourceFileGeneratorsModule.ComponentModule();
      }
      if (testingPlugins == null) {
        throw new IllegalStateException(Optional.class.getCanonicalName() + " must be set");
      }
      return new DaggerComponentProcessor_ProcessorComponent(this);
    }

    @Override
    public Builder processingEnvironmentModule(ProcessingEnvironmentModule module) {
      this.processingEnvironmentModule = Preconditions.checkNotNull(module);
      return this;
    }

    @Override
    public Builder testingPlugins(Optional<ImmutableSet<BindingGraphPlugin>> testingPlugins) {
      this.testingPlugins = Preconditions.checkNotNull(testingPlugins);
      return this;
    }
  }

  private final class TopLevelImplementationComponentBuilder
      implements TopLevelImplementationComponent.Builder {
    private ComponentImplementation topLevelComponent;

    @Override
    public TopLevelImplementationComponent build() {
      if (topLevelComponent == null) {
        throw new IllegalStateException(
            ComponentImplementation.class.getCanonicalName() + " must be set");
      }
      return new TopLevelImplementationComponentImpl(this);
    }

    @Override
    public TopLevelImplementationComponentBuilder topLevelComponent(
        ComponentImplementation topLevelImplementation) {
      this.topLevelComponent = Preconditions.checkNotNull(topLevelImplementation);
      return this;
    }
  }

  private final class TopLevelImplementationComponentImpl
      implements TopLevelImplementationComponent {
    private Provider<ComponentImplementation> topLevelComponentProvider;

    private Provider<OptionalFactories> optionalFactoriesProvider;

    private TopLevelImplementationComponentImpl(TopLevelImplementationComponentBuilder builder) {
      initialize(builder);
    }

    @SuppressWarnings("unchecked")
    private void initialize(final TopLevelImplementationComponentBuilder builder) {
      this.topLevelComponentProvider = InstanceFactory.create(builder.topLevelComponent);
      this.optionalFactoriesProvider =
          DoubleCheck.provider(OptionalFactories_Factory.create(topLevelComponentProvider));
    }

    @Override
    public CurrentImplementationSubcomponent.Builder currentImplementationSubcomponentBuilder() {
      return new CurrentImplementationSubcomponentBuilder();
    }

    private final class CurrentImplementationSubcomponentBuilder
        implements CurrentImplementationSubcomponent.Builder {
      private ComponentImplementation componentImplementation;

      private BindingGraph bindingGraph;

      private Optional<ComponentImplementationBuilder> parentBuilder;

      private Optional<ComponentBindingExpressions> parentBindingExpressions;

      private Optional<ComponentRequirementExpressions> parentRequirementExpressions;

      @Override
      public CurrentImplementationSubcomponent build() {
        if (componentImplementation == null) {
          throw new IllegalStateException(
              ComponentImplementation.class.getCanonicalName() + " must be set");
        }
        if (bindingGraph == null) {
          throw new IllegalStateException(BindingGraph.class.getCanonicalName() + " must be set");
        }
        if (parentBuilder == null) {
          throw new IllegalStateException(Optional.class.getCanonicalName() + " must be set");
        }
        if (parentBindingExpressions == null) {
          throw new IllegalStateException(Optional.class.getCanonicalName() + " must be set");
        }
        if (parentRequirementExpressions == null) {
          throw new IllegalStateException(Optional.class.getCanonicalName() + " must be set");
        }
        return new CurrentImplementationSubcomponentImpl(this);
      }

      @Override
      public CurrentImplementationSubcomponentBuilder componentImplementation(
          ComponentImplementation componentImplementation) {
        this.componentImplementation = Preconditions.checkNotNull(componentImplementation);
        return this;
      }

      @Override
      public CurrentImplementationSubcomponentBuilder bindingGraph(BindingGraph bindingGraph) {
        this.bindingGraph = Preconditions.checkNotNull(bindingGraph);
        return this;
      }

      @Override
      public CurrentImplementationSubcomponentBuilder parentBuilder(
          Optional<ComponentImplementationBuilder> parentBuilder) {
        this.parentBuilder = Preconditions.checkNotNull(parentBuilder);
        return this;
      }

      @Override
      public CurrentImplementationSubcomponentBuilder parentBindingExpressions(
          Optional<ComponentBindingExpressions> parentBindingExpressions) {
        this.parentBindingExpressions = Preconditions.checkNotNull(parentBindingExpressions);
        return this;
      }

      @Override
      public CurrentImplementationSubcomponentBuilder parentRequirementExpressions(
          Optional<ComponentRequirementExpressions> parentRequirementExpressions) {
        this.parentRequirementExpressions =
            Preconditions.checkNotNull(parentRequirementExpressions);
        return this;
      }
    }

    private final class CurrentImplementationSubcomponentImpl
        implements CurrentImplementationSubcomponent {
      private ComponentImplementation componentImplementation;

      private BindingGraph bindingGraph;

      private Optional<ComponentImplementationBuilder> parentBuilder;

      private Provider<Optional<ComponentBindingExpressions>> parentBindingExpressionsProvider;

      private Provider<BindingGraph> bindingGraphProvider;

      private Provider<ComponentImplementation> componentImplementationProvider;

      private Provider<Optional<ComponentRequirementExpressions>>
          parentRequirementExpressionsProvider;

      private Provider<ComponentRequirementExpressions> componentRequirementExpressionsProvider;

      private Provider<CompilerOptions> generationOptionsProvider;

      private Provider<ComponentBindingExpressions> componentBindingExpressionsProvider;

      private CurrentImplementationSubcomponentImpl(
          CurrentImplementationSubcomponentBuilder builder) {
        initialize(builder);
      }

      @SuppressWarnings("unchecked")
      private void initialize(final CurrentImplementationSubcomponentBuilder builder) {
        this.componentImplementation = builder.componentImplementation;
        this.bindingGraph = builder.bindingGraph;
        this.parentBindingExpressionsProvider =
            InstanceFactory.create(builder.parentBindingExpressions);
        this.bindingGraphProvider = InstanceFactory.create(builder.bindingGraph);
        this.componentImplementationProvider =
            InstanceFactory.create(builder.componentImplementation);
        this.parentRequirementExpressionsProvider =
            InstanceFactory.create(builder.parentRequirementExpressions);
        this.componentRequirementExpressionsProvider =
            DoubleCheck.provider(
                ComponentRequirementExpressions_Factory.create(
                    parentRequirementExpressionsProvider,
                    bindingGraphProvider,
                    componentImplementationProvider,
                    DaggerComponentProcessor_ProcessorComponent.this.compilerOptionsProvider,
                    DaggerComponentProcessor_ProcessorComponent.this.daggerElementsProvider));
        this.generationOptionsProvider =
            DoubleCheck.provider(
                GenerationOptionsModule_GenerationOptionsFactory.create(
                    DaggerComponentProcessor_ProcessorComponent.this.compilerOptionsProvider,
                    componentImplementationProvider,
                    DaggerComponentProcessor_ProcessorComponent.this.daggerElementsProvider));
        this.componentBindingExpressionsProvider =
            DoubleCheck.provider(
                ComponentBindingExpressions_Factory.create(
                    parentBindingExpressionsProvider,
                    bindingGraphProvider,
                    componentImplementationProvider,
                    componentRequirementExpressionsProvider,
                    TopLevelImplementationComponentImpl.this.optionalFactoriesProvider,
                    DaggerComponentProcessor_ProcessorComponent.this.daggerTypesProvider,
                    DaggerComponentProcessor_ProcessorComponent.this.daggerElementsProvider,
                    DaggerComponentProcessor_ProcessorComponent.this.sourceVersionProvider,
                    generationOptionsProvider));
        this.parentBuilder = builder.parentBuilder;
      }

      @Override
      public ComponentImplementationBuilder.RootComponentImplementationBuilder
          rootComponentBuilder() {
        return injectRootComponentImplementationBuilder(
            ComponentImplementationBuilder_RootComponentImplementationBuilder_Factory
                .newRootComponentImplementationBuilder(componentImplementation));
      }

      @Override
      public ComponentImplementationBuilder.SubcomponentImplementationBuilder
          subcomponentBuilder() {
        return injectSubcomponentImplementationBuilder(
            ComponentImplementationBuilder_SubcomponentImplementationBuilder_Factory
                .newSubcomponentImplementationBuilder(parentBuilder));
      }

      @CanIgnoreReturnValue
      private ComponentImplementationBuilder.RootComponentImplementationBuilder
          injectRootComponentImplementationBuilder(
              ComponentImplementationBuilder.RootComponentImplementationBuilder instance) {
        ComponentImplementationBuilder_MembersInjector.injectGraph(instance, bindingGraph);
        ComponentImplementationBuilder_MembersInjector.injectBindingExpressions(
            instance, componentBindingExpressionsProvider.get());
        ComponentImplementationBuilder_MembersInjector.injectComponentRequirementExpressions(
            instance, componentRequirementExpressionsProvider.get());
        ComponentImplementationBuilder_MembersInjector.injectComponentImplementation(
            instance, componentImplementation);
        ComponentImplementationBuilder_MembersInjector.injectComponentCreatorImplementationFactory(
            instance,
            DaggerComponentProcessor_ProcessorComponent.this
                .getComponentCreatorImplementationFactory());
        ComponentImplementationBuilder_MembersInjector.injectTypes(
            instance, DaggerComponentProcessor_ProcessorComponent.this.getDaggerTypes());
        ComponentImplementationBuilder_MembersInjector.injectElements(
            instance,
            ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
                DaggerComponentProcessor_ProcessorComponent.this.processingEnvironmentModule));
        ComponentImplementationBuilder_MembersInjector.injectCompilerOptions(
            instance,
            DaggerComponentProcessor_ProcessorComponent.this.compilerOptionsProvider.get());
        ComponentImplementationBuilder_MembersInjector.injectComponentImplementationFactory(
            instance,
            DaggerComponentProcessor_ProcessorComponent.this.componentImplementationFactoryProvider
                .get());
        ComponentImplementationBuilder_MembersInjector.injectTopLevelImplementationComponent(
            instance, TopLevelImplementationComponentImpl.this);
        return instance;
      }

      @CanIgnoreReturnValue
      private ComponentImplementationBuilder.SubcomponentImplementationBuilder
          injectSubcomponentImplementationBuilder(
              ComponentImplementationBuilder.SubcomponentImplementationBuilder instance) {
        ComponentImplementationBuilder_MembersInjector.injectGraph(instance, bindingGraph);
        ComponentImplementationBuilder_MembersInjector.injectBindingExpressions(
            instance, componentBindingExpressionsProvider.get());
        ComponentImplementationBuilder_MembersInjector.injectComponentRequirementExpressions(
            instance, componentRequirementExpressionsProvider.get());
        ComponentImplementationBuilder_MembersInjector.injectComponentImplementation(
            instance, componentImplementation);
        ComponentImplementationBuilder_MembersInjector.injectComponentCreatorImplementationFactory(
            instance,
            DaggerComponentProcessor_ProcessorComponent.this
                .getComponentCreatorImplementationFactory());
        ComponentImplementationBuilder_MembersInjector.injectTypes(
            instance, DaggerComponentProcessor_ProcessorComponent.this.getDaggerTypes());
        ComponentImplementationBuilder_MembersInjector.injectElements(
            instance,
            ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
                DaggerComponentProcessor_ProcessorComponent.this.processingEnvironmentModule));
        ComponentImplementationBuilder_MembersInjector.injectCompilerOptions(
            instance,
            DaggerComponentProcessor_ProcessorComponent.this.compilerOptionsProvider.get());
        ComponentImplementationBuilder_MembersInjector.injectComponentImplementationFactory(
            instance,
            DaggerComponentProcessor_ProcessorComponent.this.componentImplementationFactoryProvider
                .get());
        ComponentImplementationBuilder_MembersInjector.injectTopLevelImplementationComponent(
            instance, TopLevelImplementationComponentImpl.this);
        return instance;
      }
    }
  }
}
