/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.SimpleAnnotationMirror;
import dagger.internal.codegen.TypeProtoConverter;
import dagger.internal.codegen.serialization.AnnotationProto;
import dagger.internal.codegen.serialization.AnnotationValueProto;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreTypes;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.AnnotationValueVisitor;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;

final class AnnotationProtoConverter {
    private final TypeProtoConverter typeProtoConverter;
    private static final AnnotationValueVisitor<AnnotationValueProto.Builder, AnnotationValueProto.Builder> ANNOTATION_VALUE_TO_PROTO = new SimpleAnnotationValueVisitor8<AnnotationValueProto.Builder, AnnotationValueProto.Builder>(){

        @Override
        public AnnotationValueProto.Builder visitAnnotation(AnnotationMirror nestedAnnotation, AnnotationValueProto.Builder builder) {
            return builder.setNestedAnnotation(AnnotationProtoConverter.toProto(nestedAnnotation)).setKind(AnnotationValueProto.Kind.ANNOTATION);
        }

        @Override
        public AnnotationValueProto.Builder visitBoolean(boolean b, AnnotationValueProto.Builder builder) {
            return builder.setBooleanValue(b).setKind(AnnotationValueProto.Kind.BOOLEAN);
        }

        @Override
        public AnnotationValueProto.Builder visitChar(char c, AnnotationValueProto.Builder builder) {
            return builder.setStringValue(String.valueOf(c)).setKind(AnnotationValueProto.Kind.CHAR);
        }

        @Override
        public AnnotationValueProto.Builder visitByte(byte b, AnnotationValueProto.Builder builder) {
            return builder.setIntValue((int)b).setKind(AnnotationValueProto.Kind.BYTE);
        }

        @Override
        public AnnotationValueProto.Builder visitShort(short s, AnnotationValueProto.Builder builder) {
            return builder.setIntValue((int)s).setKind(AnnotationValueProto.Kind.SHORT);
        }

        @Override
        public AnnotationValueProto.Builder visitInt(int i, AnnotationValueProto.Builder builder) {
            return builder.setIntValue(i).setKind(AnnotationValueProto.Kind.INT);
        }

        @Override
        public AnnotationValueProto.Builder visitFloat(float f, AnnotationValueProto.Builder builder) {
            return builder.setFloatValue(f).setKind(AnnotationValueProto.Kind.FLOAT);
        }

        @Override
        public AnnotationValueProto.Builder visitLong(long l, AnnotationValueProto.Builder builder) {
            return builder.setLongValue(l).setKind(AnnotationValueProto.Kind.LONG);
        }

        @Override
        public AnnotationValueProto.Builder visitDouble(double d, AnnotationValueProto.Builder builder) {
            return builder.setDoubleValue(d).setKind(AnnotationValueProto.Kind.DOUBLE);
        }

        @Override
        public AnnotationValueProto.Builder visitString(String s, AnnotationValueProto.Builder builder) {
            return builder.setStringValue(s).setKind(AnnotationValueProto.Kind.STRING);
        }

        @Override
        public AnnotationValueProto.Builder visitType(TypeMirror t, AnnotationValueProto.Builder builder) {
            return builder.setClassLiteral(TypeProtoConverter.toProto(t)).setKind(AnnotationValueProto.Kind.CLASS_LITERAL);
        }

        @Override
        public AnnotationValueProto.Builder visitEnumConstant(VariableElement c, AnnotationValueProto.Builder builder) {
            return builder.setEnumType(TypeProtoConverter.toProto(c.asType())).setEnumName(c.getSimpleName().toString()).setKind(AnnotationValueProto.Kind.ENUM);
        }

        @Override
        public AnnotationValueProto.Builder visitArray(List<? extends AnnotationValue> values, AnnotationValueProto.Builder builder) {
            values.forEach(value -> builder.addArrayValues(AnnotationProtoConverter.annotationValueProto(value)));
            return builder.setKind(AnnotationValueProto.Kind.ARRAY);
        }

        @Override
        public AnnotationValueProto.Builder visitUnknown(AnnotationValue av, AnnotationValueProto.Builder builder) {
            throw new UnsupportedOperationException(av.toString());
        }
    };

    @Inject
    AnnotationProtoConverter(TypeProtoConverter typeProtoConverter) {
        this.typeProtoConverter = typeProtoConverter;
    }

    static AnnotationProto toProto(AnnotationMirror annotationMirror) {
        AnnotationProto.Builder builder = AnnotationProto.newBuilder();
        builder.setAnnotationType(TypeProtoConverter.toProto(annotationMirror.getAnnotationType()));
        AnnotationMirrors.getAnnotationValuesWithDefaults(annotationMirror).forEach((attribute, value) -> builder.putValues(attribute.getSimpleName().toString(), AnnotationProtoConverter.annotationValueProto(value)));
        return builder.build();
    }

    AnnotationMirror fromProto(AnnotationProto annotation) {
        return SimpleAnnotationMirror.of(MoreTypes.asTypeElement(this.typeProtoConverter.fromProto(annotation.getAnnotationType())), Maps.transformValues((Map)annotation.getValuesMap(), x$0 -> new AnnotationValueFromProto((AnnotationValueProto)x$0)));
    }

    private static AnnotationValueProto annotationValueProto(AnnotationValue annotationValue) {
        return annotationValue.accept(ANNOTATION_VALUE_TO_PROTO, AnnotationValueProto.newBuilder()).build();
    }

    private class AnnotationValueFromProto
    implements AnnotationValue {
        private final AnnotationValueProto proto;

        AnnotationValueFromProto(AnnotationValueProto proto) {
            this.proto = proto;
        }

        @Override
        public Object getValue() {
            switch (this.proto.getKind()) {
                case BOOLEAN: {
                    return this.proto.getBooleanValue();
                }
                case BYTE: {
                    return (byte)this.proto.getIntValue();
                }
                case SHORT: {
                    return (short)this.proto.getIntValue();
                }
                case CHAR: {
                    return Character.valueOf(this.getCharValue());
                }
                case INT: {
                    return this.proto.getIntValue();
                }
                case FLOAT: {
                    return Float.valueOf(this.proto.getFloatValue());
                }
                case LONG: {
                    return this.proto.getLongValue();
                }
                case DOUBLE: {
                    return this.proto.getDoubleValue();
                }
                case STRING: {
                    return this.proto.getStringValue();
                }
                case CLASS_LITERAL: {
                    return AnnotationProtoConverter.this.typeProtoConverter.fromProto(this.proto.getClassLiteral());
                }
                case ENUM: {
                    return this.getEnumConstant();
                }
                case ANNOTATION: {
                    return AnnotationProtoConverter.this.fromProto(this.proto.getNestedAnnotation());
                }
                case ARRAY: {
                    return this.getArrayValues();
                }
            }
            throw new AssertionError(this.proto);
        }

        @Override
        public <R, P> R accept(AnnotationValueVisitor<R, P> visitor, P passedValue) {
            switch (this.proto.getKind()) {
                case BOOLEAN: {
                    return visitor.visitBoolean(this.proto.getBooleanValue(), passedValue);
                }
                case BYTE: {
                    return visitor.visitByte((byte)this.proto.getIntValue(), passedValue);
                }
                case SHORT: {
                    return visitor.visitShort((short)this.proto.getIntValue(), passedValue);
                }
                case CHAR: {
                    return visitor.visitChar(this.getCharValue(), passedValue);
                }
                case INT: {
                    return visitor.visitInt(this.proto.getIntValue(), passedValue);
                }
                case FLOAT: {
                    return visitor.visitFloat(this.proto.getFloatValue(), passedValue);
                }
                case LONG: {
                    return visitor.visitLong(this.proto.getLongValue(), passedValue);
                }
                case DOUBLE: {
                    return visitor.visitDouble(this.proto.getDoubleValue(), passedValue);
                }
                case STRING: {
                    return visitor.visitString((String)this.getValue(), passedValue);
                }
                case CLASS_LITERAL: {
                    return visitor.visitType((TypeMirror)this.getValue(), passedValue);
                }
                case ENUM: {
                    return visitor.visitEnumConstant((VariableElement)this.getValue(), passedValue);
                }
                case ANNOTATION: {
                    return visitor.visitAnnotation((AnnotationMirror)this.getValue(), passedValue);
                }
                case ARRAY: {
                    return visitor.visitArray((List<AnnotationValue>)this.getArrayValues(), passedValue);
                }
            }
            throw new AssertionError(this.proto);
        }

        private char getCharValue() {
            Preconditions.checkState((boolean)this.proto.getKind().equals((Object)AnnotationValueProto.Kind.CHAR));
            return this.proto.getStringValue().charAt(0);
        }

        private VariableElement getEnumConstant() {
            Preconditions.checkState((boolean)this.proto.getKind().equals((Object)AnnotationValueProto.Kind.ENUM));
            TypeMirror enumType = AnnotationProtoConverter.this.typeProtoConverter.fromProto(this.proto.getEnumType());
            return ElementFilter.fieldsIn(MoreTypes.asTypeElement(enumType).getEnclosedElements()).stream().filter(value -> value.getSimpleName().contentEquals(this.proto.getEnumName())).findFirst().get();
        }

        private ImmutableList<AnnotationValue> getArrayValues() {
            Preconditions.checkState((boolean)this.proto.getKind().equals((Object)AnnotationValueProto.Kind.ARRAY));
            return this.proto.getArrayValuesList().stream().map(x$0 -> new AnnotationValueFromProto((AnnotationValueProto)x$0)).collect(DaggerStreams.toImmutableList());
        }
    }
}

