/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import dagger.internal.codegen.AutoValue_MembersInjectionBinding;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentRequirement;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.ContributionType;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.DelegateDeclaration;
import dagger.internal.codegen.DependencyRequestFactory;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.internal.codegen.InjectionSiteFactory;
import dagger.internal.codegen.KeyFactory;
import dagger.internal.codegen.MapKeys;
import dagger.internal.codegen.MapType;
import dagger.internal.codegen.MembersInjectionBinding;
import dagger.internal.codegen.MoreAnnotationMirrors;
import dagger.internal.codegen.ProductionBinding;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.ResolvedBindings;
import dagger.internal.codegen.Scopes;
import dagger.internal.codegen.SetType;
import dagger.internal.codegen.SubcomponentDeclaration;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.model.BindingKind;
import dagger.model.DependencyRequest;
import dagger.model.Key;
import dagger.model.RequestKind;
import dagger.producers.Produced;
import dagger.producers.Producer;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;

final class BindingFactory {
    private final DaggerTypes types;
    private final KeyFactory keyFactory;
    private final DependencyRequestFactory dependencyRequestFactory;
    private final InjectionSiteFactory injectionSiteFactory;
    private final DaggerElements elements;

    @Inject
    BindingFactory(DaggerTypes types, DaggerElements elements, KeyFactory keyFactory, DependencyRequestFactory dependencyRequestFactory, InjectionSiteFactory injectionSiteFactory) {
        this.types = types;
        this.elements = elements;
        this.keyFactory = keyFactory;
        this.dependencyRequestFactory = dependencyRequestFactory;
        this.injectionSiteFactory = injectionSiteFactory;
    }

    ProvisionBinding injectionBinding(ExecutableElement constructorElement, Optional<TypeMirror> resolvedType) {
        Preconditions.checkArgument((boolean)constructorElement.getKind().equals((Object)ElementKind.CONSTRUCTOR));
        Preconditions.checkArgument((boolean)MoreElements.isAnnotationPresent(constructorElement, Inject.class));
        Preconditions.checkArgument((!InjectionAnnotations.getQualifier(constructorElement).isPresent() ? 1 : 0) != 0);
        ExecutableType constructorType = MoreTypes.asExecutable(constructorElement.asType());
        DeclaredType constructedType = MoreTypes.asDeclared(constructorElement.getEnclosingElement().asType());
        if (!constructedType.getTypeArguments().isEmpty() && resolvedType.isPresent()) {
            DeclaredType resolved = MoreTypes.asDeclared(resolvedType.get());
            Preconditions.checkState((boolean)this.types.isSameType(this.types.erasure(resolved), this.types.erasure(constructedType)), (String)"erased expected type: %s, erased actual type: %s", (Object)this.types.erasure(resolved), (Object)this.types.erasure(constructedType));
            constructorType = MoreTypes.asExecutable(this.types.asMemberOf(resolved, constructorElement));
            constructedType = resolved;
        }
        Key key = this.keyFactory.forInjectConstructorWithResolvedType(constructedType);
        ImmutableSet<DependencyRequest> provisionDependencies = this.dependencyRequestFactory.forRequiredResolvedVariables(constructorElement.getParameters(), constructorType.getParameterTypes());
        ProvisionBinding.Builder builder = ((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).bindingElement(constructorElement)).key(key)).provisionDependencies((Iterable<DependencyRequest>)provisionDependencies).injectionSites(this.injectionSiteFactory.getInjectionSites(constructedType)).kind(BindingKind.INJECTION)).scope(Scopes.uniqueScopeOf(constructorElement.getEnclosingElement()));
        TypeElement bindingTypeElement = MoreElements.asType(constructorElement.getEnclosingElement());
        if (Binding.hasNonDefaultTypeParameters(bindingTypeElement, key.type(), this.types)) {
            builder.unresolved(this.injectionBinding(constructorElement, Optional.empty()));
        }
        return (ProvisionBinding)builder.build();
    }

    ProvisionBinding providesMethodBinding(ExecutableElement providesMethod, TypeElement contributedBy) {
        return (ProvisionBinding)((ProvisionBinding.Builder)((ProvisionBinding.Builder)this.setMethodBindingProperties(ProvisionBinding.builder(), providesMethod, contributedBy, this.keyFactory.forProvidesMethod(providesMethod, contributedBy), this::providesMethodBinding).kind(BindingKind.PROVISION)).scope(Scopes.uniqueScopeOf(providesMethod)).nullableType(ConfigurationAnnotations.getNullableType(providesMethod))).build();
    }

    ProductionBinding producesMethodBinding(ExecutableElement producesMethod, TypeElement contributedBy) {
        ProductionBinding.Builder builder = ((ProductionBinding.Builder)this.setMethodBindingProperties(ProductionBinding.builder(), producesMethod, contributedBy, this.keyFactory.forProducesMethod(producesMethod, contributedBy), this::producesMethodBinding).kind(BindingKind.PRODUCTION)).productionKind(ProductionBinding.ProductionKind.fromProducesMethod(producesMethod)).thrownTypes(producesMethod.getThrownTypes()).executorRequest(this.dependencyRequestFactory.forProductionImplementationExecutor()).monitorRequest(this.dependencyRequestFactory.forProductionComponentMonitor());
        return (ProductionBinding)builder.build();
    }

    private <C extends ContributionBinding, B extends ContributionBinding.Builder<C, B>> B setMethodBindingProperties(B builder, ExecutableElement method, TypeElement contributedBy, Key key, BiFunction<ExecutableElement, TypeElement, C> create) {
        Preconditions.checkArgument((boolean)method.getKind().equals((Object)ElementKind.METHOD));
        ExecutableType methodType = MoreTypes.asExecutable(this.types.asMemberOf(MoreTypes.asDeclared(contributedBy.asType()), method));
        if (!this.types.isSameType(methodType, method.asType())) {
            builder.unresolved((ContributionBinding)((ContributionBinding)create.apply(method, MoreElements.asType(method.getEnclosingElement()))));
        }
        return ((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)builder.contributionType(ContributionType.fromBindingElement(method))).bindingElement(method)).contributingModule(contributedBy)).key(key)).dependencies((Iterable<DependencyRequest>)this.dependencyRequestFactory.forRequiredResolvedVariables(method.getParameters(), methodType.getParameterTypes()))).wrappedMapKeyAnnotation(MoreAnnotationMirrors.wrapOptionalInEquivalence(MapKeys.getMapKey(method)));
    }

    ContributionBinding syntheticMultibinding(Key key, Iterable<ContributionBinding> multibindingContributions) {
        ContributionBinding.Builder builder = this.multibindingRequiresProduction(key, multibindingContributions) ? ProductionBinding.builder() : ProvisionBinding.builder();
        return ((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)builder.contributionType(ContributionType.UNIQUE)).key(key)).dependencies((Iterable<DependencyRequest>)this.dependencyRequestFactory.forMultibindingContributions(key, multibindingContributions))).kind(ContributionBinding.bindingKindForMultibindingKey(key))).build();
    }

    private boolean multibindingRequiresProduction(Key key, Iterable<ContributionBinding> multibindingContributions) {
        MapType mapType;
        if (MapType.isMap(key) ? (mapType = MapType.from(key)).valuesAreTypeOf(Producer.class) || mapType.valuesAreTypeOf(Produced.class) : SetType.isSet(key) && SetType.from(key).elementsAreTypeOf(Produced.class)) {
            return true;
        }
        return Iterables.any(multibindingContributions, binding -> binding.bindingType().equals((Object)BindingType.PRODUCTION));
    }

    ProvisionBinding componentBinding(TypeElement componentDefinitionType) {
        Preconditions.checkNotNull((Object)componentDefinitionType);
        return (ProvisionBinding)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).bindingElement(componentDefinitionType)).key(this.keyFactory.forType(componentDefinitionType.asType()))).kind(BindingKind.COMPONENT)).build();
    }

    ProvisionBinding componentDependencyBinding(ComponentRequirement dependency) {
        Preconditions.checkNotNull((Object)dependency);
        return (ProvisionBinding)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).bindingElement(dependency.typeElement())).key(this.keyFactory.forType(dependency.type()))).kind(BindingKind.COMPONENT_DEPENDENCY)).build();
    }

    ContributionBinding componentDependencyMethodBinding(ComponentDescriptor componentDescriptor, ExecutableElement dependencyMethod) {
        Preconditions.checkArgument((boolean)dependencyMethod.getKind().equals((Object)ElementKind.METHOD));
        Preconditions.checkArgument((boolean)dependencyMethod.getParameters().isEmpty());
        ContributionBinding.Builder builder = componentDescriptor.isProduction() && ComponentDescriptor.isComponentProductionMethod(this.elements, dependencyMethod) ? ((ProductionBinding.Builder)((ProductionBinding.Builder)ProductionBinding.builder().key(this.keyFactory.forProductionComponentMethod(dependencyMethod))).kind(BindingKind.COMPONENT_PRODUCTION)).thrownTypes(dependencyMethod.getThrownTypes()) : ((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)ProvisionBinding.builder().key(this.keyFactory.forComponentMethod(dependencyMethod))).nullableType(ConfigurationAnnotations.getNullableType(dependencyMethod))).kind(BindingKind.COMPONENT_PROVISION)).scope(Scopes.uniqueScopeOf(dependencyMethod));
        return ((ContributionBinding.Builder)((ContributionBinding.Builder)builder.contributionType(ContributionType.UNIQUE)).bindingElement(dependencyMethod)).build();
    }

    ProvisionBinding boundInstanceBinding(ComponentRequirement requirement, Element element) {
        Preconditions.checkArgument((element instanceof VariableElement || element instanceof ExecutableElement ? 1 : 0) != 0);
        VariableElement parameterElement = element instanceof VariableElement ? MoreElements.asVariable(element) : (VariableElement)Iterables.getOnlyElement(MoreElements.asExecutable(element).getParameters());
        return (ProvisionBinding)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).bindingElement(element)).key(requirement.key().get())).nullableType(ConfigurationAnnotations.getNullableType(parameterElement))).kind(BindingKind.BOUND_INSTANCE)).build();
    }

    ProvisionBinding subcomponentCreatorBinding(ExecutableElement subcomponentCreatorMethod, TypeElement component) {
        Preconditions.checkArgument((boolean)subcomponentCreatorMethod.getKind().equals((Object)ElementKind.METHOD));
        Preconditions.checkArgument((boolean)subcomponentCreatorMethod.getParameters().isEmpty());
        Key key = this.keyFactory.forSubcomponentCreatorMethod(subcomponentCreatorMethod, MoreTypes.asDeclared(component.asType()));
        return (ProvisionBinding)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).bindingElement(subcomponentCreatorMethod)).key(key)).kind(BindingKind.SUBCOMPONENT_CREATOR)).build();
    }

    ProvisionBinding subcomponentCreatorBinding(ImmutableSet<SubcomponentDeclaration> subcomponentDeclarations) {
        SubcomponentDeclaration subcomponentDeclaration = (SubcomponentDeclaration)subcomponentDeclarations.iterator().next();
        return (ProvisionBinding)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).key(subcomponentDeclaration.key())).kind(BindingKind.SUBCOMPONENT_CREATOR)).build();
    }

    ContributionBinding delegateBinding(DelegateDeclaration delegateDeclaration, ContributionBinding actualBinding) {
        switch (actualBinding.bindingType()) {
            case PRODUCTION: {
                return this.buildDelegateBinding((ContributionBinding.Builder<?, ?>)ProductionBinding.builder().nullableType(actualBinding.nullableType()), delegateDeclaration, Producer.class);
            }
            case PROVISION: {
                return this.buildDelegateBinding((ContributionBinding.Builder<?, ?>)ProvisionBinding.builder().scope(Scopes.uniqueScopeOf(delegateDeclaration.bindingElement().get())).nullableType(actualBinding.nullableType()), delegateDeclaration, Provider.class);
            }
        }
        throw new AssertionError((Object)("bindingType: " + actualBinding));
    }

    ContributionBinding unresolvedDelegateBinding(DelegateDeclaration delegateDeclaration) {
        return this.buildDelegateBinding(ProvisionBinding.builder().scope(Scopes.uniqueScopeOf(delegateDeclaration.bindingElement().get())), delegateDeclaration, Provider.class);
    }

    private ContributionBinding buildDelegateBinding(ContributionBinding.Builder<?, ?> builder, DelegateDeclaration delegateDeclaration, Class<?> frameworkType) {
        return ((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)builder.contributionType(delegateDeclaration.contributionType())).bindingElement(delegateDeclaration.bindingElement().get())).contributingModule(delegateDeclaration.contributingModule().get())).key(this.keyFactory.forDelegateBinding(delegateDeclaration, frameworkType))).dependencies(delegateDeclaration.delegateRequest())).wrappedMapKeyAnnotation(delegateDeclaration.wrappedMapKey())).kind(BindingKind.DELEGATE)).build();
    }

    ContributionBinding syntheticOptionalBinding(Key key, RequestKind requestKind, ResolvedBindings underlyingKeyBindings) {
        Object builder = ((ContributionBinding.Builder)((ContributionBinding.Builder)this.syntheticOptionalBindingBuilder(requestKind, underlyingKeyBindings).contributionType(ContributionType.UNIQUE)).key(key)).kind(BindingKind.OPTIONAL);
        if (!underlyingKeyBindings.isEmpty()) {
            ((ContributionBinding.Builder)builder).dependencies(this.dependencyRequestFactory.forSyntheticPresentOptionalBinding(key, requestKind));
        }
        return ((ContributionBinding.Builder)builder).build();
    }

    private ContributionBinding.Builder<?, ?> syntheticOptionalBindingBuilder(RequestKind requestKind, ResolvedBindings underlyingKeyBindings) {
        return !underlyingKeyBindings.isEmpty() && (underlyingKeyBindings.bindingTypes().contains((Object)BindingType.PRODUCTION) || requestKind.equals((Object)RequestKind.PRODUCER) || requestKind.equals((Object)RequestKind.PRODUCED)) ? ProductionBinding.builder() : ProvisionBinding.builder();
    }

    ProvisionBinding membersInjectorBinding(Key key, MembersInjectionBinding membersInjectionBinding) {
        return (ProvisionBinding)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)ProvisionBinding.builder().key(key)).contributionType(ContributionType.UNIQUE)).kind(BindingKind.MEMBERS_INJECTOR)).bindingElement(MoreTypes.asTypeElement(membersInjectionBinding.key().type()))).provisionDependencies((Iterable<DependencyRequest>)membersInjectionBinding.dependencies()).injectionSites(membersInjectionBinding.injectionSites()).build();
    }

    MembersInjectionBinding membersInjectionBinding(DeclaredType declaredType, Optional<TypeMirror> resolvedType) {
        TypeElement typeElement;
        if (!declaredType.getTypeArguments().isEmpty() && resolvedType.isPresent()) {
            DeclaredType resolved = MoreTypes.asDeclared(resolvedType.get());
            Preconditions.checkState((boolean)this.types.isSameType(this.types.erasure(resolved), this.types.erasure(declaredType)), (String)"erased expected type: %s, erased actual type: %s", (Object)this.types.erasure(resolved), (Object)this.types.erasure(declaredType));
            declaredType = resolved;
        }
        ImmutableSortedSet<MembersInjectionBinding.InjectionSite> injectionSites = this.injectionSiteFactory.getInjectionSites(declaredType);
        ImmutableSet dependencies = injectionSites.stream().flatMap(injectionSite -> injectionSite.dependencies().stream()).collect(DaggerStreams.toImmutableSet());
        Key key = this.keyFactory.forMembersInjectedType(declaredType);
        return new AutoValue_MembersInjectionBinding(key, dependencies, typeElement, Binding.hasNonDefaultTypeParameters(typeElement = MoreElements.asType(declaredType.asElement()), key.type(), this.types) ? Optional.of(this.membersInjectionBinding(MoreTypes.asDeclared(typeElement.asType()), Optional.empty())) : Optional.empty(), injectionSites);
    }
}

