/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.auto.value.AutoValue;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import dagger.BindsInstance;
import dagger.internal.codegen.AutoValue_ComponentCreatorDescriptor;
import dagger.internal.codegen.ComponentCreatorAnnotation;
import dagger.internal.codegen.ComponentCreatorKind;
import dagger.internal.codegen.ComponentRequirement;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.DependencyRequestFactory;
import dagger.internal.codegen.ModuleAnnotation;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.model.DependencyRequest;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;

@AutoValue
abstract class ComponentCreatorDescriptor {
    ComponentCreatorDescriptor() {
    }

    abstract ComponentCreatorAnnotation annotation();

    final ComponentCreatorKind kind() {
        return this.annotation().creatorKind();
    }

    abstract TypeElement typeElement();

    abstract ExecutableElement factoryMethod();

    abstract ImmutableSetMultimap<ComponentRequirement, ExecutableElement> unvalidatedSetterMethods();

    abstract ImmutableSetMultimap<ComponentRequirement, VariableElement> unvalidatedFactoryParameters();

    final ImmutableSetMultimap<ComponentRequirement, Element> unvalidatedRequirementElements() {
        return ImmutableSetMultimap.copyOf(this.unvalidatedSetterMethods().isEmpty() ? this.unvalidatedFactoryParameters() : this.unvalidatedSetterMethods());
    }

    ImmutableMap<ComponentRequirement, Element> requirementElements() {
        return ComponentCreatorDescriptor.flatten(this.unvalidatedRequirementElements());
    }

    ImmutableMap<ComponentRequirement, ExecutableElement> setterMethods() {
        return ComponentCreatorDescriptor.flatten(this.unvalidatedSetterMethods());
    }

    ImmutableMap<ComponentRequirement, VariableElement> factoryParameters() {
        return ComponentCreatorDescriptor.flatten(this.unvalidatedFactoryParameters());
    }

    private static <K, V> ImmutableMap<K, V> flatten(Multimap<K, V> multimap) {
        return ImmutableMap.copyOf((Map)Maps.transformValues((Map)multimap.asMap(), values -> Iterables.getOnlyElement((Iterable)values)));
    }

    final ImmutableSet<ComponentRequirement> userSettableRequirements() {
        return this.unvalidatedRequirementElements().keySet();
    }

    final ImmutableSet<ComponentRequirement> moduleAndDependencyRequirements() {
        return this.userSettableRequirements().stream().filter(requirement -> !requirement.isBoundInstance()).collect(DaggerStreams.toImmutableSet());
    }

    final ImmutableSet<ComponentRequirement> boundInstanceRequirements() {
        return this.userSettableRequirements().stream().filter(ComponentRequirement::isBoundInstance).collect(DaggerStreams.toImmutableSet());
    }

    final Element elementForRequirement(ComponentRequirement requirement) {
        return (Element)this.requirementElements().get((Object)requirement);
    }

    static ComponentCreatorDescriptor create(DeclaredType type, DaggerElements elements, DaggerTypes types, DependencyRequestFactory dependencyRequestFactory) {
        TypeElement typeElement = MoreTypes.asTypeElement(type);
        TypeMirror componentType = typeElement.getEnclosingElement().asType();
        ImmutableSetMultimap.Builder setterMethods = ImmutableSetMultimap.builder();
        ExecutableElement factoryMethod = null;
        for (ExecutableElement method : elements.getUnimplementedMethods(typeElement)) {
            ExecutableType resolvedMethodType = MoreTypes.asExecutable(types.asMemberOf(type, method));
            if (types.isSubtype(componentType, resolvedMethodType.getReturnType())) {
                factoryMethod = method;
                continue;
            }
            VariableElement parameter = (VariableElement)Iterables.getOnlyElement(method.getParameters());
            TypeMirror parameterType = (TypeMirror)Iterables.getOnlyElement(resolvedMethodType.getParameterTypes());
            setterMethods.put((Object)ComponentCreatorDescriptor.requirement(method, parameter, parameterType, dependencyRequestFactory, method), (Object)method);
        }
        Verify.verify((factoryMethod != null ? 1 : 0) != 0);
        ImmutableSetMultimap.Builder factoryParameters = ImmutableSetMultimap.builder();
        ExecutableType resolvedFactoryMethodType = MoreTypes.asExecutable(types.asMemberOf(type, factoryMethod));
        List<? extends VariableElement> parameters = factoryMethod.getParameters();
        List<? extends TypeMirror> parameterTypes = resolvedFactoryMethodType.getParameterTypes();
        for (int i = 0; i < parameters.size(); ++i) {
            VariableElement parameter = parameters.get(i);
            TypeMirror parameterType = parameterTypes.get(i);
            factoryParameters.put((Object)ComponentCreatorDescriptor.requirement(factoryMethod, parameter, parameterType, dependencyRequestFactory, parameter), (Object)parameter);
        }
        ComponentCreatorAnnotation annotation = (ComponentCreatorAnnotation)((Object)Iterables.getOnlyElement(ComponentCreatorAnnotation.getCreatorAnnotations(typeElement)));
        return new AutoValue_ComponentCreatorDescriptor(annotation, typeElement, factoryMethod, (ImmutableSetMultimap<ComponentRequirement, ExecutableElement>)setterMethods.build(), (ImmutableSetMultimap<ComponentRequirement, VariableElement>)factoryParameters.build());
    }

    private static ComponentRequirement requirement(ExecutableElement method, VariableElement parameter, TypeMirror type, DependencyRequestFactory dependencyRequestFactory, Element elementForVariableName) {
        if (MoreElements.isAnnotationPresent(method, BindsInstance.class) || MoreElements.isAnnotationPresent(parameter, BindsInstance.class)) {
            DependencyRequest request = dependencyRequestFactory.forRequiredResolvedVariable(parameter, type);
            String variableName = elementForVariableName.getSimpleName().toString();
            return ComponentRequirement.forBoundInstance(request.key(), request.isNullable(), variableName);
        }
        return ModuleAnnotation.moduleAnnotation(MoreTypes.asTypeElement(type)).isPresent() ? ComponentRequirement.forModule(type) : ComponentRequirement.forDependency(type);
    }
}

