/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingGraphFactory;
import dagger.internal.codegen.ClearableCache;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentGenerator;
import dagger.internal.codegen.ComponentImplementation;
import dagger.internal.codegen.CurrentImplementationSubcomponent;
import dagger.internal.codegen.DeserializedComponentImplementationBuilder;
import dagger.internal.codegen.KeyFactory;
import dagger.internal.codegen.SubcomponentNames;
import dagger.internal.codegen.TopLevelImplementationComponent;
import dagger.internal.codegen.Util;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.serialization.ProtoSerialization;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@Singleton
final class ComponentImplementationFactory
implements ClearableCache {
    private final Map<TypeElement, ComponentImplementation> topLevelComponentCache = new HashMap<TypeElement, ComponentImplementation>();
    private final KeyFactory keyFactory;
    private final CompilerOptions compilerOptions;
    private final BindingGraphFactory bindingGraphFactory;
    private final TopLevelImplementationComponent.Builder topLevelImplementationComponentBuilder;
    private final DeserializedComponentImplementationBuilder deserializedComponentImplementationBuilder;
    private final DaggerElements elements;
    private final Messager messager;

    @Inject
    ComponentImplementationFactory(KeyFactory keyFactory, CompilerOptions compilerOptions, BindingGraphFactory bindingGraphFactory, TopLevelImplementationComponent.Builder topLevelImplementationComponentBuilder, DeserializedComponentImplementationBuilder deserializedComponentImplementationBuilder, DaggerElements elements, Messager messager) {
        this.keyFactory = keyFactory;
        this.compilerOptions = compilerOptions;
        this.bindingGraphFactory = bindingGraphFactory;
        this.topLevelImplementationComponentBuilder = topLevelImplementationComponentBuilder;
        this.deserializedComponentImplementationBuilder = deserializedComponentImplementationBuilder;
        this.elements = elements;
        this.messager = messager;
    }

    ComponentImplementation createComponentImplementation(BindingGraph bindingGraph) {
        return Util.reentrantComputeIfAbsent(this.topLevelComponentCache, bindingGraph.componentTypeElement(), component -> this.createComponentImplementationUncached(bindingGraph));
    }

    private ComponentImplementation createComponentImplementationUncached(BindingGraph bindingGraph) {
        ComponentImplementation componentImplementation = ComponentImplementation.topLevelComponentImplementation(bindingGraph, ComponentGenerator.componentName(bindingGraph.componentTypeElement()), new SubcomponentNames(bindingGraph, this.keyFactory), this.compilerOptions);
        CurrentImplementationSubcomponent currentImplementationSubcomponent = this.topLevelImplementationComponentBuilder.topLevelComponent(componentImplementation).build().currentImplementationSubcomponentBuilder().componentImplementation(componentImplementation).bindingGraph(bindingGraph).parentBuilder(Optional.empty()).parentBindingExpressions(Optional.empty()).parentRequirementExpressions(Optional.empty()).build();
        if (componentImplementation.isAbstract()) {
            Preconditions.checkState((boolean)this.compilerOptions.aheadOfTimeSubcomponents(), (String)"Calling 'componentImplementation()' on %s when not generating ahead-of-time subcomponents.", (Object)bindingGraph.componentTypeElement());
            return currentImplementationSubcomponent.subcomponentBuilder().build();
        }
        return currentImplementationSubcomponent.rootComponentBuilder().build();
    }

    ComponentImplementation findChildSuperclassImplementation(ComponentDescriptor child, ComponentImplementation parentImplementation) {
        Optional<ComponentImplementation> parent = parentImplementation.superclassImplementation();
        while (parent.isPresent()) {
            Optional<ComponentImplementation> superclass = parent.get().childImplementation(child);
            if (superclass.isPresent()) {
                return superclass.get();
            }
            parent = parent.get().superclassImplementation();
        }
        if (this.compilerOptions.emitModifiableMetadataAnnotations()) {
            ClassName childSuperclassName = ComponentGenerator.componentName(child.typeElement());
            TypeElement generatedChildSuperclassImplementation = this.elements.getTypeElement(childSuperclassName);
            if (generatedChildSuperclassImplementation != null) {
                try {
                    return this.deserializedComponentImplementationBuilder.create(child, generatedChildSuperclassImplementation);
                }
                catch (ProtoSerialization.InconsistentSerializedProtoException e) {
                    this.messager.printMessage(Diagnostic.Kind.WARNING, String.format("%s was compiled with a different version of Dagger than the version in this compilation. To ensure the validity of Dagger's generated code, compile all Dagger code with the same version.", child.typeElement().getQualifiedName()));
                }
            } else if (this.compilerOptions.forceUseSerializedComponentImplementations()) {
                throw new TypeNotPresentException(childSuperclassName.toString(), null);
            }
        }
        BindingGraph truncatedBindingGraph = this.bindingGraphFactory.create(child, false);
        return this.createComponentImplementation(truncatedBindingGraph);
    }

    @Override
    public void clearCache() {
        this.topLevelComponentCache.clear();
    }
}

