/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import dagger.Component;
import dagger.Module;
import dagger.Subcomponent;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.ModuleKind;
import dagger.producers.ProducerModule;
import dagger.producers.ProductionComponent;
import dagger.producers.ProductionSubcomponent;
import dagger.shaded.auto.common.MoreElements;
import java.lang.annotation.Annotation;
import java.util.EnumSet;
import java.util.Optional;
import javax.lang.model.element.TypeElement;

enum ComponentKind {
    COMPONENT(Component.class, true, false),
    SUBCOMPONENT(Subcomponent.class, false, false),
    PRODUCTION_COMPONENT(ProductionComponent.class, true, true),
    PRODUCTION_SUBCOMPONENT(ProductionSubcomponent.class, false, true),
    MODULE(Module.class, true, false),
    PRODUCER_MODULE(ProducerModule.class, true, true);

    private static final ImmutableSet<ComponentKind> ROOT_COMPONENT_KINDS;
    private static final ImmutableSet<ComponentKind> SUBCOMPONENT_KINDS;
    private final Class<? extends Annotation> annotation;
    private final boolean isRoot;
    private final boolean production;

    static ImmutableSet<ComponentKind> rootComponentKinds() {
        return ROOT_COMPONENT_KINDS;
    }

    static ImmutableSet<ComponentKind> subcomponentKinds() {
        return SUBCOMPONENT_KINDS;
    }

    static ImmutableSet<Class<? extends Annotation>> annotationsFor(Iterable<ComponentKind> kinds) {
        return DaggerStreams.stream(kinds).map(ComponentKind::annotation).collect(DaggerStreams.toImmutableSet());
    }

    static ImmutableSet<ComponentKind> getComponentKinds(TypeElement element) {
        return DaggerStreams.valuesOf(ComponentKind.class).filter(kind -> MoreElements.isAnnotationPresent(element, kind.annotation())).collect(DaggerStreams.toImmutableSet());
    }

    static Optional<ComponentKind> forAnnotatedElement(TypeElement element) {
        ImmutableSet<ComponentKind> kinds = ComponentKind.getComponentKinds(element);
        if (kinds.size() > 1) {
            throw new IllegalArgumentException(element + " cannot be annotated with more than one of " + ComponentKind.annotationsFor(kinds));
        }
        return kinds.stream().findAny();
    }

    private ComponentKind(Class<? extends Annotation> annotation, boolean isRoot, boolean production) {
        this.annotation = annotation;
        this.isRoot = isRoot;
        this.production = production;
    }

    Class<? extends Annotation> annotation() {
        return this.annotation;
    }

    ImmutableSet<ModuleKind> legalModuleKinds() {
        return this.isProducer() ? Sets.immutableEnumSet(EnumSet.allOf(ModuleKind.class)) : Sets.immutableEnumSet((Enum)ModuleKind.MODULE, (Enum[])new ModuleKind[0]);
    }

    ImmutableSet<ComponentKind> legalSubcomponentKinds() {
        return this.isProducer() ? Sets.immutableEnumSet((Enum)PRODUCTION_SUBCOMPONENT, (Enum[])new ComponentKind[0]) : Sets.immutableEnumSet((Enum)SUBCOMPONENT, (Enum[])new ComponentKind[]{PRODUCTION_SUBCOMPONENT});
    }

    boolean isRoot() {
        return this.isRoot;
    }

    boolean isProducer() {
        return this.production;
    }

    boolean isForModuleValidation() {
        switch (this) {
            case MODULE: 
            case PRODUCER_MODULE: {
                return true;
            }
        }
        return false;
    }

    static {
        ROOT_COMPONENT_KINDS = DaggerStreams.valuesOf(ComponentKind.class).filter(kind -> !kind.isForModuleValidation()).filter(kind -> kind.isRoot()).collect(DaggerStreams.toImmutableSet());
        SUBCOMPONENT_KINDS = DaggerStreams.valuesOf(ComponentKind.class).filter(kind -> !kind.isForModuleValidation()).filter(kind -> !kind.isRoot()).collect(DaggerStreams.toImmutableSet());
    }
}

