/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.graph.Graph;
import com.google.common.graph.Graphs;
import com.google.common.graph.SuccessorsFunction;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;

public final class DaggerGraphs {
    public static <N> ImmutableList<N> shortestPath(SuccessorsFunction<N> graph, N nodeU, N nodeV) {
        if (nodeU.equals(nodeV)) {
            return ImmutableList.of(nodeU);
        }
        ImmutableSet successors = ImmutableSet.copyOf((Iterable)graph.successors(nodeU));
        if (successors.contains(nodeV)) {
            return ImmutableList.of(nodeU, nodeV);
        }
        HashMap<Object, Object> visitedNodeToPathPredecessor = new HashMap<Object, Object>();
        for (Object node : successors) {
            visitedNodeToPathPredecessor.put(node, nodeU);
        }
        ArrayDeque currentNodes = new ArrayDeque(successors);
        ArrayDeque nextNodes = new ArrayDeque();
        while (!currentNodes.isEmpty()) {
            while (!currentNodes.isEmpty()) {
                Object currentNode = currentNodes.remove();
                for (Object nextNode : graph.successors(currentNode)) {
                    if (visitedNodeToPathPredecessor.containsKey(nextNode)) continue;
                    visitedNodeToPathPredecessor.put(nextNode, currentNode);
                    if (nextNode.equals(nodeV)) {
                        ImmutableList.Builder builder = ImmutableList.builder();
                        Object node = nodeV;
                        builder.add(node);
                        while (!node.equals(nodeU)) {
                            node = visitedNodeToPathPredecessor.get(node);
                            builder.add(node);
                        }
                        return builder.build().reverse();
                    }
                    nextNodes.add(nextNode);
                }
            }
            ArrayDeque emptyQueue = currentNodes;
            currentNodes = nextNodes;
            nextNodes = emptyQueue;
        }
        return ImmutableList.of();
    }

    public static <N> ImmutableSet<N> unreachableNodes(Graph<N> graph, N node) {
        return ImmutableSet.copyOf((Collection)Sets.difference((Set)graph.nodes(), (Set)Graphs.reachableNodes(graph, node)));
    }

    private DaggerGraphs() {
    }
}

