/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.MethodSignatureFormatter;
import dagger.internal.codegen.Scopes;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.model.Binding;
import dagger.model.BindingGraph;
import dagger.model.BindingKind;
import dagger.model.Scope;
import dagger.shaded.auto.common.MoreElements;
import dagger.spi.BindingGraphPlugin;
import dagger.spi.DiagnosticReporter;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;

final class IncompatiblyScopedBindingsValidator
implements BindingGraphPlugin {
    private final MethodSignatureFormatter methodSignatureFormatter;
    private final CompilerOptions compilerOptions;

    @Inject
    IncompatiblyScopedBindingsValidator(MethodSignatureFormatter methodSignatureFormatter, CompilerOptions compilerOptions) {
        this.methodSignatureFormatter = methodSignatureFormatter;
        this.compilerOptions = compilerOptions;
    }

    public String pluginName() {
        return "Dagger/IncompatiblyScopedBindings";
    }

    public void visitGraph(BindingGraph bindingGraph, DiagnosticReporter diagnosticReporter) {
        ImmutableSetMultimap.Builder incompatibleBindings = ImmutableSetMultimap.builder();
        for (Binding binding : bindingGraph.bindings()) {
            binding.scope().filter(scope -> !scope.isReusable()).ifPresent(scope -> {
                BindingGraph.ComponentNode componentNode = (BindingGraph.ComponentNode)bindingGraph.componentNode(binding.componentPath()).get();
                if (!componentNode.scopes().contains(scope)) {
                    if (binding.kind().equals((Object)BindingKind.INJECTION) && (bindingGraph.rootComponentNode().isSubcomponent() || !bindingGraph.rootComponentNode().isRealComponent())) {
                        return;
                    }
                    incompatibleBindings.put((Object)componentNode, (Object)binding);
                }
            });
        }
        Multimaps.asMap((SetMultimap)incompatibleBindings.build()).forEach((componentNode, bindings) -> this.report((BindingGraph.ComponentNode)componentNode, (Set<Binding>)bindings, diagnosticReporter));
    }

    private void report(BindingGraph.ComponentNode componentNode, Set<Binding> bindings, DiagnosticReporter diagnosticReporter) {
        Diagnostic.Kind diagnosticKind = Diagnostic.Kind.ERROR;
        StringBuilder message = new StringBuilder(componentNode.componentPath().currentComponent().getQualifiedName());
        if (!componentNode.isRealComponent()) {
            if (bindings.stream().map(Binding::scope).map(Optional::get).distinct().count() <= 1L) {
                return;
            }
            message.append(" contains bindings with different scopes:");
            diagnosticKind = this.compilerOptions.moduleHasDifferentScopesDiagnosticKind();
        } else if (componentNode.scopes().isEmpty()) {
            message.append(" (unscoped) may not reference scoped bindings:");
        } else {
            message.append(" scoped with ").append(componentNode.scopes().stream().map(Scopes::getReadableSource).collect(Collectors.joining(" "))).append(" may not reference bindings with different scopes:");
        }
        block4: for (Binding binding : bindings) {
            message.append('\n').append("    ");
            switch (binding.kind()) {
                case DELEGATE: 
                case PROVISION: {
                    message.append(this.methodSignatureFormatter.format(MoreElements.asExecutable((Element)binding.bindingElement().get())));
                    continue block4;
                }
                case INJECTION: {
                    message.append(Scopes.getReadableSource((Scope)binding.scope().get())).append(" class ").append(DaggerElements.closestEnclosingTypeElement((Element)binding.bindingElement().get()).getQualifiedName());
                    continue block4;
                }
            }
            throw new AssertionError(binding);
        }
        diagnosticReporter.reportComponent(diagnosticKind, componentNode, message.toString());
    }
}

