/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import dagger.internal.codegen.AutoValue_InjectionMethod;
import dagger.internal.codegen.UniqueNameSet;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.langmodel.DaggerElements;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Parameterizable;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

@AutoValue
abstract class InjectionMethod {
    InjectionMethod() {
    }

    abstract String name();

    abstract boolean varargs();

    abstract ImmutableList<TypeVariableName> typeVariables();

    abstract ImmutableMap<ParameterSpec, TypeMirror> parameters();

    abstract Optional<TypeMirror> returnType();

    abstract Optional<DeclaredType> nullableAnnotation();

    abstract ImmutableList<TypeMirror> exceptions();

    abstract CodeBlock methodBody();

    abstract ClassName enclosingClass();

    MethodSpec toMethodSpec() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)this.name()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).varargs(this.varargs()).addTypeVariables(this.typeVariables()).addParameters((Iterable)this.parameters().keySet()).addCode(this.methodBody());
        this.returnType().map(TypeName::get).ifPresent(arg_0 -> ((MethodSpec.Builder)builder).returns(arg_0));
        this.nullableAnnotation().ifPresent(nullableType -> CodeBlocks.addAnnotation(builder, nullableType));
        this.exceptions().stream().map(TypeName::get).forEach(arg_0 -> ((MethodSpec.Builder)builder).addException(arg_0));
        return builder.build();
    }

    CodeBlock invoke(List<CodeBlock> arguments, ClassName requestingClass) {
        Preconditions.checkArgument((arguments.size() == this.parameters().size() ? 1 : 0) != 0);
        CodeBlock.Builder invocation = CodeBlock.builder();
        if (!this.enclosingClass().equals((Object)requestingClass)) {
            invocation.add("$T.", new Object[]{this.enclosingClass()});
        }
        return invocation.add("$L($L)", new Object[]{this.name(), CodeBlocks.makeParametersCodeBlock(arguments)}).build();
    }

    public final int hashCode() {
        return System.identityHashCode(this);
    }

    public final boolean equals(Object obj) {
        return this == obj;
    }

    static Builder builder(DaggerElements elements) {
        AutoValue_InjectionMethod.Builder builder = new AutoValue_InjectionMethod.Builder();
        ((Builder)builder).elements = elements;
        ((Builder)builder).varargs(false).exceptions((Iterable<? extends TypeMirror>)ImmutableList.of()).nullableAnnotation(Optional.empty());
        return builder;
    }

    @CanIgnoreReturnValue
    @AutoValue.Builder
    static abstract class Builder {
        private final UniqueNameSet parameterNames = new UniqueNameSet();
        private final CodeBlock.Builder methodBody = CodeBlock.builder();
        private DaggerElements elements;

        Builder() {
        }

        abstract ImmutableMap.Builder<ParameterSpec, TypeMirror> parametersBuilder();

        abstract ImmutableList.Builder<TypeVariableName> typeVariablesBuilder();

        abstract Builder name(String var1);

        abstract Builder varargs(boolean var1);

        abstract Builder returnType(TypeMirror var1);

        abstract Builder exceptions(Iterable<? extends TypeMirror> var1);

        abstract Builder nullableAnnotation(Optional<DeclaredType> var1);

        abstract Builder methodBody(CodeBlock var1);

        final CodeBlock.Builder methodBodyBuilder() {
            return this.methodBody;
        }

        abstract Builder enclosingClass(ClassName var1);

        ParameterSpec addParameter(String name, TypeMirror type) {
            ParameterSpec parameter = ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)type), (String)this.parameterNames.getUniqueName(name), (Modifier[])new Modifier[0]).build();
            this.parametersBuilder().put((Object)parameter, (Object)type);
            return parameter;
        }

        CodeBlock copyParameters(ExecutableElement method) {
            ImmutableList.Builder argumentsBuilder = ImmutableList.builder();
            for (VariableElement variableElement : method.getParameters()) {
                argumentsBuilder.add((Object)this.copyParameter(variableElement));
            }
            this.varargs(method.isVarArgs());
            return CodeBlocks.makeParametersCodeBlock((Iterable<CodeBlock>)argumentsBuilder.build());
        }

        CodeBlock copyParameter(VariableElement parameter) {
            TypeMirror elementType = parameter.asType();
            boolean useObject = !Accessibility.isRawTypePubliclyAccessible(elementType);
            TypeMirror publicType = useObject ? this.objectType() : elementType;
            ParameterSpec parameterSpec = this.addParameter(parameter.getSimpleName().toString(), publicType);
            return useObject ? CodeBlock.of((String)"($T) $N", (Object[])new Object[]{elementType, parameterSpec}) : CodeBlock.of((String)"$N", (Object[])new Object[]{parameterSpec});
        }

        private TypeMirror objectType() {
            return this.elements.getTypeElement(Object.class).asType();
        }

        Builder copyTypeParameters(Parameterizable parameterizable) {
            parameterizable.getTypeParameters().stream().map(TypeVariableName::get).forEach(arg_0 -> this.typeVariablesBuilder().add(arg_0));
            return this;
        }

        Builder copyThrows(ExecutableElement element) {
            this.exceptions(element.getThrownTypes());
            return this;
        }

        @CheckReturnValue
        final InjectionMethod build() {
            return this.methodBody(this.methodBody.build()).buildInternal();
        }

        abstract InjectionMethod buildInternal();
    }
}

