/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import dagger.internal.codegen.DiagnosticFormatting;
import dagger.internal.codegen.Formatter;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;

final class MethodSignatureFormatter
extends Formatter<ExecutableElement> {
    private final DaggerTypes types;

    @Inject
    MethodSignatureFormatter(DaggerTypes types) {
        this.types = types;
    }

    Formatter<ExecutableElement> typedFormatter(final DeclaredType declaredType) {
        return new Formatter<ExecutableElement>(){

            @Override
            public String format(ExecutableElement method) {
                return MethodSignatureFormatter.this.format(method, MoreTypes.asExecutable(MethodSignatureFormatter.this.types.asMemberOf(declaredType, method)), MoreElements.asType(method.getEnclosingElement()));
            }
        };
    }

    @Override
    public String format(ExecutableElement method) {
        return this.format(method, Optional.empty());
    }

    public String format(ExecutableElement method, Optional<DeclaredType> container) {
        TypeElement type = MoreElements.asType(method.getEnclosingElement());
        ExecutableType executableType = MoreTypes.asExecutable(method.asType());
        if (container.isPresent()) {
            executableType = MoreTypes.asExecutable(this.types.asMemberOf(container.get(), method));
            type = MoreElements.asType(container.get().asElement());
        }
        return this.format(method, executableType, type);
    }

    private String format(ExecutableElement method, ExecutableType methodType, TypeElement declaringType) {
        StringBuilder builder = new StringBuilder();
        List<? extends AnnotationMirror> annotations = method.getAnnotationMirrors();
        if (!annotations.isEmpty()) {
            Iterator<? extends AnnotationMirror> annotationIterator = annotations.iterator();
            int i = 0;
            while (annotationIterator.hasNext()) {
                if (i > 0) {
                    builder.append(' ');
                }
                builder.append(MethodSignatureFormatter.formatAnnotation(annotationIterator.next()));
                ++i;
            }
            builder.append(' ');
        }
        if (method.getSimpleName().contentEquals("<init>")) {
            builder.append(declaringType.getQualifiedName());
        } else {
            builder.append(MethodSignatureFormatter.nameOfType(methodType.getReturnType())).append(' ').append(declaringType.getQualifiedName()).append('.').append(method.getSimpleName());
        }
        builder.append('(');
        Preconditions.checkState((method.getParameters().size() == methodType.getParameterTypes().size() ? 1 : 0) != 0);
        Iterator<? extends VariableElement> parameters = method.getParameters().iterator();
        Iterator<? extends TypeMirror> parameterTypes = methodType.getParameterTypes().iterator();
        int i = 0;
        while (parameters.hasNext()) {
            if (i > 0) {
                builder.append(", ");
            }
            MethodSignatureFormatter.appendParameter(builder, parameters.next(), parameterTypes.next());
            ++i;
        }
        builder.append(')');
        return builder.toString();
    }

    private static void appendParameter(StringBuilder builder, VariableElement parameter, TypeMirror type) {
        InjectionAnnotations.getQualifier(parameter).ifPresent(qualifier -> builder.append(MethodSignatureFormatter.formatAnnotation(qualifier)).append(' '));
        builder.append(MethodSignatureFormatter.nameOfType(type));
    }

    private static String nameOfType(TypeMirror type) {
        return DiagnosticFormatting.stripCommonTypePrefixes(type.toString());
    }

    private static String formatAnnotation(AnnotationMirror annotation) {
        return DiagnosticFormatting.stripCommonTypePrefixes(annotation.toString());
    }
}

