/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.auto.value.AutoValue;
import com.google.common.base.Equivalence;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.squareup.javapoet.MethodSpec;
import dagger.internal.codegen.AutoValue_ModifiableBindingMethods_ModifiableBindingMethod;
import dagger.internal.codegen.BindingRequest;
import dagger.internal.codegen.ModifiableBindingType;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.type.TypeMirror;

final class ModifiableBindingMethods {
    private final Map<BindingRequest, ModifiableBindingMethod> methods = Maps.newLinkedHashMap();

    ModifiableBindingMethods() {
    }

    void addModifiableMethod(ModifiableBindingType type, BindingRequest request, TypeMirror returnType, MethodSpec method, boolean finalized) {
        this.addMethod(ModifiableBindingMethod.create(type, request, returnType, method, finalized));
    }

    void addReimplementedMethod(ModifiableBindingMethod method) {
        this.addMethod(method);
    }

    private void addMethod(ModifiableBindingMethod method) {
        ModifiableBindingMethod previousMethod = this.methods.put(method.request(), method);
        Verify.verify((previousMethod == null ? 1 : 0) != 0, (String)"registering %s but %s is already registered for the same binding request", (Object)method, (Object)previousMethod);
    }

    ImmutableMap<BindingRequest, ModifiableBindingMethod> getNonFinalizedMethods() {
        return ImmutableMap.copyOf((Map)Maps.filterValues(this.methods, m -> !m.finalized()));
    }

    Optional<ModifiableBindingMethod> getMethod(BindingRequest request) {
        return Optional.ofNullable(this.methods.get(request));
    }

    ImmutableList<ModifiableBindingMethod> allMethods() {
        return ImmutableList.copyOf(this.methods.values());
    }

    boolean finalized(ModifiableBindingMethod method) {
        ModifiableBindingMethod storedMethod = this.methods.get(method.request());
        return storedMethod != null && storedMethod.finalized();
    }

    @AutoValue
    static abstract class ModifiableBindingMethod {
        ModifiableBindingMethod() {
        }

        private static ModifiableBindingMethod create(ModifiableBindingType type, BindingRequest request, TypeMirror returnType, MethodSpec methodSpec, boolean finalized) {
            return new AutoValue_ModifiableBindingMethods_ModifiableBindingMethod(type, request, (Equivalence.Wrapper<TypeMirror>)MoreTypes.equivalence().wrap((Object)returnType), methodSpec, finalized);
        }

        ModifiableBindingMethod reimplement(ModifiableBindingType newModifiableBindingType, MethodSpec newImplementation, boolean finalized) {
            return new AutoValue_ModifiableBindingMethods_ModifiableBindingMethod(newModifiableBindingType, this.request(), this.returnTypeWrapper(), newImplementation, finalized);
        }

        abstract ModifiableBindingType type();

        abstract BindingRequest request();

        final TypeMirror returnType() {
            return (TypeMirror)this.returnTypeWrapper().get();
        }

        abstract Equivalence.Wrapper<TypeMirror> returnTypeWrapper();

        abstract MethodSpec methodSpec();

        abstract boolean finalized();

        boolean fulfillsSameRequestAs(ModifiableBindingMethod other) {
            return this.request().equals(other.request());
        }
    }
}

