/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.BindingExpression;
import dagger.internal.codegen.BindingRequest;
import dagger.internal.codegen.ComponentImplementation;
import dagger.internal.codegen.MethodBindingExpression;
import dagger.internal.codegen.ModifiableBindingType;
import dagger.internal.codegen.ResolvedBindings;
import dagger.internal.codegen.langmodel.DaggerTypes;
import java.util.Optional;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

final class ModifiableConcreteMethodBindingExpression
extends MethodBindingExpression {
    private final BindingRequest request;
    private final ModifiableBindingType modifiableBindingType;
    private final ComponentImplementation componentImplementation;
    private final boolean bindingCannotBeModified;
    private Optional<String> methodName = Optional.empty();

    ModifiableConcreteMethodBindingExpression(BindingRequest request, ResolvedBindings resolvedBindings, MethodBindingExpression.MethodImplementationStrategy methodImplementationStrategy, BindingExpression wrappedBindingExpression, ModifiableBindingType modifiableBindingType, ComponentImplementation componentImplementation, boolean bindingCannotBeModified, DaggerTypes types) {
        super(request, resolvedBindings, methodImplementationStrategy, wrappedBindingExpression, componentImplementation, types);
        this.request = (BindingRequest)Preconditions.checkNotNull((Object)request);
        this.modifiableBindingType = (ModifiableBindingType)((Object)Preconditions.checkNotNull((Object)((Object)modifiableBindingType)));
        this.componentImplementation = (ComponentImplementation)Preconditions.checkNotNull((Object)componentImplementation);
        this.bindingCannotBeModified = bindingCannotBeModified;
    }

    @Override
    protected void addMethod() {
        if (this.methodName.isPresent()) {
            return;
        }
        if (this.supertypeModifiableBindingMethod().isPresent()) {
            this.methodName = this.supertypeModifiableBindingMethod().map(method -> method.methodSpec().name);
            return;
        }
        this.methodName = Optional.of(this.componentImplementation.getUniqueMethodName(this.request));
        this.componentImplementation.addModifiableBindingMethod(this.modifiableBindingType, this.request, this.returnType(), MethodSpec.methodBuilder((String)this.methodName.get()).addModifiers(new Modifier[]{this.bindingCannotBeModified ? Modifier.PRIVATE : Modifier.PROTECTED}).returns(TypeName.get((TypeMirror)this.returnType())).addCode(this.methodBody()).build(), this.bindingCannotBeModified);
    }

    @Override
    protected String methodName() {
        Preconditions.checkState((boolean)this.methodName.isPresent(), (Object)"addMethod() must be called before methodName().");
        return this.methodName.get();
    }

    @Override
    protected boolean isModifiableImplementationMethod() {
        return true;
    }
}

