/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import dagger.Module;
import dagger.internal.codegen.AutoValue_ModuleAnnotation;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.MoreAnnotationValues;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.producers.ProducerModule;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.TypeElement;

@AutoValue
abstract class ModuleAnnotation {
    private static final ImmutableSet<Class<? extends Annotation>> MODULE_ANNOTATIONS = ImmutableSet.of(Module.class, ProducerModule.class);

    ModuleAnnotation() {
    }

    abstract AnnotationMirror annotation();

    Class<?> annotationClass() {
        try {
            return Class.forName(MoreTypes.asTypeElement(this.annotation().getAnnotationType()).getQualifiedName().toString());
        }
        catch (ClassNotFoundException e) {
            AssertionError assertionError = new AssertionError();
            ((Throwable)((Object)assertionError)).initCause(e);
            throw assertionError;
        }
    }

    ImmutableList<TypeElement> includes() {
        return this.includesAsAnnotationValues().stream().map(MoreAnnotationValues::asType).map(MoreTypes::asTypeElement).collect(DaggerStreams.toImmutableList());
    }

    ImmutableList<AnnotationValue> includesAsAnnotationValues() {
        return MoreAnnotationValues.asAnnotationValues(AnnotationMirrors.getAnnotationValue(this.annotation(), "includes"));
    }

    ImmutableList<TypeElement> subcomponents() {
        return this.subcomponentsAsAnnotationValues().stream().map(MoreAnnotationValues::asType).map(MoreTypes::asTypeElement).collect(DaggerStreams.toImmutableList());
    }

    ImmutableList<AnnotationValue> subcomponentsAsAnnotationValues() {
        return MoreAnnotationValues.asAnnotationValues(AnnotationMirrors.getAnnotationValue(this.annotation(), "subcomponents"));
    }

    static boolean isModuleAnnotation(AnnotationMirror annotation) {
        return MODULE_ANNOTATIONS.stream().map(Class::getCanonicalName).anyMatch(MoreTypes.asTypeElement(annotation.getAnnotationType()).getQualifiedName()::contentEquals);
    }

    static ImmutableSet<Class<? extends Annotation>> moduleAnnotations() {
        return MODULE_ANNOTATIONS;
    }

    static ModuleAnnotation moduleAnnotation(AnnotationMirror annotation) {
        Preconditions.checkArgument((boolean)ModuleAnnotation.isModuleAnnotation(annotation), (String)"%s is not a Module or ProducerModule annotation", (Object)annotation);
        return new AutoValue_ModuleAnnotation(annotation);
    }

    static Optional<ModuleAnnotation> moduleAnnotation(TypeElement typeElement) {
        return DaggerElements.getAnyAnnotation(typeElement, Module.class, ProducerModule.class).map(ModuleAnnotation::moduleAnnotation);
    }
}

