/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import java.util.Optional;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;

final class SourceFileGenerationException
extends Exception {
    private final Element associatedElement;

    SourceFileGenerationException(Optional<ClassName> generatedClassName, Throwable cause, Element associatedElement) {
        super(SourceFileGenerationException.createMessage(generatedClassName, cause.getMessage()), cause);
        this.associatedElement = (Element)Preconditions.checkNotNull((Object)associatedElement);
    }

    private static String createMessage(Optional<ClassName> generatedClassName, String message) {
        return String.format("Could not generate %s: %s.", generatedClassName.isPresent() ? generatedClassName.get() : "unknown file", message);
    }

    void printMessageTo(Messager messager) {
        messager.printMessage(Diagnostic.Kind.ERROR, this.getMessage(), this.associatedElement);
    }
}

