/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.serialization.TypeProto;
import dagger.shaded.auto.common.MoreTypes;
import javax.inject.Inject;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;

final class TypeProtoConverter {
    private final DaggerTypes types;
    private final DaggerElements elements;

    @Inject
    TypeProtoConverter(DaggerTypes types, DaggerElements elements) {
        this.types = types;
        this.elements = elements;
    }

    static TypeProto toProto(TypeMirror type) {
        TypeProto.Builder builder = TypeProto.newBuilder();
        int arrayDimensions = 0;
        while (type.getKind().equals((Object)TypeKind.ARRAY)) {
            type = MoreTypes.asArray(type).getComponentType();
            ++arrayDimensions;
        }
        builder.setArrayDimensions(arrayDimensions);
        if (type.getKind().isPrimitive()) {
            builder.setPrimitiveKind(TypeProto.PrimitiveKind.valueOf((String)type.getKind().name()));
        } else if (type.getKind().equals((Object)TypeKind.WILDCARD)) {
            WildcardType wildcardType = MoreTypes.asWildcard(type);
            TypeProto.Wildcard.Builder wildcardBuilder = TypeProto.Wildcard.newBuilder();
            if (wildcardType.getExtendsBound() != null) {
                wildcardBuilder.setExtendsBound(TypeProtoConverter.toProto(wildcardType.getExtendsBound()));
            } else if (wildcardType.getSuperBound() != null) {
                wildcardBuilder.setSuperBound(TypeProtoConverter.toProto(wildcardType.getSuperBound()));
            }
            builder.setWildcard(wildcardBuilder);
        } else {
            TypeElement typeElement = MoreTypes.asTypeElement(type);
            DeclaredType declaredType = MoreTypes.asDeclared(type);
            TypeMirror enclosingType = declaredType.getEnclosingType();
            if (enclosingType.getKind().equals((Object)TypeKind.NONE)) {
                builder.setQualifiedName(typeElement.getQualifiedName().toString());
            } else {
                builder.setEnclosingType(TypeProtoConverter.toProto(enclosingType)).setSimpleName(typeElement.getSimpleName().toString());
            }
            declaredType.getTypeArguments().stream().map(TypeProtoConverter::toProto).forEachOrdered(arg_0 -> ((TypeProto.Builder)builder).addTypeArguments(arg_0));
        }
        return builder.build();
    }

    TypeMirror fromProto(TypeProto type) {
        TypeMirror typeMirror;
        if (type.hasWildcard()) {
            return this.wildcardType(type.getWildcard());
        }
        TypeMirror[] typeArguments = (TypeMirror[])type.getTypeArgumentsList().stream().map(this::fromProto).toArray(TypeMirror[]::new);
        if (!type.getPrimitiveKind().equals((Object)TypeProto.PrimitiveKind.UNKNOWN)) {
            typeMirror = this.types.getPrimitiveType(TypeKind.valueOf(type.getPrimitiveKind().name()));
        } else if (type.hasEnclosingType()) {
            DeclaredType enclosingType = MoreTypes.asDeclared(this.fromProto(type.getEnclosingType()));
            TypeElement typeElement = ElementFilter.typesIn(enclosingType.asElement().getEnclosedElements()).stream().filter(inner -> inner.getSimpleName().contentEquals(type.getSimpleName())).findFirst().get();
            typeMirror = this.types.getDeclaredType(enclosingType, typeElement, typeArguments);
        } else {
            typeMirror = this.types.getDeclaredType(this.elements.getTypeElement(type.getQualifiedName()), typeArguments);
        }
        for (int i = 0; i < type.getArrayDimensions(); ++i) {
            typeMirror = this.types.getArrayType(typeMirror);
        }
        return typeMirror;
    }

    private TypeMirror wildcardType(TypeProto.Wildcard wildcard) {
        if (wildcard.hasExtendsBound()) {
            return this.types.getWildcardType(this.fromProto(wildcard.getExtendsBound()), null);
        }
        if (wildcard.hasSuperBound()) {
            return this.types.getWildcardType(null, this.fromProto(wildcard.getSuperBound()));
        }
        return this.types.getWildcardType(null, null);
    }
}

