/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingDeclarationFormatter;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingNode;
import dagger.internal.codegen.BindingRequest;
import dagger.internal.codegen.ChildFactoryMethodEdgeImpl;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentNodeImpl;
import dagger.internal.codegen.ComponentTreeTraverser;
import dagger.internal.codegen.DaggerGraphs;
import dagger.internal.codegen.DependencyEdgeImpl;
import dagger.internal.codegen.ResolvedBindings;
import dagger.internal.codegen.SubcomponentCreatorBindingEdgeImpl;
import dagger.model.BindingGraph;
import dagger.model.BindingGraphProxies;
import dagger.model.BindingKind;
import dagger.model.DependencyRequest;
import dagger.shaded.auto.common.MoreTypes;
import javax.inject.Inject;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

final class BindingGraphConverter {
    private final BindingDeclarationFormatter bindingDeclarationFormatter;

    @Inject
    BindingGraphConverter(BindingDeclarationFormatter bindingDeclarationFormatter) {
        this.bindingDeclarationFormatter = bindingDeclarationFormatter;
    }

    dagger.model.BindingGraph convert(BindingGraph bindingGraph) {
        Traverser traverser = new Traverser(bindingGraph);
        traverser.traverseComponents();
        if (!bindingGraph.isFullBindingGraph()) {
            DaggerGraphs.unreachableNodes(traverser.network.asGraph(), this.rootComponentNode((Network<BindingGraph.Node, BindingGraph.Edge>)traverser.network)).forEach(arg_0 -> ((MutableNetwork)traverser.network).removeNode(arg_0));
        }
        return BindingGraphProxies.bindingGraph((Network<BindingGraph.Node, BindingGraph.Edge>)traverser.network, bindingGraph.isFullBindingGraph());
    }

    private BindingGraph.ComponentNode rootComponentNode(Network<BindingGraph.Node, BindingGraph.Edge> network) {
        return (BindingGraph.ComponentNode)Iterables.find((Iterable)network.nodes(), node -> node instanceof BindingGraph.ComponentNode && node.componentPath().atRoot());
    }

    private final class Traverser
    extends ComponentTreeTraverser {
        private final MutableNetwork<BindingGraph.Node, BindingGraph.Edge> network;
        private BindingGraph.ComponentNode parentComponent;
        private BindingGraph.ComponentNode currentComponent;

        Traverser(BindingGraph graph) {
            super(graph);
            this.network = NetworkBuilder.directed().allowsParallelEdges(true).allowsSelfLoops(true).build();
        }

        @Override
        protected void visitComponent(BindingGraph graph) {
            BindingGraph.ComponentNode grandparentComponent = this.parentComponent;
            this.parentComponent = this.currentComponent;
            this.currentComponent = ComponentNodeImpl.create(this.componentPath(), graph.componentDescriptor());
            this.network.addNode((Object)this.currentComponent);
            for (ResolvedBindings resolvedBindings : graph.resolvedBindings()) {
                for (BindingNode binding : this.bindingNodes(resolvedBindings)) {
                    this.addBinding(binding);
                    if (!binding.kind().equals((Object)BindingKind.SUBCOMPONENT_CREATOR) || !binding.componentPath().equals((Object)this.currentComponent.componentPath())) continue;
                    this.network.addEdge((Object)binding, (Object)this.subcomponentNode(binding.key().type(), graph), (Object)new SubcomponentCreatorBindingEdgeImpl(resolvedBindings.subcomponentDeclarations()));
                }
            }
            super.visitComponent(graph);
            this.currentComponent = this.parentComponent;
            this.parentComponent = grandparentComponent;
        }

        @Override
        protected void visitEntryPoint(DependencyRequest entryPoint, BindingGraph graph) {
            this.addDependencyEdges((BindingGraph.Node)this.currentComponent, entryPoint);
            super.visitEntryPoint(entryPoint, graph);
        }

        @Override
        protected void visitSubcomponentFactoryMethod(BindingGraph graph, BindingGraph parent, ExecutableElement factoryMethod) {
            this.network.addEdge((Object)this.parentComponent, (Object)this.currentComponent, (Object)new ChildFactoryMethodEdgeImpl(factoryMethod));
            super.visitSubcomponentFactoryMethod(graph, parent, factoryMethod);
        }

        private void addDependencyEdges(BindingGraph.Node source, DependencyRequest dependencyRequest) {
            ResolvedBindings dependencies = this.resolvedDependencies(source, dependencyRequest);
            if (dependencies.isEmpty()) {
                this.addDependencyEdge(source, dependencyRequest, (BindingGraph.Node)this.missingBindingNode(dependencies));
            } else {
                for (BindingNode dependency : this.bindingNodes(dependencies)) {
                    this.addDependencyEdge(source, dependencyRequest, (BindingGraph.Node)dependency);
                }
            }
        }

        private void addDependencyEdge(BindingGraph.Node source, DependencyRequest dependencyRequest, BindingGraph.Node dependency) {
            this.network.addNode((Object)dependency);
            if (!this.hasDependencyEdge(source, dependency, dependencyRequest)) {
                this.network.addEdge((Object)source, (Object)dependency, (Object)new DependencyEdgeImpl(dependencyRequest, source instanceof BindingGraph.ComponentNode));
            }
        }

        private boolean hasDependencyEdge(BindingGraph.Node source, BindingGraph.Node dependency, DependencyRequest dependencyRequest) {
            for (BindingGraph.Edge edge : this.network.edgesConnecting((Object)source, (Object)dependency)) {
                if (!(edge instanceof BindingGraph.DependencyEdge) || !((BindingGraph.DependencyEdge)edge).dependencyRequest().equals(dependencyRequest)) continue;
                return true;
            }
            return false;
        }

        private ResolvedBindings resolvedDependencies(BindingGraph.Node source, DependencyRequest dependencyRequest) {
            return this.graphForAncestor(source.componentPath().currentComponent()).resolvedBindings(BindingRequest.bindingRequest(dependencyRequest));
        }

        private void addBinding(BindingNode binding) {
            this.network.addNode((Object)binding);
            for (DependencyRequest dependencyRequest : binding.dependencies()) {
                this.addDependencyEdges((BindingGraph.Node)binding, dependencyRequest);
            }
        }

        private ImmutableSet<BindingNode> bindingNodes(ResolvedBindings resolvedBindings) {
            ImmutableSet.Builder bindingNodes = ImmutableSet.builder();
            resolvedBindings.allBindings().asMap().forEach((component, bindings) -> {
                for (Binding binding : bindings) {
                    bindingNodes.add((Object)this.bindingNode(resolvedBindings, binding, (TypeElement)component));
                }
            });
            return bindingNodes.build();
        }

        private BindingNode bindingNode(ResolvedBindings resolvedBindings, Binding binding, TypeElement owningComponent) {
            return BindingNode.create(this.pathFromRootToAncestor(owningComponent), binding, resolvedBindings.multibindingDeclarations(), resolvedBindings.optionalBindingDeclarations(), resolvedBindings.subcomponentDeclarations(), BindingGraphConverter.this.bindingDeclarationFormatter);
        }

        private BindingGraph.MissingBinding missingBindingNode(ResolvedBindings dependencies) {
            return BindingGraphProxies.missingBindingNode(this.componentPath(), dependencies.key());
        }

        private BindingGraph.ComponentNode subcomponentNode(TypeMirror subcomponentBuilderType, BindingGraph graph) {
            TypeElement subcomponentBuilderElement = MoreTypes.asTypeElement(subcomponentBuilderType);
            ComponentDescriptor subcomponent = graph.componentDescriptor().getChildComponentWithBuilderType(subcomponentBuilderElement);
            return ComponentNodeImpl.create(this.componentPath().childPath(subcomponent.typeElement()), subcomponent);
        }
    }
}

