/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import dagger.BindsInstance;
import dagger.internal.codegen.BindsInstanceMethodValidator;
import dagger.internal.codegen.BindsInstanceParameterValidator;
import dagger.internal.codegen.TypeCheckingProcessingStep;
import dagger.shaded.auto.common.MoreElements;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.lang.model.element.Element;

final class BindsInstanceProcessingStep
extends TypeCheckingProcessingStep<Element> {
    private final BindsInstanceMethodValidator methodValidator;
    private final BindsInstanceParameterValidator parameterValidator;
    private final Messager messager;

    @Inject
    BindsInstanceProcessingStep(BindsInstanceMethodValidator methodValidator, BindsInstanceParameterValidator parameterValidator, Messager messager) {
        super(element -> element);
        this.methodValidator = methodValidator;
        this.parameterValidator = parameterValidator;
        this.messager = messager;
    }

    @Override
    public Set<? extends Class<? extends Annotation>> annotations() {
        return ImmutableSet.of(BindsInstance.class);
    }

    @Override
    protected void process(Element element, ImmutableSet<Class<? extends Annotation>> annotations) {
        switch (element.getKind()) {
            case PARAMETER: {
                this.parameterValidator.validate(MoreElements.asVariable(element)).printMessagesTo(this.messager);
                break;
            }
            case METHOD: {
                this.methodValidator.validate(MoreElements.asExecutable(element)).printMessagesTo(this.messager);
                break;
            }
            default: {
                throw new AssertionError(element);
            }
        }
    }
}

