/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import dagger.Binds;
import dagger.Module;
import dagger.internal.codegen.BindingElementValidator;
import dagger.internal.codegen.BindingMethodValidator;
import dagger.internal.codegen.BindsTypeChecker;
import dagger.internal.codegen.ContributionType;
import dagger.internal.codegen.DependencyRequestValidator;
import dagger.internal.codegen.SetType;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.producers.ProducerModule;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

final class BindsMethodValidator
extends BindingMethodValidator {
    private final DaggerTypes types;
    private final BindsTypeChecker bindsTypeChecker;

    @Inject
    BindsMethodValidator(DaggerElements elements, DaggerTypes types, DependencyRequestValidator dependencyRequestValidator) {
        super(elements, types, Binds.class, (Iterable<? extends Class<? extends Annotation>>)ImmutableSet.of(Module.class, ProducerModule.class), dependencyRequestValidator, BindingMethodValidator.Abstractness.MUST_BE_ABSTRACT, BindingMethodValidator.ExceptionSuperclass.NO_EXCEPTIONS, BindingElementValidator.AllowsMultibindings.ALLOWS_MULTIBINDINGS, BindingElementValidator.AllowsScoping.ALLOWS_SCOPING);
        this.types = types;
        this.bindsTypeChecker = new BindsTypeChecker(types, elements);
    }

    @Override
    protected BindingElementValidator.ElementValidator elementValidator(ExecutableElement element) {
        return new Validator(element);
    }

    private class Validator
    extends BindingMethodValidator.MethodValidator {
        Validator(ExecutableElement element) {
            super(BindsMethodValidator.this, element);
        }

        @Override
        protected void checkParameters() {
            if (((ExecutableElement)this.element).getParameters().size() != 1) {
                this.report.addError(BindsMethodValidator.this.bindingMethods("must have exactly one parameter, whose type is assignable to the return type", new Object[0]));
            } else {
                super.checkParameters();
            }
        }

        @Override
        protected void checkParameter(VariableElement parameter) {
            super.checkParameter(parameter);
            TypeMirror leftHandSide = this.boxIfNecessary(((ExecutableElement)this.element).getReturnType());
            TypeMirror rightHandSide = parameter.asType();
            ContributionType contributionType = ContributionType.fromBindingElement(this.element);
            if (contributionType.equals((Object)ContributionType.SET_VALUES) && !SetType.isSet(leftHandSide)) {
                this.report.addError("@Binds @ElementsIntoSet methods must return a Set and take a Set parameter");
            }
            if (!BindsMethodValidator.this.bindsTypeChecker.isAssignable(rightHandSide, leftHandSide, contributionType)) {
                this.report.addError("@Binds methods' parameter type must be assignable to the return type");
            }
        }

        private TypeMirror boxIfNecessary(TypeMirror maybePrimitive) {
            if (maybePrimitive.getKind().isPrimitive()) {
                return BindsMethodValidator.this.types.boxedClass(MoreTypes.asPrimitiveType(maybePrimitive)).asType();
            }
            return maybePrimitive;
        }
    }
}

