/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingRequest;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentCreatorDescriptor;
import dagger.internal.codegen.ComponentCreatorImplementation;
import dagger.internal.codegen.ComponentCreatorKind;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentRequirement;
import dagger.internal.codegen.KeyVariableNamer;
import dagger.internal.codegen.SubcomponentNames;
import dagger.internal.codegen.UniqueNameSet;
import dagger.internal.codegen.javapoet.TypeSpecs;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.model.Key;
import dagger.model.RequestKind;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

final class ComponentImplementation {
    private final CompilerOptions compilerOptions;
    private final ComponentDescriptor componentDescriptor;
    private final BindingGraph graph;
    private final ClassName name;
    private final NestingKind nestingKind;
    private Optional<ComponentCreatorImplementation> creatorImplementation;
    private final Map<TypeElement, ComponentImplementation> childImplementations = new HashMap<TypeElement, ComponentImplementation>();
    private final TypeSpec.Builder component;
    private final SubcomponentNames subcomponentNames;
    private final UniqueNameSet componentFieldNames = new UniqueNameSet();
    private final UniqueNameSet componentMethodNames = new UniqueNameSet();
    private final List<CodeBlock> initializations = new ArrayList<CodeBlock>();
    private final List<CodeBlock> componentRequirementInitializations = new ArrayList<CodeBlock>();
    private final Map<ComponentRequirement, String> componentRequirementParameterNames = new HashMap<ComponentRequirement, String>();
    private final Set<Key> cancellableProducerKeys = new LinkedHashSet<Key>();
    private final ListMultimap<FieldSpecKind, FieldSpec> fieldSpecsMap = MultimapBuilder.enumKeys(FieldSpecKind.class).arrayListValues().build();
    private final ListMultimap<MethodSpecKind, MethodSpec> methodSpecsMap = MultimapBuilder.enumKeys(MethodSpecKind.class).arrayListValues().build();
    private final ListMultimap<TypeSpecKind, TypeSpec> typeSpecsMap = MultimapBuilder.enumKeys(TypeSpecKind.class).arrayListValues().build();
    private final List<Supplier<TypeSpec>> switchingProviderSupplier = new ArrayList<Supplier<TypeSpec>>();

    private ComponentImplementation(ComponentDescriptor componentDescriptor, BindingGraph graph, ClassName name, NestingKind nestingKind, SubcomponentNames subcomponentNames, CompilerOptions compilerOptions, ImmutableSet<Modifier> modifiers) {
        ComponentImplementation.checkName(name, nestingKind);
        this.compilerOptions = compilerOptions;
        this.componentDescriptor = componentDescriptor;
        this.graph = graph;
        this.name = name;
        this.nestingKind = nestingKind;
        this.component = TypeSpec.classBuilder((ClassName)name);
        modifiers.forEach(xva$0 -> this.component.addModifiers(new Modifier[]{xva$0}));
        this.subcomponentNames = subcomponentNames;
    }

    static ComponentImplementation topLevelComponentImplementation(BindingGraph graph, ClassName name, SubcomponentNames subcomponentNames, CompilerOptions compilerOptions) {
        return new ComponentImplementation(graph.componentDescriptor(), graph, name, NestingKind.TOP_LEVEL, subcomponentNames, compilerOptions, ComponentImplementation.topLevelComponentImplementationModifiers(graph));
    }

    private static ImmutableSet<Modifier> topLevelComponentImplementationModifiers(BindingGraph graph) {
        ImmutableSet.Builder modifiers = ImmutableSet.builder();
        if (graph.componentTypeElement().getModifiers().contains((Object)Modifier.PUBLIC) || graph.componentDescriptor().isSubcomponent()) {
            modifiers.add((Object)Modifier.PUBLIC);
        }
        return modifiers.add((Object)(graph.componentDescriptor().isSubcomponent() ? Modifier.ABSTRACT : Modifier.FINAL)).build();
    }

    ComponentImplementation childComponentImplementation(BindingGraph graph, Modifier ... modifiers) {
        return new ComponentImplementation(graph.componentDescriptor(), graph, this.getSubcomponentName(graph.componentDescriptor()), NestingKind.MEMBER, this.subcomponentNames, this.compilerOptions, (ImmutableSet<Modifier>)ImmutableSet.copyOf((Object[])modifiers));
    }

    private static void checkName(ClassName name, NestingKind nestingKind) {
        switch (nestingKind) {
            case TOP_LEVEL: {
                Preconditions.checkArgument((name.enclosingClassName() == null ? 1 : 0) != 0, (String)"must be a top-level class name: %s", (Object)name);
                break;
            }
            case MEMBER: {
                Preconditions.checkNotNull((Object)name.enclosingClassName(), (String)"must not be a top-level class name: %s", (Object)name);
                break;
            }
            default: {
                throw new IllegalArgumentException("nestingKind must be TOP_LEVEL or MEMBER: " + (Object)((Object)nestingKind));
            }
        }
    }

    BindingGraph graph() {
        return this.graph;
    }

    ComponentDescriptor componentDescriptor() {
        return this.componentDescriptor;
    }

    ClassName name() {
        return this.name;
    }

    boolean isNested() {
        return this.nestingKind.isNested();
    }

    void setCreatorImplementation(Optional<ComponentCreatorImplementation> creatorImplementation) {
        Preconditions.checkState((this.creatorImplementation == null ? 1 : 0) != 0, (Object)"setCreatorImplementation has already been called");
        this.creatorImplementation = creatorImplementation;
    }

    Optional<ComponentCreatorImplementation> creatorImplementation() {
        Preconditions.checkState((this.creatorImplementation != null ? 1 : 0) != 0, (Object)"setCreatorImplementation has not been called yet");
        return this.creatorImplementation;
    }

    private ComponentCreatorKind creatorKind() {
        Preconditions.checkState((boolean)this.componentDescriptor().hasCreator());
        return this.componentDescriptor().creatorDescriptor().map(ComponentCreatorDescriptor::kind).orElse(ComponentCreatorKind.BUILDER);
    }

    ClassName getCreatorName() {
        return this.isNested() ? this.name.peerClass(this.subcomponentNames().getCreatorName(this.componentDescriptor())) : this.name.nestedClass(this.creatorKind().typeName());
    }

    ClassName getSubcomponentName(ComponentDescriptor childDescriptor) {
        Preconditions.checkArgument((boolean)this.componentDescriptor().childComponents().contains((Object)childDescriptor), (String)"%s is not a child component of %s", (Object)childDescriptor.typeElement(), (Object)this.componentDescriptor().typeElement());
        return this.name.nestedClass(this.subcomponentNames().get(childDescriptor) + "Impl");
    }

    String getSubcomponentCreatorSimpleName(Key key) {
        return this.subcomponentNames().getCreatorName(key);
    }

    private SubcomponentNames subcomponentNames() {
        return this.subcomponentNames;
    }

    boolean isTypeAccessible(TypeMirror type) {
        return Accessibility.isTypeAccessibleFrom(type, this.name.packageName());
    }

    void addSupertype(TypeElement supertype) {
        TypeSpecs.addSupertype(this.component, supertype);
    }

    void addField(FieldSpecKind fieldKind, FieldSpec fieldSpec) {
        this.fieldSpecsMap.put((Object)fieldKind, (Object)fieldSpec);
    }

    void addFields(FieldSpecKind fieldKind, Iterable<FieldSpec> fieldSpecs) {
        this.fieldSpecsMap.putAll((Object)fieldKind, fieldSpecs);
    }

    void addMethod(MethodSpecKind methodKind, MethodSpec methodSpec) {
        this.methodSpecsMap.put((Object)methodKind, (Object)methodSpec);
    }

    void addAnnotation(AnnotationSpec annotation) {
        this.component.addAnnotation(annotation);
    }

    void addType(TypeSpecKind typeKind, TypeSpec typeSpec) {
        this.typeSpecsMap.put((Object)typeKind, (Object)typeSpec);
    }

    void addChild(ComponentDescriptor child, ComponentImplementation childImplementation) {
        this.childImplementations.put(child.typeElement(), childImplementation);
        this.addType(TypeSpecKind.SUBCOMPONENT, childImplementation.generate().build());
    }

    void addSwitchingProvider(Supplier<TypeSpec> typeSpecSupplier) {
        this.switchingProviderSupplier.add(typeSpecSupplier);
    }

    void addInitialization(CodeBlock codeBlock) {
        this.initializations.add(codeBlock);
    }

    void addComponentRequirementInitialization(CodeBlock codeBlock) {
        this.componentRequirementInitializations.add(codeBlock);
    }

    void addCancellableProducerKey(Key key) {
        this.cancellableProducerKeys.add(key);
    }

    String getUniqueFieldName(String name) {
        return this.componentFieldNames.getUniqueName(name);
    }

    String getUniqueMethodName(String name) {
        return this.componentMethodNames.getUniqueName(name);
    }

    String getUniqueMethodName(BindingRequest request) {
        return this.uniqueMethodName(request, KeyVariableNamer.name(request.key()));
    }

    private String uniqueMethodName(BindingRequest request, String bindingName) {
        String baseMethodName = "get" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, bindingName) + (request.isRequestKind(RequestKind.INSTANCE) ? "" : CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, request.kindName()));
        return this.getUniqueMethodName(baseMethodName);
    }

    String getParameterName(ComponentRequirement requirement, String baseName) {
        return this.componentRequirementParameterNames.computeIfAbsent(requirement, r -> this.getUniqueFieldName(baseName));
    }

    void claimMethodName(CharSequence name) {
        this.componentMethodNames.claim(name);
    }

    ImmutableList<CodeBlock> getInitializations() {
        return ImmutableList.copyOf(this.initializations);
    }

    ImmutableList<CodeBlock> getComponentRequirementInitializations() {
        return ImmutableList.copyOf(this.componentRequirementInitializations);
    }

    ImmutableList<Key> getCancellableProducerKeys() {
        return ImmutableList.copyOf(this.cancellableProducerKeys);
    }

    TypeSpec.Builder generate() {
        this.fieldSpecsMap.asMap().values().forEach(arg_0 -> ((TypeSpec.Builder)this.component).addFields(arg_0));
        this.methodSpecsMap.asMap().values().forEach(arg_0 -> ((TypeSpec.Builder)this.component).addMethods(arg_0));
        this.typeSpecsMap.asMap().values().forEach(arg_0 -> ((TypeSpec.Builder)this.component).addTypes(arg_0));
        this.switchingProviderSupplier.stream().map(Supplier::get).forEach(arg_0 -> ((TypeSpec.Builder)this.component).addType(arg_0));
        return this.component;
    }

    static enum TypeSpecKind {
        PRESENT_FACTORY,
        COMPONENT_CREATOR,
        COMPONENT_PROVISION_FACTORY,
        SUBCOMPONENT;

    }

    static enum MethodSpecKind {
        CONSTRUCTOR,
        BUILDER_METHOD,
        PRIVATE_METHOD,
        INITIALIZE_METHOD,
        COMPONENT_METHOD,
        MEMBERS_INJECTION_METHOD,
        ABSENT_OPTIONAL_METHOD,
        CANCELLATION_LISTENER_METHOD;

    }

    static enum FieldSpecKind {
        COMPONENT_REQUIREMENT_FIELD,
        PRIVATE_METHOD_SCOPED_FIELD,
        FRAMEWORK_FIELD,
        ABSENT_OPTIONAL_FIELD;

    }
}

