/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.ClearableCache;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentGenerator;
import dagger.internal.codegen.ComponentImplementation;
import dagger.internal.codegen.CurrentImplementationSubcomponent;
import dagger.internal.codegen.KeyFactory;
import dagger.internal.codegen.SubcomponentNames;
import dagger.internal.codegen.TopLevelImplementationComponent;
import dagger.internal.codegen.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.lang.model.element.TypeElement;

@Singleton
final class ComponentImplementationFactory
implements ClearableCache {
    private final Map<TypeElement, ComponentImplementation> topLevelComponentCache = new HashMap<TypeElement, ComponentImplementation>();
    private final KeyFactory keyFactory;
    private final CompilerOptions compilerOptions;
    private final TopLevelImplementationComponent.Builder topLevelImplementationComponentBuilder;

    @Inject
    ComponentImplementationFactory(KeyFactory keyFactory, CompilerOptions compilerOptions, TopLevelImplementationComponent.Builder topLevelImplementationComponentBuilder) {
        this.keyFactory = keyFactory;
        this.compilerOptions = compilerOptions;
        this.topLevelImplementationComponentBuilder = topLevelImplementationComponentBuilder;
    }

    ComponentImplementation createComponentImplementation(BindingGraph bindingGraph) {
        return Util.reentrantComputeIfAbsent(this.topLevelComponentCache, bindingGraph.componentTypeElement(), component -> this.createComponentImplementationUncached(bindingGraph));
    }

    private ComponentImplementation createComponentImplementationUncached(BindingGraph bindingGraph) {
        ComponentImplementation componentImplementation = ComponentImplementation.topLevelComponentImplementation(bindingGraph, ComponentGenerator.componentName(bindingGraph.componentTypeElement()), new SubcomponentNames(bindingGraph, this.keyFactory), this.compilerOptions);
        CurrentImplementationSubcomponent currentImplementationSubcomponent = this.topLevelImplementationComponentBuilder.topLevelComponent(componentImplementation).build().currentImplementationSubcomponentBuilder().componentImplementation(componentImplementation).bindingGraph(bindingGraph).parentBuilder(Optional.empty()).parentBindingExpressions(Optional.empty()).parentRequirementExpressions(Optional.empty()).build();
        return currentImplementationSubcomponent.rootComponentBuilder().build();
    }

    @Override
    public void clearCache() {
        this.topLevelComponentCache.clear();
    }
}

