/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentImplementation;
import dagger.internal.codegen.ComponentProvisionBindingExpression;
import dagger.internal.codegen.ComponentRequirement;
import dagger.internal.codegen.ComponentRequirementExpressions;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.FrameworkFieldInitializer;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.shaded.auto.common.MoreTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

final class DependencyMethodProviderCreationExpression
implements FrameworkFieldInitializer.FrameworkInstanceCreationExpression {
    private final ComponentImplementation componentImplementation;
    private final ComponentRequirementExpressions componentRequirementExpressions;
    private final CompilerOptions compilerOptions;
    private final BindingGraph graph;
    private final ContributionBinding binding;

    DependencyMethodProviderCreationExpression(ContributionBinding binding, ComponentImplementation componentImplementation, ComponentRequirementExpressions componentRequirementExpressions, CompilerOptions compilerOptions, BindingGraph graph) {
        this.binding = (ContributionBinding)Preconditions.checkNotNull((Object)binding);
        this.componentImplementation = (ComponentImplementation)Preconditions.checkNotNull((Object)componentImplementation);
        this.componentRequirementExpressions = (ComponentRequirementExpressions)Preconditions.checkNotNull((Object)componentRequirementExpressions);
        this.compilerOptions = (CompilerOptions)Preconditions.checkNotNull((Object)compilerOptions);
        this.graph = (BindingGraph)Preconditions.checkNotNull((Object)graph);
    }

    @Override
    public CodeBlock creationExpression() {
        CodeBlock invocation = ComponentProvisionBindingExpression.maybeCheckForNull((ProvisionBinding)this.binding, this.compilerOptions, CodeBlock.of((String)"$N.$N()", (Object[])new Object[]{this.dependency().variableName(), this.provisionMethod().getSimpleName()}));
        ClassName dependencyClassName = ClassName.get((TypeElement)this.dependency().typeElement());
        TypeName keyType = TypeName.get((TypeMirror)this.binding.key().type());
        MethodSpec.Builder getMethod = MethodSpec.methodBuilder((String)"get").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(keyType).addStatement("return $L", new Object[]{invocation});
        if (this.binding.nullableType().isPresent()) {
            getMethod.addAnnotation(ClassName.get((TypeElement)MoreTypes.asTypeElement(this.binding.nullableType().get())));
        }
        this.componentImplementation.addType(ComponentImplementation.TypeSpecKind.COMPONENT_PROVISION_FACTORY, TypeSpec.classBuilder((ClassName)this.factoryClassName()).addSuperinterface((TypeName)TypeNames.providerOf(keyType)).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addField((TypeName)dependencyClassName, this.dependency().variableName(), new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addParameter((TypeName)dependencyClassName, this.dependency().variableName(), new Modifier[0]).addStatement("this.$1L = $1L", new Object[]{this.dependency().variableName()}).build()).addMethod(getMethod.build()).build());
        return CodeBlock.of((String)"new $T($L)", (Object[])new Object[]{this.factoryClassName(), this.componentRequirementExpressions.getExpressionDuringInitialization(this.dependency(), this.componentImplementation.name())});
    }

    private ClassName factoryClassName() {
        String factoryName = ClassName.get((TypeElement)this.dependency().typeElement()).toString().replace('.', '_') + "_" + this.binding.bindingElement().get().getSimpleName();
        return this.componentImplementation.name().nestedClass(factoryName);
    }

    private ComponentRequirement dependency() {
        return this.graph.componentDescriptor().getDependencyThatDefinesMethod(this.provisionMethod());
    }

    private Element provisionMethod() {
        return this.binding.bindingElement().get();
    }
}

