/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.BindingExpression;
import dagger.internal.codegen.BindingRequest;
import dagger.internal.codegen.ComponentBindingExpressions;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentImplementation;
import dagger.internal.codegen.FrameworkType;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.model.Key;
import dagger.model.RequestKind;

final class DerivedFromFrameworkInstanceBindingExpression
extends BindingExpression {
    private final BindingRequest frameworkRequest;
    private final RequestKind requestKind;
    private final FrameworkType frameworkType;
    private final ComponentBindingExpressions componentBindingExpressions;
    private final DaggerTypes types;

    DerivedFromFrameworkInstanceBindingExpression(Key key, FrameworkType frameworkType, RequestKind requestKind, ComponentBindingExpressions componentBindingExpressions, DaggerTypes types) {
        this.frameworkRequest = BindingRequest.bindingRequest(key, frameworkType);
        this.requestKind = (RequestKind)Preconditions.checkNotNull((Object)requestKind);
        this.frameworkType = (FrameworkType)((Object)Preconditions.checkNotNull((Object)((Object)frameworkType)));
        this.componentBindingExpressions = (ComponentBindingExpressions)Preconditions.checkNotNull((Object)componentBindingExpressions);
        this.types = (DaggerTypes)Preconditions.checkNotNull((Object)types);
    }

    @Override
    Expression getDependencyExpression(ClassName requestingClass) {
        return this.frameworkType.to(this.requestKind, this.componentBindingExpressions.getDependencyExpression(this.frameworkRequest, requestingClass), this.types);
    }

    @Override
    Expression getDependencyExpressionForComponentMethod(ComponentDescriptor.ComponentMethodDescriptor componentMethod, ComponentImplementation component) {
        Expression frameworkInstance = this.componentBindingExpressions.getDependencyExpressionForComponentMethod(this.frameworkRequest, componentMethod, component);
        return this.frameworkType.to(this.requestKind, frameworkInstance, this.types);
    }
}

