/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import dagger.internal.MapBuilder;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingRequest;
import dagger.internal.codegen.ComponentBindingExpressions;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.MapKeys;
import dagger.internal.codegen.MapType;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.ResolvedBindings;
import dagger.internal.codegen.SimpleInvocationBindingExpression;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.model.BindingKind;
import dagger.model.DependencyRequest;
import java.util.Collections;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

final class MapBindingExpression
extends SimpleInvocationBindingExpression {
    private static final int MAX_IMMUTABLE_MAP_OF_KEY_VALUE_PAIRS = 5;
    private final ProvisionBinding binding;
    private final ImmutableMap<DependencyRequest, ContributionBinding> dependencies;
    private final ComponentBindingExpressions componentBindingExpressions;
    private final DaggerTypes types;
    private final DaggerElements elements;

    MapBindingExpression(ProvisionBinding binding, BindingGraph graph, ComponentBindingExpressions componentBindingExpressions, DaggerTypes types, DaggerElements elements) {
        super(binding);
        this.binding = binding;
        BindingKind bindingKind = this.binding.kind();
        Preconditions.checkArgument((boolean)bindingKind.equals((Object)BindingKind.MULTIBOUND_MAP), (Object)bindingKind);
        this.componentBindingExpressions = componentBindingExpressions;
        this.types = types;
        this.elements = elements;
        this.dependencies = Maps.toMap(binding.dependencies(), dep -> ((ResolvedBindings)graph.contributionBindings().get((Object)dep.key())).contributionBinding());
    }

    @Override
    Expression getDependencyExpression(ClassName requestingClass) {
        boolean isImmutableMapAvailable = this.isImmutableMapAvailable();
        if (isImmutableMapAvailable && this.dependencies.size() <= 5) {
            return Expression.create(this.immutableMapType(), CodeBlock.builder().add("$T.", new Object[]{ImmutableMap.class}).add(this.maybeTypeParameters(requestingClass)).add("of($L)", new Object[]{this.dependencies.keySet().stream().map(dependency -> this.keyAndValueExpression((DependencyRequest)dependency, requestingClass)).collect(CodeBlocks.toParametersCodeBlock())}).build());
        }
        switch (this.dependencies.size()) {
            case 0: {
                return this.collectionsStaticFactoryInvocation(requestingClass, CodeBlock.of((String)"emptyMap()", (Object[])new Object[0]));
            }
            case 1: {
                return this.collectionsStaticFactoryInvocation(requestingClass, CodeBlock.of((String)"singletonMap($L)", (Object[])new Object[]{this.keyAndValueExpression((DependencyRequest)Iterables.getOnlyElement((Iterable)this.dependencies.keySet()), requestingClass)}));
            }
        }
        CodeBlock.Builder instantiation = CodeBlock.builder();
        instantiation.add("$T.", new Object[]{isImmutableMapAvailable ? ImmutableMap.class : MapBuilder.class}).add(this.maybeTypeParameters(requestingClass));
        if (this.isImmutableMapBuilderWithExpectedSizeAvailable()) {
            instantiation.add("builderWithExpectedSize($L)", new Object[]{this.dependencies.size()});
        } else if (isImmutableMapAvailable) {
            instantiation.add("builder()", new Object[0]);
        } else {
            instantiation.add("newMapBuilder($L)", new Object[]{this.dependencies.size()});
        }
        for (DependencyRequest dependency2 : this.dependencies.keySet()) {
            instantiation.add(".put($L)", new Object[]{this.keyAndValueExpression(dependency2, requestingClass)});
        }
        return Expression.create(isImmutableMapAvailable ? this.immutableMapType() : this.binding.key().type(), instantiation.add(".build()", new Object[0]).build());
    }

    private DeclaredType immutableMapType() {
        MapType mapType = MapType.from(this.binding.key());
        return this.types.getDeclaredType(this.elements.getTypeElement(ImmutableMap.class), mapType.keyType(), mapType.valueType());
    }

    private CodeBlock keyAndValueExpression(DependencyRequest dependency, ClassName requestingClass) {
        return CodeBlock.of((String)"$L, $L", (Object[])new Object[]{MapKeys.getMapKeyExpression((ContributionBinding)this.dependencies.get((Object)dependency), requestingClass, this.elements), this.componentBindingExpressions.getDependencyExpression(BindingRequest.bindingRequest(dependency), requestingClass).codeBlock()});
    }

    private Expression collectionsStaticFactoryInvocation(ClassName requestingClass, CodeBlock methodInvocation) {
        return Expression.create(this.binding.key().type(), CodeBlock.builder().add("$T.", new Object[]{Collections.class}).add(this.maybeTypeParameters(requestingClass)).add(methodInvocation).build());
    }

    private CodeBlock maybeTypeParameters(ClassName requestingClass) {
        TypeMirror bindingKeyType = this.binding.key().type();
        MapType mapType = MapType.from(this.binding.key());
        return Accessibility.isTypeAccessibleFrom(bindingKeyType, requestingClass.packageName()) ? CodeBlock.of((String)"<$T, $T>", (Object[])new Object[]{mapType.keyType(), mapType.valueType()}) : CodeBlock.of((String)"", (Object[])new Object[0]);
    }

    private boolean isImmutableMapBuilderWithExpectedSizeAvailable() {
        if (this.isImmutableMapAvailable()) {
            return ElementFilter.methodsIn(this.elements.getTypeElement(ImmutableMap.class).getEnclosedElements()).stream().anyMatch(method -> method.getSimpleName().contentEquals("builderWithExpectedSize"));
        }
        return false;
    }

    private boolean isImmutableMapAvailable() {
        return this.elements.getTypeElement(ImmutableMap.class) != null;
    }
}

