/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import dagger.MapKey;
import dagger.internal.codegen.ValidationReport;
import dagger.internal.codegen.langmodel.DaggerElements;
import java.util.List;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementFilter;

final class MapKeyValidator {
    private final DaggerElements elements;

    @Inject
    MapKeyValidator(DaggerElements elements) {
        this.elements = elements;
    }

    ValidationReport<Element> validate(Element element) {
        ValidationReport.Builder<Element> builder = ValidationReport.about(element);
        List<ExecutableElement> members = ElementFilter.methodsIn(((TypeElement)element).getEnclosedElements());
        if (members.isEmpty()) {
            builder.addError("Map key annotations must have members", element);
        } else if (element.getAnnotation(MapKey.class).unwrapValue()) {
            if (members.size() > 1) {
                builder.addError("Map key annotations with unwrapped values must have exactly one member", element);
            } else if (members.get(0).getReturnType().getKind() == TypeKind.ARRAY) {
                builder.addError("Map key annotations with unwrapped values cannot use arrays", element);
            }
        } else if (this.autoAnnotationIsMissing()) {
            builder.addError("@AutoAnnotation is a necessary dependency if @MapKey(unwrapValue = false). Add a dependency on com.google.auto.value:auto-value:<current version>");
        }
        return builder.build();
    }

    private boolean autoAnnotationIsMissing() {
        return this.elements.getTypeElement("com.google.auto.value.AutoAnnotation") == null;
    }
}

