/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeVariableName;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.SetType;
import dagger.internal.codegen.SourceFiles;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.shaded.auto.common.MoreTypes;
import java.util.List;
import java.util.Optional;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

abstract class MemberSelect {
    private final ClassName owningClass;
    private final boolean staticMember;

    static MemberSelect localField(ClassName owningClass, String fieldName) {
        return new LocalField(owningClass, fieldName);
    }

    static MemberSelect localMethod(ClassName owningClass, String methodName) {
        return new LocalMethod(owningClass, methodName);
    }

    static Optional<MemberSelect> staticFactoryCreation(ContributionBinding contributionBinding) {
        if (contributionBinding.factoryCreationStrategy().equals((Object)ContributionBinding.FactoryCreationStrategy.SINGLETON_INSTANCE) && !contributionBinding.scope().isPresent()) {
            switch (contributionBinding.kind()) {
                case MULTIBOUND_MAP: {
                    return Optional.of(MemberSelect.emptyMapFactory(contributionBinding));
                }
                case MULTIBOUND_SET: {
                    return Optional.of(MemberSelect.emptySetFactory(contributionBinding));
                }
                case INJECTION: 
                case PROVISION: {
                    ImmutableList<TypeVariableName> typeVariables;
                    TypeMirror keyType = contributionBinding.key().type();
                    if (!keyType.getKind().equals((Object)TypeKind.DECLARED) || (typeVariables = SourceFiles.bindingTypeElementTypeVariableNames(contributionBinding)).isEmpty()) break;
                    List<? extends TypeMirror> typeArguments = ((DeclaredType)keyType).getTypeArguments();
                    return Optional.of(MemberSelect.parameterizedFactoryCreateMethod(SourceFiles.generatedClassNameForBinding(contributionBinding), typeArguments));
                }
            }
            return Optional.of(new StaticMethod(SourceFiles.generatedClassNameForBinding(contributionBinding), CodeBlock.of((String)"create()", (Object[])new Object[0])));
        }
        return Optional.empty();
    }

    private static MemberSelect parameterizedFactoryCreateMethod(ClassName owningClass, List<? extends TypeMirror> parameters) {
        return new ParameterizedStaticMethod(owningClass, (ImmutableList<TypeMirror>)ImmutableList.copyOf(parameters), CodeBlock.of((String)"create()", (Object[])new Object[0]), TypeNames.FACTORY);
    }

    private static MemberSelect emptyMapFactory(ContributionBinding contributionBinding) {
        BindingType bindingType = contributionBinding.bindingType();
        ImmutableList typeParameters = ImmutableList.copyOf(MoreTypes.asDeclared(contributionBinding.key().type()).getTypeArguments());
        if (bindingType.equals((Object)BindingType.PRODUCTION)) {
            return new ParameterizedStaticMethod(TypeNames.PRODUCERS, (ImmutableList<TypeMirror>)typeParameters, CodeBlock.of((String)"emptyMapProducer()", (Object[])new Object[0]), TypeNames.PRODUCER);
        }
        return new ParameterizedStaticMethod(TypeNames.MAP_FACTORY, (ImmutableList<TypeMirror>)typeParameters, CodeBlock.of((String)"emptyMapProvider()", (Object[])new Object[0]), TypeNames.PROVIDER);
    }

    private static MemberSelect emptySetFactory(ContributionBinding binding) {
        return new ParameterizedStaticMethod(SourceFiles.setFactoryClassName(binding), (ImmutableList<TypeMirror>)ImmutableList.of((Object)SetType.from(binding.key()).elementType()), CodeBlock.of((String)"empty()", (Object[])new Object[0]), TypeNames.FACTORY);
    }

    MemberSelect(ClassName owningClass, boolean staticMemeber) {
        this.owningClass = owningClass;
        this.staticMember = staticMemeber;
    }

    ClassName owningClass() {
        return this.owningClass;
    }

    boolean staticMember() {
        return this.staticMember;
    }

    abstract CodeBlock getExpressionFor(ClassName var1);

    private static final class ParameterizedStaticMethod
    extends MemberSelect {
        final ImmutableList<TypeMirror> typeParameters;
        final CodeBlock methodCodeBlock;
        final ClassName rawReturnType;

        ParameterizedStaticMethod(ClassName owningClass, ImmutableList<TypeMirror> typeParameters, CodeBlock methodCodeBlock, ClassName rawReturnType) {
            super(owningClass, true);
            this.typeParameters = typeParameters;
            this.methodCodeBlock = methodCodeBlock;
            this.rawReturnType = rawReturnType;
        }

        @Override
        CodeBlock getExpressionFor(ClassName usingClass) {
            boolean accessible = true;
            for (TypeMirror typeParameter : this.typeParameters) {
                accessible &= Accessibility.isTypeAccessibleFrom(typeParameter, usingClass.packageName());
            }
            if (accessible) {
                return CodeBlock.of((String)"$T.<$L>$L", (Object[])new Object[]{this.owningClass(), this.typeParameters.stream().map(CodeBlocks::type).collect(CodeBlocks.toParametersCodeBlock()), this.methodCodeBlock});
            }
            return CodeBlock.of((String)"(($T) $T.$L)", (Object[])new Object[]{this.rawReturnType, this.owningClass(), this.methodCodeBlock});
        }
    }

    private static final class StaticMethod
    extends MemberSelect {
        final CodeBlock methodCodeBlock;

        StaticMethod(ClassName owningClass, CodeBlock methodCodeBlock) {
            super(owningClass, true);
            this.methodCodeBlock = (CodeBlock)Preconditions.checkNotNull((Object)methodCodeBlock);
        }

        @Override
        CodeBlock getExpressionFor(ClassName usingClass) {
            return this.owningClass().equals((Object)usingClass) ? this.methodCodeBlock : CodeBlock.of((String)"$T.$L", (Object[])new Object[]{this.owningClass(), this.methodCodeBlock});
        }
    }

    private static final class LocalMethod
    extends MemberSelect {
        final String methodName;

        LocalMethod(ClassName owningClass, String methodName) {
            super(owningClass, false);
            this.methodName = (String)Preconditions.checkNotNull((Object)methodName);
        }

        @Override
        CodeBlock getExpressionFor(ClassName usingClass) {
            return this.owningClass().equals((Object)usingClass) ? CodeBlock.of((String)"$N()", (Object[])new Object[]{this.methodName}) : CodeBlock.of((String)"$T.this.$N()", (Object[])new Object[]{this.owningClass(), this.methodName});
        }
    }

    private static final class LocalField
    extends MemberSelect {
        final String fieldName;

        LocalField(ClassName owningClass, String fieldName) {
            super(owningClass, false);
            this.fieldName = (String)Preconditions.checkNotNull((Object)fieldName);
        }

        @Override
        CodeBlock getExpressionFor(ClassName usingClass) {
            return this.owningClass().equals((Object)usingClass) ? CodeBlock.of((String)"$N", (Object[])new Object[]{this.fieldName}) : CodeBlock.of((String)"$T.this.$N", (Object[])new Object[]{this.owningClass(), this.fieldName});
        }
    }
}

