/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import dagger.internal.codegen.AutoValue_MembersInjectionBinding_InjectionSite;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingType;
import dagger.model.BindingKind;
import dagger.model.DependencyRequest;
import dagger.shaded.auto.common.MoreElements;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

@AutoValue
abstract class MembersInjectionBinding
extends Binding {
    MembersInjectionBinding() {
    }

    @Override
    public final Optional<Element> bindingElement() {
        return Optional.of(this.membersInjectedType());
    }

    abstract TypeElement membersInjectedType();

    abstract Optional<MembersInjectionBinding> unresolved();

    @Override
    public Optional<TypeElement> contributingModule() {
        return Optional.empty();
    }

    abstract ImmutableSortedSet<InjectionSite> injectionSites();

    @Override
    BindingType bindingType() {
        return BindingType.MEMBERS_INJECTION;
    }

    @Override
    public BindingKind kind() {
        return BindingKind.MEMBERS_INJECTION;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    boolean hasLocalInjectionSites() {
        return this.injectionSites().stream().anyMatch(injectionSite -> injectionSite.element().getEnclosingElement().equals(this.membersInjectedType()));
    }

    @Override
    boolean requiresModuleInstance() {
        return false;
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    @AutoValue
    static abstract class InjectionSite {
        InjectionSite() {
        }

        abstract Kind kind();

        abstract Element element();

        abstract ImmutableSet<DependencyRequest> dependencies();

        int indexAmongAtInjectMembersWithSameSimpleName() {
            return this.element().getEnclosingElement().getEnclosedElements().stream().filter(element -> MoreElements.isAnnotationPresent(element, Inject.class)).filter(element -> !element.getModifiers().contains((Object)Modifier.PRIVATE)).filter(element -> element.getSimpleName().equals(this.element().getSimpleName())).collect(Collectors.toList()).indexOf(this.element());
        }

        static InjectionSite field(VariableElement element, DependencyRequest dependency) {
            return new AutoValue_MembersInjectionBinding_InjectionSite(Kind.FIELD, element, (ImmutableSet<DependencyRequest>)ImmutableSet.of((Object)dependency));
        }

        static InjectionSite method(ExecutableElement element, Iterable<DependencyRequest> dependencies) {
            return new AutoValue_MembersInjectionBinding_InjectionSite(Kind.METHOD, element, (ImmutableSet<DependencyRequest>)ImmutableSet.copyOf(dependencies));
        }

        static enum Kind {
            FIELD,
            METHOD;

        }
    }
}

