/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import dagger.internal.codegen.BindingRequest;
import dagger.internal.codegen.ComponentBindingExpressions;
import dagger.internal.codegen.OptionalType;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.SimpleInvocationBindingExpression;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.model.DependencyRequest;
import javax.inject.Inject;
import javax.lang.model.SourceVersion;

final class OptionalBindingExpression
extends SimpleInvocationBindingExpression {
    private final ProvisionBinding binding;
    private final ComponentBindingExpressions componentBindingExpressions;
    private final DaggerTypes types;
    private final SourceVersion sourceVersion;

    @Inject
    OptionalBindingExpression(ProvisionBinding binding, ComponentBindingExpressions componentBindingExpressions, DaggerTypes types, SourceVersion sourceVersion) {
        super(binding);
        this.binding = binding;
        this.componentBindingExpressions = componentBindingExpressions;
        this.types = types;
        this.sourceVersion = sourceVersion;
    }

    @Override
    Expression getDependencyExpression(ClassName requestingClass) {
        OptionalType optionalType = OptionalType.from(this.binding.key());
        OptionalType.OptionalKind optionalKind = optionalType.kind();
        if (this.binding.dependencies().isEmpty()) {
            if (this.sourceVersion.compareTo(SourceVersion.RELEASE_7) <= 0 && Accessibility.isTypeAccessibleFrom(this.binding.key().type(), requestingClass.packageName())) {
                return Expression.create(this.binding.key().type(), optionalKind.parameterizedAbsentValueExpression(optionalType));
            }
            return Expression.create(this.binding.key().type(), optionalKind.absentValueExpression());
        }
        DependencyRequest dependency = (DependencyRequest)Iterables.getOnlyElement(this.binding.dependencies());
        CodeBlock dependencyExpression = this.componentBindingExpressions.getDependencyExpression(BindingRequest.bindingRequest(dependency), requestingClass).codeBlock();
        return Accessibility.isTypeAccessibleFrom(dependency.key().type(), requestingClass.packageName()) ? Expression.create(this.binding.key().type(), optionalKind.presentExpression(dependencyExpression)) : Expression.create(this.types.erasure(this.binding.key().type()), optionalKind.presentObjectExpression(dependencyExpression));
    }

    @Override
    boolean requiresMethodEncapsulation() {
        return false;
    }
}

