/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.googlejavaformat.java.filer.FormattingFiler;
import dagger.Module;
import dagger.Provides;
import dagger.Reusable;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.DaggerStatisticsRecorder;
import dagger.internal.codegen.ProcessingEnvironmentCompilerOptions;
import dagger.internal.codegen.ProcessingOptions;
import dagger.internal.codegen.langmodel.DaggerElements;
import java.util.Map;
import java.util.Optional;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.util.Types;

@Module
final class ProcessingEnvironmentModule {
    private final ProcessingEnvironment processingEnvironment;

    ProcessingEnvironmentModule(ProcessingEnvironment processingEnvironment) {
        this.processingEnvironment = (ProcessingEnvironment)Preconditions.checkNotNull((Object)processingEnvironment);
    }

    @Provides
    @ProcessingOptions
    Map<String, String> processingOptions() {
        return this.processingEnvironment.getOptions();
    }

    @Provides
    Messager messager() {
        return this.processingEnvironment.getMessager();
    }

    @Provides
    Filer filer(CompilerOptions compilerOptions) {
        if (compilerOptions.headerCompilation() || !compilerOptions.formatGeneratedSource()) {
            return this.processingEnvironment.getFiler();
        }
        return new FormattingFiler(this.processingEnvironment.getFiler());
    }

    @Provides
    Types types() {
        return this.processingEnvironment.getTypeUtils();
    }

    @Provides
    SourceVersion sourceVersion() {
        return this.processingEnvironment.getSourceVersion();
    }

    @Provides
    DaggerElements daggerElements() {
        return new DaggerElements(this.processingEnvironment);
    }

    @Provides
    @Reusable
    CompilerOptions compilerOptions() {
        return ProcessingEnvironmentCompilerOptions.create(this.processingEnvironment);
    }

    @Provides
    Optional<DaggerStatisticsRecorder> daggerStatisticsRecorder() {
        return Optional.empty();
    }
}

