/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import dagger.internal.codegen.base.ContributionType;
import dagger.internal.codegen.base.MapType;
import dagger.internal.codegen.base.MoreAnnotationMirrors;
import dagger.internal.codegen.base.SetType;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingDeclaration;
import dagger.model.BindingKind;
import dagger.model.DependencyRequest;
import dagger.model.Key;
import dagger.shaded.auto.common.MoreElements;
import java.util.Arrays;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public abstract class ContributionBinding
extends Binding
implements ContributionType.HasContributionType {
    public abstract Optional<DeclaredType> nullableType();

    public abstract Optional<Equivalence.Wrapper<AnnotationMirror>> wrappedMapKeyAnnotation();

    public final Optional<AnnotationMirror> mapKeyAnnotation() {
        return MoreAnnotationMirrors.unwrapOptionalEquivalence(this.wrappedMapKeyAnnotation());
    }

    public final Optional<TypeMirror> contributedPrimitiveType() {
        return this.bindingElement().filter(bindingElement -> bindingElement instanceof ExecutableElement).map(bindingElement -> MoreElements.asExecutable(bindingElement).getReturnType()).filter(type -> type.getKind().isPrimitive());
    }

    @Override
    public boolean requiresModuleInstance() {
        return this.isModuleKotlinObject().orElse(false) == false && super.requiresModuleInstance();
    }

    @Override
    public final boolean isNullable() {
        return this.nullableType().isPresent();
    }

    abstract Optional<Boolean> isModuleKotlinObject();

    public final FactoryCreationStrategy factoryCreationStrategy() {
        switch (this.kind()) {
            case DELEGATE: {
                return FactoryCreationStrategy.DELEGATE;
            }
            case PROVISION: {
                return this.dependencies().isEmpty() && !this.requiresModuleInstance() ? FactoryCreationStrategy.SINGLETON_INSTANCE : FactoryCreationStrategy.CLASS_CONSTRUCTOR;
            }
            case INJECTION: 
            case MULTIBOUND_SET: 
            case MULTIBOUND_MAP: {
                return this.dependencies().isEmpty() ? FactoryCreationStrategy.SINGLETON_INSTANCE : FactoryCreationStrategy.CLASS_CONSTRUCTOR;
            }
        }
        return FactoryCreationStrategy.CLASS_CONSTRUCTOR;
    }

    public final TypeMirror contributedType() {
        switch (this.contributionType()) {
            case MAP: {
                return MapType.from(this.key()).unwrappedFrameworkValueType();
            }
            case SET: {
                return SetType.from(this.key()).elementType();
            }
            case SET_VALUES: 
            case UNIQUE: {
                return this.key().type();
            }
        }
        throw new AssertionError();
    }

    static BindingKind bindingKindForMultibindingKey(Key key) {
        if (SetType.isSet(key)) {
            return BindingKind.MULTIBOUND_SET;
        }
        if (MapType.isMap(key)) {
            return BindingKind.MULTIBOUND_MAP;
        }
        throw new IllegalArgumentException(String.format("key is not for a set or map: %s", key));
    }

    @CanIgnoreReturnValue
    public static abstract class Builder<C extends ContributionBinding, B extends Builder<C, B>> {
        public abstract B dependencies(Iterable<DependencyRequest> var1);

        public B dependencies(DependencyRequest ... dependencies) {
            return this.dependencies(Arrays.asList(dependencies));
        }

        public abstract B unresolved(C var1);

        public abstract B contributionType(ContributionType var1);

        public abstract B bindingElement(Element var1);

        abstract B contributingModule(TypeElement var1);

        abstract B isModuleKotlinObject(boolean var1);

        public abstract B key(Key var1);

        public abstract B nullableType(Optional<DeclaredType> var1);

        abstract B wrappedMapKeyAnnotation(Optional<Equivalence.Wrapper<AnnotationMirror>> var1);

        public abstract B kind(BindingKind var1);

        @CheckReturnValue
        abstract C autoBuild();

        @CheckReturnValue
        public C build() {
            C binding = this.autoBuild();
            Preconditions.checkState((((BindingDeclaration)binding).contributingModule().isPresent() == ((ContributionBinding)binding).isModuleKotlinObject().isPresent() ? 1 : 0) != 0, (Object)"The contributionModule and isModuleKotlinObject must both be set together.");
            return binding;
        }
    }

    public static enum FactoryCreationStrategy {
        SINGLETON_INSTANCE,
        CLASS_CONSTRUCTOR,
        DELEGATE;

    }
}

