/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.bindinggraphvalidation;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import dagger.internal.codegen.base.RequestKinds;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.model.Binding;
import dagger.model.BindingGraph;
import dagger.spi.BindingGraphPlugin;
import dagger.spi.DiagnosticReporter;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.tools.Diagnostic;

final class ProvisionDependencyOnProducerBindingValidator
implements BindingGraphPlugin {
    @Inject
    ProvisionDependencyOnProducerBindingValidator() {
    }

    public String pluginName() {
        return "Dagger/ProviderDependsOnProducer";
    }

    public void visitGraph(BindingGraph bindingGraph, DiagnosticReporter diagnosticReporter) {
        this.provisionDependenciesOnProductionBindings(bindingGraph).forEach(provisionDependent -> diagnosticReporter.reportDependency(Diagnostic.Kind.ERROR, provisionDependent, provisionDependent.isEntryPoint() ? this.entryPointErrorMessage((BindingGraph.DependencyEdge)provisionDependent) : this.dependencyErrorMessage((BindingGraph.DependencyEdge)provisionDependent, bindingGraph)));
    }

    private Stream<BindingGraph.DependencyEdge> provisionDependenciesOnProductionBindings(BindingGraph bindingGraph) {
        return bindingGraph.bindings().stream().filter(binding -> binding.isProduction()).flatMap(binding -> this.incomingDependencies((Binding)binding, bindingGraph)).filter(edge -> !this.dependencyCanUseProduction((BindingGraph.DependencyEdge)edge, bindingGraph));
    }

    private Stream<BindingGraph.DependencyEdge> incomingDependencies(Binding binding, BindingGraph bindingGraph) {
        return bindingGraph.network().inEdges((Object)binding).stream().flatMap(DaggerStreams.instancesOf(BindingGraph.DependencyEdge.class));
    }

    private boolean dependencyCanUseProduction(BindingGraph.DependencyEdge edge, BindingGraph bindingGraph) {
        return edge.isEntryPoint() ? RequestKinds.canBeSatisfiedByProductionBinding(edge.dependencyRequest().kind()) : this.bindingRequestingDependency(edge, bindingGraph).isProduction();
    }

    private Binding bindingRequestingDependency(BindingGraph.DependencyEdge dependency, BindingGraph bindingGraph) {
        Preconditions.checkArgument((!dependency.isEntryPoint() ? 1 : 0) != 0);
        BindingGraph.Node source = (BindingGraph.Node)bindingGraph.network().incidentNodes((Object)dependency).source();
        Verify.verify((boolean)(source instanceof Binding), (String)"expected source of %s to be a binding, but was: %s", (Object)dependency, (Object)source);
        return (Binding)source;
    }

    private String entryPointErrorMessage(BindingGraph.DependencyEdge entryPoint) {
        return String.format("%s is a provision entry-point, which cannot depend on a production.", entryPoint.dependencyRequest().key());
    }

    private String dependencyErrorMessage(BindingGraph.DependencyEdge dependencyOnProduction, BindingGraph bindingGraph) {
        return String.format("%s is a provision, which cannot depend on a production.", this.bindingRequestingDependency(dependencyOnProduction, bindingGraph).key());
    }
}

