/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.kotlin;

import com.google.common.base.Preconditions;
import dagger.internal.codegen.base.ClearableCache;
import dagger.internal.codegen.base.MoreAnnotationValues;
import dagger.internal.codegen.kotlin.KotlinMetadata;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreElements;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import kotlin.Metadata;
import kotlinx.metadata.KmClass;
import kotlinx.metadata.jvm.KotlinClassHeader;
import kotlinx.metadata.jvm.KotlinClassMetadata;

@Singleton
public final class KotlinMetadataFactory
implements ClearableCache {
    private final Map<TypeElement, Optional<KotlinMetadata>> metadataCache = new HashMap<TypeElement, Optional<KotlinMetadata>>();

    @Inject
    KotlinMetadataFactory() {
    }

    public Optional<KotlinMetadata> create(Element element) {
        TypeElement enclosingElement = DaggerElements.closestEnclosingTypeElement(element);
        if (!MoreElements.isAnnotationPresent(enclosingElement, Metadata.class)) {
            return Optional.empty();
        }
        return this.metadataCache.computeIfAbsent(enclosingElement, typeElement -> KotlinMetadataFactory.kmClassOf(typeElement).map(classMetadata -> new KotlinMetadata((TypeElement)typeElement, (KmClass)classMetadata)));
    }

    private static Optional<KmClass> kmClassOf(TypeElement typeElement) {
        Optional<AnnotationMirror> metadataAnnotation = DaggerElements.getAnnotationMirror(typeElement, Metadata.class);
        Preconditions.checkState((boolean)metadataAnnotation.isPresent());
        KotlinClassHeader header = new KotlinClassHeader(Integer.valueOf(KotlinMetadataFactory.getIntValue(metadataAnnotation.get(), "k")), KotlinMetadataFactory.getIntArrayValue(metadataAnnotation.get(), "mv"), KotlinMetadataFactory.getIntArrayValue(metadataAnnotation.get(), "bv"), KotlinMetadataFactory.getStringArrayValue(metadataAnnotation.get(), "d1"), KotlinMetadataFactory.getStringArrayValue(metadataAnnotation.get(), "d2"), KotlinMetadataFactory.getStringValue(metadataAnnotation.get(), "xs"), KotlinMetadataFactory.getStringValue(metadataAnnotation.get(), "pn"), Integer.valueOf(KotlinMetadataFactory.getIntValue(metadataAnnotation.get(), "xi")));
        KotlinClassMetadata metadata = KotlinClassMetadata.read((KotlinClassHeader)header);
        if (metadata == null) {
            return Optional.empty();
        }
        if (metadata instanceof KotlinClassMetadata.Class) {
            return Optional.of(((KotlinClassMetadata.Class)metadata).toKmClass());
        }
        return Optional.empty();
    }

    private static int getIntValue(AnnotationMirror annotation, String valueName) {
        return (Integer)AnnotationMirrors.getAnnotationValue(annotation, valueName).getValue();
    }

    private static String getStringValue(AnnotationMirror annotation, String valueName) {
        return AnnotationMirrors.getAnnotationValue(annotation, valueName).getValue().toString();
    }

    private static int[] getIntArrayValue(AnnotationMirror annotation, String valueName) {
        return MoreAnnotationValues.asAnnotationValues(AnnotationMirrors.getAnnotationValue(annotation, valueName)).stream().mapToInt(it -> (Integer)it.getValue()).toArray();
    }

    private static String[] getStringArrayValue(AnnotationMirror annotation, String valueName) {
        return (String[])MoreAnnotationValues.asAnnotationValues(AnnotationMirrors.getAnnotationValue(annotation, valueName)).stream().map(it -> it.getValue().toString()).toArray(String[]::new);
    }

    @Override
    public void clearCache() {
        this.metadataCache.clear();
    }
}

