/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.writing.BindingExpression;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.MethodBindingExpression;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

final class PrivateMethodBindingExpression
extends MethodBindingExpression {
    private final BindingRequest request;
    private final ComponentImplementation componentImplementation;
    private String methodName;

    PrivateMethodBindingExpression(BindingRequest request, ContributionBinding binding, MethodBindingExpression.MethodImplementationStrategy methodImplementationStrategy, BindingExpression wrappedBindingExpression, ComponentImplementation componentImplementation, DaggerTypes types) {
        super(request, binding, methodImplementationStrategy, wrappedBindingExpression, componentImplementation, types);
        this.request = (BindingRequest)Preconditions.checkNotNull((Object)request);
        this.componentImplementation = (ComponentImplementation)Preconditions.checkNotNull((Object)componentImplementation);
    }

    @Override
    protected void addMethod() {
        if (this.methodName == null) {
            this.methodName = this.componentImplementation.getUniqueMethodName(this.request);
            this.componentImplementation.addMethod(ComponentImplementation.MethodSpecKind.PRIVATE_METHOD, MethodSpec.methodBuilder((String)this.methodName).addModifiers(new Modifier[]{Modifier.PRIVATE}).returns(TypeName.get((TypeMirror)this.returnType())).addCode(this.methodBody()).build());
        }
    }

    @Override
    protected String methodName() {
        Preconditions.checkState((this.methodName != null ? 1 : 0) != 0, (Object)"addMethod() must be called before methodName()");
        return this.methodName;
    }
}

