/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.kotlin;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.MoreCollectors;
import dagger.internal.codegen.base.MoreAnnotationValues;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.shaded.auto.common.MoreElements;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import kotlin.Metadata;
import kotlinx.metadata.Flag;
import kotlinx.metadata.KmClassVisitor;
import kotlinx.metadata.KmExtensionType;
import kotlinx.metadata.KmPropertyExtensionVisitor;
import kotlinx.metadata.KmPropertyVisitor;
import kotlinx.metadata.jvm.JvmFieldSignature;
import kotlinx.metadata.jvm.JvmMethodSignature;
import kotlinx.metadata.jvm.JvmPropertyExtensionVisitor;
import kotlinx.metadata.jvm.KotlinClassHeader;
import kotlinx.metadata.jvm.KotlinClassMetadata;

final class KotlinMetadata {
    private final TypeElement typeElement;
    private final int flags;
    private final Supplier<Map<VariableElement, Optional<MethodForAnnotations>>> elementFieldAnnotationMethodMap;

    private KotlinMetadata(TypeElement typeElement, int flags, List<Property> properties) {
        this.typeElement = typeElement;
        this.flags = flags;
        this.elementFieldAnnotationMethodMap = Suppliers.memoize(() -> {
            Map<String, Property> propertyDescriptors = properties.stream().filter(property -> property.getFieldSignature().isPresent()).collect(Collectors.toMap(property -> property.getFieldSignature().get(), Function.identity()));
            Map<String, ExecutableElement> methodDescriptors = ElementFilter.methodsIn(typeElement.getEnclosedElements()).stream().collect(Collectors.toMap(DaggerElements::getMethodDescriptor, Function.identity()));
            return this.mapFieldToAnnotationMethod(propertyDescriptors, methodDescriptors);
        });
    }

    private Map<VariableElement, Optional<MethodForAnnotations>> mapFieldToAnnotationMethod(Map<String, Property> propertyDescriptors, Map<String, ExecutableElement> methodDescriptors) {
        return ElementFilter.fieldsIn(this.typeElement.getEnclosedElements()).stream().filter(field -> MoreElements.isAnnotationPresent(field, Inject.class)).collect(Collectors.toMap(Function.identity(), field -> this.findProperty((VariableElement)field, propertyDescriptors).getMethodForAnnotationsSignature().map(signature -> Optional.ofNullable((ExecutableElement)methodDescriptors.get(signature)).map(MethodForAnnotations::new).orElse(MethodForAnnotations.MISSING))));
    }

    private Property findProperty(VariableElement field, Map<String, Property> propertyDescriptors) {
        String fieldDescriptor = DaggerElements.getFieldDescriptor(field);
        if (propertyDescriptors.containsKey(fieldDescriptor)) {
            return propertyDescriptors.get(fieldDescriptor);
        }
        return (Property)propertyDescriptors.values().stream().filter(property -> field.getSimpleName().contentEquals(((Property)property).name)).collect(MoreCollectors.onlyElement());
    }

    TypeElement getTypeElement() {
        return this.typeElement;
    }

    Optional<ExecutableElement> getSyntheticAnnotationMethod(VariableElement fieldElement) {
        Preconditions.checkArgument((boolean)((Map)this.elementFieldAnnotationMethodMap.get()).containsKey(fieldElement));
        return ((Optional)((Map)this.elementFieldAnnotationMethodMap.get()).get(fieldElement)).map(methodForAnnotations -> {
            if (methodForAnnotations == MethodForAnnotations.MISSING) {
                throw new IllegalStateException("Method for annotations is missing for " + fieldElement);
            }
            return methodForAnnotations.getMethod();
        });
    }

    boolean isMissingSyntheticAnnotationMethod(VariableElement fieldElement) {
        Preconditions.checkArgument((boolean)((Map)this.elementFieldAnnotationMethodMap.get()).containsKey(fieldElement));
        return ((Optional)((Map)this.elementFieldAnnotationMethodMap.get()).get(fieldElement)).map(methodForAnnotations -> methodForAnnotations == MethodForAnnotations.MISSING).orElse(false);
    }

    boolean isObjectClass() {
        return Flag.Class.IS_OBJECT.invoke(this.flags);
    }

    static KotlinMetadata from(TypeElement typeElement) {
        MetadataVisitor visitor = new MetadataVisitor();
        KotlinMetadata.metadataOf(typeElement).accept((KmClassVisitor)visitor);
        return new KotlinMetadata(typeElement, visitor.classFlags, visitor.classProperties);
    }

    private static KotlinClassMetadata.Class metadataOf(TypeElement typeElement) {
        Optional<AnnotationMirror> metadataAnnotation = DaggerElements.getAnnotationMirror(typeElement, Metadata.class);
        Preconditions.checkState((boolean)metadataAnnotation.isPresent());
        KotlinClassHeader header = new KotlinClassHeader(Integer.valueOf(MoreAnnotationValues.getIntValue(metadataAnnotation.get(), "k")), MoreAnnotationValues.getIntArrayValue(metadataAnnotation.get(), "mv"), MoreAnnotationValues.getIntArrayValue(metadataAnnotation.get(), "bv"), MoreAnnotationValues.getStringArrayValue(metadataAnnotation.get(), "d1"), MoreAnnotationValues.getStringArrayValue(metadataAnnotation.get(), "d2"), MoreAnnotationValues.getStringValue(metadataAnnotation.get(), "xs"), MoreAnnotationValues.getStringValue(metadataAnnotation.get(), "pn"), Integer.valueOf(MoreAnnotationValues.getIntValue(metadataAnnotation.get(), "xi")));
        KotlinClassMetadata metadata = KotlinClassMetadata.read((KotlinClassHeader)header);
        if (metadata == null) {
            throw new IllegalStateException("Unsupported metadata version. Check that your Kotlin version is >= 1.0");
        }
        if (metadata instanceof KotlinClassMetadata.Class) {
            return (KotlinClassMetadata.Class)metadata;
        }
        throw new IllegalStateException("Unsupported metadata type: " + metadata);
    }

    private static final class MethodForAnnotations {
        static final MethodForAnnotations MISSING = new MethodForAnnotations(null);
        private final ExecutableElement method;

        MethodForAnnotations(ExecutableElement method) {
            this.method = method;
        }

        public ExecutableElement getMethod() {
            return this.method;
        }
    }

    private static final class Property {
        private final String name;
        private final int flags;
        private final Optional<String> fieldSignature;
        private final Optional<String> methodForAnnotationsSignature;

        Property(String name, int flags, Optional<String> fieldSignature, Optional<String> methodForAnnotationsSignature) {
            this.name = name;
            this.flags = flags;
            this.fieldSignature = fieldSignature;
            this.methodForAnnotationsSignature = methodForAnnotationsSignature;
        }

        String getName() {
            return this.name;
        }

        int getFlags() {
            return this.flags;
        }

        Optional<String> getFieldSignature() {
            return this.fieldSignature;
        }

        Optional<String> getMethodForAnnotationsSignature() {
            return this.methodForAnnotationsSignature;
        }
    }

    private static final class MetadataVisitor
    extends KmClassVisitor {
        int classFlags;
        List<Property> classProperties = new ArrayList<Property>();

        private MetadataVisitor() {
        }

        public void visit(int flags, String s) {
            this.classFlags = flags;
        }

        public KmPropertyVisitor visitProperty(final int flags, final String name, int getterFlags, int setterFlags) {
            return new KmPropertyVisitor(){
                String fieldSignature;
                String methodForAnnotationsSignature;

                public KmPropertyExtensionVisitor visitExtensions(KmExtensionType kmExtensionType) {
                    if (!kmExtensionType.equals((Object)JvmPropertyExtensionVisitor.TYPE)) {
                        return null;
                    }
                    return new JvmPropertyExtensionVisitor(){

                        public void visit(int jvmFlags, JvmFieldSignature jvmFieldSignature, JvmMethodSignature getterSignature, JvmMethodSignature setterSignature) {
                            if (jvmFieldSignature != null) {
                                fieldSignature = jvmFieldSignature.asString();
                            }
                        }

                        public void visitSyntheticMethodForAnnotations(JvmMethodSignature methodSignature) {
                            if (methodSignature != null) {
                                methodForAnnotationsSignature = methodSignature.asString();
                            }
                        }
                    };
                }

                public void visitEnd() {
                    classProperties.add(new Property(name, flags, Optional.ofNullable(this.fieldSignature), Optional.ofNullable(this.methodForAnnotationsSignature)));
                }
            };
        }
    }
}

