/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.kotlin;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import dagger.internal.codegen.kotlin.KotlinMetadataFactory;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreElements;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import kotlin.Metadata;

public final class KotlinMetadataUtil {
    private final KotlinMetadataFactory metadataFactory;

    @Inject
    KotlinMetadataUtil(KotlinMetadataFactory metadataFactory) {
        this.metadataFactory = metadataFactory;
    }

    public boolean hasMetadata(Element element) {
        return MoreElements.isAnnotationPresent(DaggerElements.closestEnclosingTypeElement(element), Metadata.class);
    }

    public ImmutableCollection<? extends AnnotationMirror> getSyntheticPropertyAnnotations(VariableElement fieldElement, Class<? extends Annotation> annotationType) {
        return (ImmutableCollection)this.metadataFactory.create(fieldElement).getSyntheticAnnotationMethod(fieldElement).map(methodElement -> AnnotationMirrors.getAnnotatedAnnotations(methodElement, annotationType).asList()).orElse(ImmutableList.of());
    }

    public boolean isMissingSyntheticPropertyForAnnotations(VariableElement fieldElement) {
        return this.metadataFactory.create(fieldElement).isMissingSyntheticAnnotationMethod(fieldElement);
    }

    public boolean isObjectClass(TypeElement typeElement) {
        return this.hasMetadata(typeElement) && this.metadataFactory.create(typeElement).isObjectClass();
    }
}

