/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.binding.ModuleKind;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.langmodel.DaggerElements;
import java.util.Optional;
import javax.annotation.processing.Filer;
import javax.inject.Inject;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

public final class ModuleProxies {
    private final DaggerElements elements;

    @Inject
    public ModuleProxies(DaggerElements elements) {
        this.elements = elements;
    }

    private ClassName constructorProxyTypeName(TypeElement moduleElement) {
        ModuleKind.checkIsModule(moduleElement);
        ClassName moduleClassName = ClassName.get((TypeElement)moduleElement);
        return moduleClassName.topLevelClassName().peerClass(SourceFiles.classFileName(moduleClassName) + "_Proxy");
    }

    private Optional<ExecutableElement> nonPublicNullaryConstructor(TypeElement moduleElement) {
        ModuleKind.checkIsModule(moduleElement);
        if (moduleElement.getModifiers().contains((Object)Modifier.ABSTRACT) || moduleElement.getNestingKind().isNested() && !moduleElement.getModifiers().contains((Object)Modifier.STATIC)) {
            return Optional.empty();
        }
        return ElementFilter.constructorsIn(this.elements.getAllMembers(moduleElement)).stream().filter(constructor -> !Accessibility.isElementPubliclyAccessible(constructor)).filter(constructor -> !constructor.getModifiers().contains((Object)Modifier.PRIVATE)).filter(constructor -> constructor.getParameters().isEmpty()).findAny();
    }

    public CodeBlock newModuleInstance(TypeElement moduleElement, ClassName requestingClass) {
        ModuleKind.checkIsModule(moduleElement);
        String packageName = requestingClass.packageName();
        return this.nonPublicNullaryConstructor(moduleElement).filter(constructor -> !Accessibility.isElementAccessibleFrom((Element)constructor, packageName)).map(constructor -> CodeBlock.of((String)"$T.newInstance()", (Object[])new Object[]{this.constructorProxyTypeName(moduleElement)})).orElse(CodeBlock.of((String)"new $T()", (Object[])new Object[]{moduleElement}));
    }

    public static final class ModuleConstructorProxyGenerator
    extends SourceFileGenerator<TypeElement> {
        private final ModuleProxies moduleProxies;

        @Inject
        ModuleConstructorProxyGenerator(Filer filer, DaggerElements elements, SourceVersion sourceVersion, ModuleProxies moduleProxies) {
            super(filer, elements, sourceVersion);
            this.moduleProxies = moduleProxies;
        }

        @Override
        public ClassName nameGeneratedType(TypeElement moduleElement) {
            return this.moduleProxies.constructorProxyTypeName(moduleElement);
        }

        @Override
        public Element originatingElement(TypeElement moduleElement) {
            return moduleElement;
        }

        @Override
        public Optional<TypeSpec.Builder> write(TypeElement moduleElement) {
            ModuleKind.checkIsModule(moduleElement);
            return this.moduleProxies.nonPublicNullaryConstructor(moduleElement).isPresent() ? Optional.of(this.buildProxy(moduleElement)) : Optional.empty();
        }

        private TypeSpec.Builder buildProxy(TypeElement moduleElement) {
            return TypeSpec.classBuilder((ClassName)this.nameGeneratedType(moduleElement)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build()).addMethod(MethodSpec.methodBuilder((String)"newInstance").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)ClassName.get((TypeElement)moduleElement)).addStatement("return new $T()", new Object[]{moduleElement}).build());
        }
    }
}

