

package dagger.internal.codegen.writing;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.Optional;
import javax.annotation.Generated;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_InjectionMethod extends InjectionMethod {

  private final String name;
  private final boolean varargs;
  private final ImmutableList<TypeVariableName> typeVariables;
  private final ImmutableMap<ParameterSpec, TypeMirror> parameters;
  private final Optional<TypeMirror> returnType;
  private final Optional<DeclaredType> nullableAnnotation;
  private final ImmutableList<TypeMirror> exceptions;
  private final CodeBlock methodBody;
  private final ClassName enclosingClass;
  private final Optional<String> injectedFieldSignature;
  private final Optional<AnnotationSpec> qualifierSpec;

  private AutoValue_InjectionMethod(
      String name,
      boolean varargs,
      ImmutableList<TypeVariableName> typeVariables,
      ImmutableMap<ParameterSpec, TypeMirror> parameters,
      Optional<TypeMirror> returnType,
      Optional<DeclaredType> nullableAnnotation,
      ImmutableList<TypeMirror> exceptions,
      CodeBlock methodBody,
      ClassName enclosingClass,
      Optional<String> injectedFieldSignature,
      Optional<AnnotationSpec> qualifierSpec) {
    this.name = name;
    this.varargs = varargs;
    this.typeVariables = typeVariables;
    this.parameters = parameters;
    this.returnType = returnType;
    this.nullableAnnotation = nullableAnnotation;
    this.exceptions = exceptions;
    this.methodBody = methodBody;
    this.enclosingClass = enclosingClass;
    this.injectedFieldSignature = injectedFieldSignature;
    this.qualifierSpec = qualifierSpec;
  }

  @Override
  String name() {
    return name;
  }

  @Override
  boolean varargs() {
    return varargs;
  }

  @Override
  ImmutableList<TypeVariableName> typeVariables() {
    return typeVariables;
  }

  @Override
  ImmutableMap<ParameterSpec, TypeMirror> parameters() {
    return parameters;
  }

  @Override
  Optional<TypeMirror> returnType() {
    return returnType;
  }

  @Override
  Optional<DeclaredType> nullableAnnotation() {
    return nullableAnnotation;
  }

  @Override
  ImmutableList<TypeMirror> exceptions() {
    return exceptions;
  }

  @Override
  CodeBlock methodBody() {
    return methodBody;
  }

  @Override
  ClassName enclosingClass() {
    return enclosingClass;
  }

  @Override
  Optional<String> injectedFieldSignature() {
    return injectedFieldSignature;
  }

  @Override
  Optional<AnnotationSpec> qualifierSpec() {
    return qualifierSpec;
  }

  @Override
  public String toString() {
    return "InjectionMethod{"
         + "name=" + name + ", "
         + "varargs=" + varargs + ", "
         + "typeVariables=" + typeVariables + ", "
         + "parameters=" + parameters + ", "
         + "returnType=" + returnType + ", "
         + "nullableAnnotation=" + nullableAnnotation + ", "
         + "exceptions=" + exceptions + ", "
         + "methodBody=" + methodBody + ", "
         + "enclosingClass=" + enclosingClass + ", "
         + "injectedFieldSignature=" + injectedFieldSignature + ", "
         + "qualifierSpec=" + qualifierSpec
        + "}";
  }

  static final class Builder extends InjectionMethod.Builder {
    private String name;
    private Boolean varargs;
    private ImmutableList.Builder<TypeVariableName> typeVariablesBuilder$;
    private ImmutableList<TypeVariableName> typeVariables;
    private ImmutableMap.Builder<ParameterSpec, TypeMirror> parametersBuilder$;
    private ImmutableMap<ParameterSpec, TypeMirror> parameters;
    private Optional<TypeMirror> returnType = Optional.empty();
    private Optional<DeclaredType> nullableAnnotation = Optional.empty();
    private ImmutableList<TypeMirror> exceptions;
    private CodeBlock methodBody;
    private ClassName enclosingClass;
    private Optional<String> injectedFieldSignature = Optional.empty();
    private Optional<AnnotationSpec> qualifierSpec = Optional.empty();
    Builder() {
    }
    @Override
    InjectionMethod.Builder name(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    InjectionMethod.Builder varargs(boolean varargs) {
      this.varargs = varargs;
      return this;
    }
    @Override
    ImmutableList.Builder<TypeVariableName> typeVariablesBuilder() {
      if (typeVariablesBuilder$ == null) {
        typeVariablesBuilder$ = ImmutableList.builder();
      }
      return typeVariablesBuilder$;
    }
    @Override
    ImmutableMap.Builder<ParameterSpec, TypeMirror> parametersBuilder() {
      if (parametersBuilder$ == null) {
        parametersBuilder$ = ImmutableMap.builder();
      }
      return parametersBuilder$;
    }
    @Override
    InjectionMethod.Builder returnType(TypeMirror returnType) {
      if (returnType == null) {
        throw new NullPointerException("Null returnType");
      }
      this.returnType = Optional.of(returnType);
      return this;
    }
    @Override
    InjectionMethod.Builder nullableAnnotation(Optional<DeclaredType> nullableAnnotation) {
      if (nullableAnnotation == null) {
        throw new NullPointerException("Null nullableAnnotation");
      }
      this.nullableAnnotation = nullableAnnotation;
      return this;
    }
    @Override
    InjectionMethod.Builder exceptions(Iterable<? extends TypeMirror> exceptions) {
      if (exceptions == null) {
        throw new NullPointerException("Null exceptions");
      }
      this.exceptions = ImmutableList.copyOf(exceptions);
      return this;
    }
    @Override
    InjectionMethod.Builder methodBody(CodeBlock methodBody) {
      if (methodBody == null) {
        throw new NullPointerException("Null methodBody");
      }
      this.methodBody = methodBody;
      return this;
    }
    @Override
    InjectionMethod.Builder enclosingClass(ClassName enclosingClass) {
      if (enclosingClass == null) {
        throw new NullPointerException("Null enclosingClass");
      }
      this.enclosingClass = enclosingClass;
      return this;
    }
    @Override
    InjectionMethod.Builder injectedFieldSignature(String injectedFieldSignature) {
      if (injectedFieldSignature == null) {
        throw new NullPointerException("Null injectedFieldSignature");
      }
      this.injectedFieldSignature = Optional.of(injectedFieldSignature);
      return this;
    }
    @Override
    InjectionMethod.Builder qualifierSpec(AnnotationSpec qualifierSpec) {
      if (qualifierSpec == null) {
        throw new NullPointerException("Null qualifierSpec");
      }
      this.qualifierSpec = Optional.of(qualifierSpec);
      return this;
    }
    @Override
    InjectionMethod buildInternal() {
      if (typeVariablesBuilder$ != null) {
        this.typeVariables = typeVariablesBuilder$.build();
      } else if (this.typeVariables == null) {
        this.typeVariables = ImmutableList.of();
      }
      if (parametersBuilder$ != null) {
        this.parameters = parametersBuilder$.build();
      } else if (this.parameters == null) {
        this.parameters = ImmutableMap.of();
      }
      String missing = "";
      if (this.name == null) {
        missing += " name";
      }
      if (this.varargs == null) {
        missing += " varargs";
      }
      if (this.exceptions == null) {
        missing += " exceptions";
      }
      if (this.methodBody == null) {
        missing += " methodBody";
      }
      if (this.enclosingClass == null) {
        missing += " enclosingClass";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_InjectionMethod(
          this.name,
          this.varargs,
          this.typeVariables,
          this.parameters,
          this.returnType,
          this.nullableAnnotation,
          this.exceptions,
          this.methodBody,
          this.enclosingClass,
          this.injectedFieldSignature,
          this.qualifierSpec);
    }
  }

}
