/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import com.squareup.javapoet.TypeName;
import dagger.Lazy;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.model.RequestKind;
import dagger.producers.Produced;
import dagger.producers.Producer;
import dagger.shaded.auto.common.MoreTypes;
import javax.inject.Provider;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public final class RequestKinds {
    private static final ImmutableMap<RequestKind, Class<?>> FRAMEWORK_CLASSES = ImmutableMap.of((Object)RequestKind.PROVIDER, Provider.class, (Object)RequestKind.LAZY, Lazy.class, (Object)RequestKind.PRODUCER, Producer.class, (Object)RequestKind.PRODUCED, Produced.class);

    public static TypeMirror requestType(RequestKind requestKind, TypeMirror type, DaggerTypes types) {
        switch (requestKind) {
            case INSTANCE: {
                return type;
            }
            case PROVIDER_OF_LAZY: {
                return types.wrapType(RequestKinds.requestType(RequestKind.LAZY, type, types), Provider.class);
            }
            case FUTURE: {
                return types.wrapType(type, ListenableFuture.class);
            }
        }
        return types.wrapType(type, RequestKinds.frameworkClass(requestKind));
    }

    public static TypeName requestTypeName(RequestKind requestKind, TypeName keyType) {
        switch (requestKind) {
            case INSTANCE: {
                return keyType;
            }
            case PROVIDER: {
                return TypeNames.providerOf(keyType);
            }
            case LAZY: {
                return TypeNames.lazyOf(keyType);
            }
            case PROVIDER_OF_LAZY: {
                return TypeNames.providerOf((TypeName)TypeNames.lazyOf(keyType));
            }
            case PRODUCER: {
                return TypeNames.producerOf(keyType);
            }
            case PRODUCED: {
                return TypeNames.producedOf(keyType);
            }
            case FUTURE: {
                return TypeNames.listenableFutureOf(keyType);
            }
        }
        throw new AssertionError(requestKind);
    }

    public static RequestKind getRequestKind(TypeMirror type) {
        DaggerTypes.checkTypePresent(type);
        if (!MoreTypes.isType(type) || !type.getKind().equals((Object)TypeKind.DECLARED) || MoreTypes.asDeclared(type).getTypeArguments().isEmpty()) {
            return RequestKind.INSTANCE;
        }
        for (RequestKind kind : FRAMEWORK_CLASSES.keySet()) {
            if (!MoreTypes.isTypeOf(RequestKinds.frameworkClass(kind), type)) continue;
            if (kind.equals((Object)RequestKind.PROVIDER) && RequestKinds.getRequestKind(DaggerTypes.unwrapType(type)).equals((Object)RequestKind.LAZY)) {
                return RequestKind.PROVIDER_OF_LAZY;
            }
            return kind;
        }
        return RequestKind.INSTANCE;
    }

    public static TypeMirror extractKeyType(TypeMirror type) {
        return RequestKinds.extractKeyType(RequestKinds.getRequestKind(type), type);
    }

    private static TypeMirror extractKeyType(RequestKind requestKind, TypeMirror type) {
        switch (requestKind) {
            case INSTANCE: {
                return type;
            }
            case PROVIDER_OF_LAZY: {
                return RequestKinds.extractKeyType(RequestKind.LAZY, RequestKinds.extractKeyType(RequestKind.PROVIDER, type));
            }
        }
        Preconditions.checkArgument((boolean)MoreTypes.isType(type));
        return DaggerTypes.unwrapType(type);
    }

    public static Class<?> frameworkClass(RequestKind requestKind) {
        Class result = (Class)FRAMEWORK_CLASSES.get((Object)requestKind);
        Preconditions.checkArgument((result != null ? 1 : 0) != 0, (String)"no framework class for %s", (Object)requestKind);
        return result;
    }

    public static boolean canBeSatisfiedByProductionBinding(RequestKind requestKind) {
        switch (requestKind) {
            case INSTANCE: 
            case PROVIDER_OF_LAZY: 
            case PROVIDER: 
            case LAZY: 
            case MEMBERS_INJECTION: {
                return false;
            }
            case FUTURE: 
            case PRODUCER: 
            case PRODUCED: {
                return true;
            }
        }
        throw new AssertionError();
    }

    private RequestKinds() {
    }
}

