/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.CodeBlock;
import dagger.internal.codegen.base.ContributionType;
import dagger.internal.codegen.base.SetType;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.BindingType;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.ResolvedBindings;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.writing.ComponentBindingExpressions;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.MultibindingFactoryCreationExpression;
import dagger.model.DependencyRequest;
import dagger.producers.Produced;

final class SetFactoryCreationExpression
extends MultibindingFactoryCreationExpression {
    private final BindingGraph graph;
    private final ContributionBinding binding;

    SetFactoryCreationExpression(ContributionBinding binding, ComponentImplementation componentImplementation, ComponentBindingExpressions componentBindingExpressions, BindingGraph graph) {
        super(binding, componentImplementation, componentBindingExpressions);
        this.binding = (ContributionBinding)Preconditions.checkNotNull((Object)binding);
        this.graph = (BindingGraph)Preconditions.checkNotNull((Object)graph);
    }

    @Override
    public CodeBlock creationExpression() {
        CodeBlock.Builder builder = CodeBlock.builder().add("$T.", new Object[]{SourceFiles.setFactoryClassName(this.binding)});
        if (!this.useRawType()) {
            SetType setType = SetType.from(this.binding.key());
            builder.add("<$T>", new Object[]{setType.elementsAreTypeOf(Produced.class) ? setType.unwrappedElementType(Produced.class) : setType.elementType()});
        }
        int individualProviders = 0;
        int setProviders = 0;
        CodeBlock.Builder builderMethodCalls = CodeBlock.builder();
        String methodNameSuffix = this.binding.bindingType().equals((Object)BindingType.PROVISION) ? "Provider" : "Producer";
        for (DependencyRequest dependency : this.binding.dependencies()) {
            String methodNamePrefix;
            ContributionType contributionType = ((ResolvedBindings)this.graph.contributionBindings().get((Object)dependency.key())).contributionType();
            switch (contributionType) {
                case SET: {
                    ++individualProviders;
                    methodNamePrefix = "add";
                    break;
                }
                case SET_VALUES: {
                    ++setProviders;
                    methodNamePrefix = "addCollection";
                    break;
                }
                default: {
                    throw new AssertionError((Object)(dependency + " is not a set multibinding"));
                }
            }
            builderMethodCalls.add(".$N$N($L)", new Object[]{methodNamePrefix, methodNameSuffix, this.multibindingDependencyExpression(dependency)});
        }
        builder.add("builder($L, $L)", new Object[]{individualProviders, setProviders});
        builder.add(builderMethodCalls.build());
        return builder.add(".build()", new Object[0]).build();
    }
}

