/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.componentgenerator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.Preconditions;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.ComponentCreatorDescriptor;
import dagger.internal.codegen.binding.ComponentCreatorKind;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.FrameworkType;
import dagger.internal.codegen.binding.MethodSignature;
import dagger.internal.codegen.componentgenerator.ComponentCreatorImplementationFactory;
import dagger.internal.codegen.componentgenerator.TopLevelImplementationComponent;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.AnnotationSpecs;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.writing.ComponentBindingExpressions;
import dagger.internal.codegen.writing.ComponentCreatorImplementation;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentRequirementExpressions;
import dagger.internal.codegen.writing.ParentComponent;
import dagger.model.Key;
import dagger.producers.CancellationPolicy;
import dagger.producers.internal.CancellationListener;
import dagger.producers.internal.Producers;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Types;

public final class ComponentImplementationBuilder {
    private static final String MAY_INTERRUPT_IF_RUNNING = "mayInterruptIfRunning";
    private static final int STATEMENTS_PER_METHOD = 100;
    private static final String CANCELLATION_LISTENER_METHOD_NAME = "onProducerFutureCancelled";
    private final Optional<ComponentImplementationBuilder> parent;
    private final BindingGraph graph;
    private final ComponentBindingExpressions bindingExpressions;
    private final ComponentRequirementExpressions componentRequirementExpressions;
    private final ComponentImplementation componentImplementation;
    private final ComponentCreatorImplementationFactory componentCreatorImplementationFactory;
    private final TopLevelImplementationComponent topLevelImplementationComponent;
    private final DaggerTypes types;
    private final DaggerElements elements;
    private final KotlinMetadataUtil metadataUtil;
    private boolean done;

    @Inject
    ComponentImplementationBuilder(@ParentComponent Optional<ComponentImplementationBuilder> parent, BindingGraph graph, ComponentBindingExpressions bindingExpressions, ComponentRequirementExpressions componentRequirementExpressions, ComponentImplementation componentImplementation, ComponentCreatorImplementationFactory componentCreatorImplementationFactory, TopLevelImplementationComponent topLevelImplementationComponent, DaggerTypes types, DaggerElements elements, KotlinMetadataUtil metadataUtil) {
        this.parent = parent;
        this.graph = graph;
        this.bindingExpressions = bindingExpressions;
        this.componentRequirementExpressions = componentRequirementExpressions;
        this.componentImplementation = componentImplementation;
        this.componentCreatorImplementationFactory = componentCreatorImplementationFactory;
        this.types = types;
        this.elements = elements;
        this.topLevelImplementationComponent = topLevelImplementationComponent;
        this.metadataUtil = metadataUtil;
    }

    ComponentImplementation build() {
        com.google.common.base.Preconditions.checkState((!this.done ? 1 : 0) != 0, (String)"ComponentImplementationBuilder has already built the ComponentImplementation for [%s].", (Object)this.componentImplementation.name());
        this.setSupertype();
        this.componentCreatorImplementationFactory.create().map(ComponentCreatorImplementation::spec).ifPresent(this::addCreatorClass);
        MoreElements.getLocalAndInheritedMethods(this.graph.componentTypeElement(), this.types, this.elements).forEach(method -> this.componentImplementation.claimMethodName(method.getSimpleName()));
        this.addFactoryMethods();
        this.addInterfaceMethods();
        this.addChildComponents();
        this.addConstructorAndInitializationMethods();
        if (this.graph.componentDescriptor().isProduction()) {
            this.addCancellationListenerImplementation();
        }
        this.done = true;
        return this.componentImplementation;
    }

    private void setSupertype() {
        this.componentImplementation.addSupertype(this.graph.componentTypeElement());
    }

    private void addCreatorClass(TypeSpec creator) {
        if (this.parent.isPresent()) {
            this.parent.get().componentImplementation.addType(ComponentImplementation.TypeSpecKind.SUBCOMPONENT, creator);
        } else {
            this.componentImplementation.addType(ComponentImplementation.TypeSpecKind.COMPONENT_CREATOR, creator);
        }
    }

    private void addFactoryMethods() {
        if (this.parent.isPresent()) {
            this.graph.factoryMethod().ifPresent(this::createSubcomponentFactoryMethod);
        } else {
            this.createRootComponentFactoryMethod();
        }
    }

    private void addInterfaceMethods() {
        ImmutableListMultimap componentMethodsBySignature = Multimaps.index(this.graph.componentDescriptor().entryPointMethods(), this::getMethodSignature);
        for (List methodsWithSameSignature : Multimaps.asMap((ListMultimap)componentMethodsBySignature).values()) {
            ComponentDescriptor.ComponentMethodDescriptor anyOneMethod = (ComponentDescriptor.ComponentMethodDescriptor)methodsWithSameSignature.stream().findAny().get();
            MethodSpec methodSpec = this.bindingExpressions.getComponentMethod(anyOneMethod);
            this.componentImplementation.addMethod(ComponentImplementation.MethodSpecKind.COMPONENT_METHOD, methodSpec);
        }
    }

    private void addCancellationListenerImplementation() {
        this.componentImplementation.addSupertype(this.elements.getTypeElement(CancellationListener.class));
        this.componentImplementation.claimMethodName(CANCELLATION_LISTENER_METHOD_NAME);
        ImmutableList parameters = ImmutableList.of((Object)ParameterSpec.builder(Boolean.TYPE, (String)MAY_INTERRUPT_IF_RUNNING, (Modifier[])new Modifier[0]).build());
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)CANCELLATION_LISTENER_METHOD_NAME).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameters((Iterable)parameters);
        ImmutableList<CodeBlock> cancellationStatements = this.cancellationStatements();
        if (cancellationStatements.size() < 100) {
            methodBuilder.addCode(CodeBlocks.concat(cancellationStatements)).build();
        } else {
            ImmutableList<MethodSpec> cancelProducersMethods = this.createPartitionedMethods("cancelProducers", (Iterable<ParameterSpec>)parameters, (List<CodeBlock>)cancellationStatements, methodName -> MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PRIVATE}));
            for (MethodSpec cancelProducersMethod : cancelProducersMethods) {
                methodBuilder.addStatement("$N($L)", new Object[]{cancelProducersMethod, MAY_INTERRUPT_IF_RUNNING});
                this.componentImplementation.addMethod(ComponentImplementation.MethodSpecKind.CANCELLATION_LISTENER_METHOD, cancelProducersMethod);
            }
        }
        this.cancelParentStatement().ifPresent(arg_0 -> ((MethodSpec.Builder)methodBuilder).addCode(arg_0));
        this.componentImplementation.addMethod(ComponentImplementation.MethodSpecKind.CANCELLATION_LISTENER_METHOD, methodBuilder.build());
    }

    private ImmutableList<CodeBlock> cancellationStatements() {
        ImmutableList cancellationKeys = this.componentImplementation.getCancellableProducerKeys().reverse();
        ImmutableList.Builder cancellationStatements = ImmutableList.builder();
        for (Key cancellationKey : cancellationKeys) {
            cancellationStatements.add((Object)CodeBlock.of((String)"$T.cancel($L, $N);", (Object[])new Object[]{Producers.class, this.bindingExpressions.getDependencyExpression(BindingRequest.bindingRequest(cancellationKey, FrameworkType.PRODUCER_NODE), this.componentImplementation.name()).codeBlock(), MAY_INTERRUPT_IF_RUNNING}));
        }
        return cancellationStatements.build();
    }

    private Optional<CodeBlock> cancelParentStatement() {
        if (!this.shouldPropagateCancellationToParent()) {
            return Optional.empty();
        }
        return Optional.of(CodeBlock.builder().addStatement("$T.this.$N($N)", new Object[]{this.parent.get().componentImplementation.name(), CANCELLATION_LISTENER_METHOD_NAME, MAY_INTERRUPT_IF_RUNNING}).build());
    }

    private boolean shouldPropagateCancellationToParent() {
        return this.parent.isPresent() && this.parent.get().componentImplementation.componentDescriptor().cancellationPolicy().map(policy -> policy.fromSubcomponents().equals((Object)CancellationPolicy.Propagation.PROPAGATE)).orElse(false) != false;
    }

    private MethodSignature getMethodSignature(ComponentDescriptor.ComponentMethodDescriptor method) {
        return MethodSignature.forComponentMethod(method, MoreTypes.asDeclared(this.graph.componentTypeElement().asType()), this.types);
    }

    private void addChildComponents() {
        for (BindingGraph subgraph : this.graph.subgraphs()) {
            this.componentImplementation.addType(ComponentImplementation.TypeSpecKind.SUBCOMPONENT, this.childComponent(subgraph));
        }
    }

    private TypeSpec childComponent(BindingGraph childGraph) {
        return this.topLevelImplementationComponent.currentImplementationSubcomponentBuilder().componentImplementation(this.subcomponent(childGraph)).bindingGraph(childGraph).parentBuilder(Optional.of(this)).parentBindingExpressions(Optional.of(this.bindingExpressions)).parentRequirementExpressions(Optional.of(this.componentRequirementExpressions)).build().componentImplementationBuilder().build().generate().build();
    }

    private ComponentImplementation subcomponent(BindingGraph childGraph) {
        return this.componentImplementation.childComponentImplementation(childGraph);
    }

    private void addConstructorAndInitializationMethods() {
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE});
        this.implementInitializationMethod(constructor, this.initializationParameters());
        this.componentImplementation.addMethod(ComponentImplementation.MethodSpecKind.CONSTRUCTOR, constructor.build());
    }

    private void implementInitializationMethod(MethodSpec.Builder initializationMethod, ImmutableMap<ComponentRequirement, ParameterSpec> initializationParameters) {
        initializationMethod.addParameters((Iterable)initializationParameters.values());
        initializationMethod.addCode(CodeBlocks.concat(this.componentImplementation.getComponentRequirementInitializations()));
        this.addInitializeMethods(initializationMethod, (ImmutableList<ParameterSpec>)initializationParameters.values().asList());
    }

    private void addInitializeMethods(MethodSpec.Builder callingMethod, ImmutableList<ParameterSpec> parameters) {
        CodeBlock args = CodeBlocks.parameterNames(parameters);
        ImmutableList<MethodSpec> methods = this.createPartitionedMethods("initialize", (Iterable<ParameterSpec>)this.makeFinal((Collection<ParameterSpec>)parameters), (List<CodeBlock>)this.componentImplementation.getInitializations(), methodName -> MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PRIVATE}).addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.UNCHECKED, new AnnotationSpecs.Suppression[0])));
        for (MethodSpec method : methods) {
            callingMethod.addStatement("$N($L)", new Object[]{method, args});
            this.componentImplementation.addMethod(ComponentImplementation.MethodSpecKind.INITIALIZE_METHOD, method);
        }
    }

    private ImmutableList<MethodSpec> createPartitionedMethods(String methodName, Iterable<ParameterSpec> parameters, List<CodeBlock> statements, Function<String, MethodSpec.Builder> methodBuilderCreator) {
        return (ImmutableList)Lists.partition(statements, (int)100).stream().map(partition -> ((MethodSpec.Builder)methodBuilderCreator.apply(this.componentImplementation.getUniqueMethodName(methodName))).addParameters(parameters).addCode(CodeBlocks.concat(partition)).build()).collect(DaggerStreams.toImmutableList());
    }

    private final ImmutableList<ParameterSpec> makeFinal(Collection<ParameterSpec> parameters) {
        return (ImmutableList)parameters.stream().map(param -> param.toBuilder().addModifiers(new Modifier[]{Modifier.FINAL}).build()).collect(DaggerStreams.toImmutableList());
    }

    private final ImmutableMap<ComponentRequirement, ParameterSpec> initializationParameters() {
        Object parameters;
        if (this.componentImplementation.componentDescriptor().hasCreator()) {
            parameters = Maps.toMap(this.graph.componentRequirements(), ComponentRequirement::toParameterSpec);
        } else if (this.graph.factoryMethod().isPresent()) {
            parameters = ComponentImplementationBuilder.getFactoryMethodParameters(this.graph);
        } else {
            throw new AssertionError((Object)"Expected either a component creator or factory method but found neither.");
        }
        return this.renameParameters((Map<ComponentRequirement, ParameterSpec>)parameters);
    }

    private ImmutableMap<ComponentRequirement, ParameterSpec> renameParameters(Map<ComponentRequirement, ParameterSpec> parameters) {
        return ImmutableMap.copyOf((Map)Maps.transformEntries(parameters, (requirement, parameter) -> this.renameParameter((ParameterSpec)parameter, this.componentImplementation.getParameterName((ComponentRequirement)requirement, parameter.name))));
    }

    private ParameterSpec renameParameter(ParameterSpec parameter, String newName) {
        return ParameterSpec.builder((TypeName)parameter.type, (String)newName, (Modifier[])new Modifier[0]).addAnnotations((Iterable)parameter.annotations).addModifiers((Iterable)parameter.modifiers).build();
    }

    private void createRootComponentFactoryMethod() {
        boolean noArgFactoryMethod;
        String factoryMethodName;
        ClassName creatorType;
        ComponentCreatorKind creatorKind;
        com.google.common.base.Preconditions.checkState((!this.parent.isPresent() ? 1 : 0) != 0);
        Optional<ComponentCreatorDescriptor> creatorDescriptor = this.graph.componentDescriptor().creatorDescriptor();
        if (creatorDescriptor.isPresent()) {
            ComponentCreatorDescriptor descriptor = creatorDescriptor.get();
            creatorKind = descriptor.kind();
            creatorType = ClassName.get((TypeElement)descriptor.typeElement());
            factoryMethodName = descriptor.factoryMethod().getSimpleName().toString();
            noArgFactoryMethod = descriptor.factoryParameters().isEmpty();
        } else {
            creatorKind = ComponentCreatorKind.BUILDER;
            creatorType = this.componentImplementation.getCreatorName();
            factoryMethodName = "build";
            noArgFactoryMethod = true;
        }
        MethodSpec creatorFactoryMethod = MethodSpec.methodBuilder((String)creatorKind.methodName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)creatorType).addStatement("return new $T()", new Object[]{this.componentImplementation.getCreatorName()}).build();
        this.componentImplementation.addMethod(ComponentImplementation.MethodSpecKind.BUILDER_METHOD, creatorFactoryMethod);
        if (noArgFactoryMethod && this.canInstantiateAllRequirements()) {
            this.componentImplementation.addMethod(ComponentImplementation.MethodSpecKind.BUILDER_METHOD, MethodSpec.methodBuilder((String)"create").returns((TypeName)ClassName.get((TypeElement)this.graph.componentTypeElement())).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addStatement("return new $L().$L()", new Object[]{creatorKind.typeName(), factoryMethodName}).build());
        }
    }

    private boolean canInstantiateAllRequirements() {
        return !Iterables.any(this.graph.componentRequirements(), dependency -> dependency.requiresAPassedInstance(this.elements, this.types, this.metadataUtil));
    }

    private void createSubcomponentFactoryMethod(ExecutableElement factoryMethod) {
        com.google.common.base.Preconditions.checkState((boolean)this.parent.isPresent());
        Collection<ParameterSpec> params = ComponentImplementationBuilder.getFactoryMethodParameters(this.graph).values();
        MethodSpec.Builder method = MethodSpec.overriding((ExecutableElement)factoryMethod, (DeclaredType)this.parentType(), (Types)this.types);
        params.forEach(param -> method.addStatement("$T.checkNotNull($N)", new Object[]{Preconditions.class, param}));
        method.addStatement("return new $T($L)", new Object[]{this.componentImplementation.name(), CodeBlocks.parameterNames(params)});
        this.parent.get().componentImplementation.addMethod(ComponentImplementation.MethodSpecKind.COMPONENT_METHOD, method.build());
    }

    private DeclaredType parentType() {
        return MoreTypes.asDeclared(this.parent.get().graph.componentTypeElement().asType());
    }

    private static Map<ComponentRequirement, ParameterSpec> getFactoryMethodParameters(BindingGraph graph) {
        return Maps.transformValues(graph.factoryMethodParameters(), ParameterSpec::get);
    }
}

