/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.kotlin;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import dagger.internal.codegen.base.MoreAnnotationValues;
import dagger.internal.codegen.extension.DaggerCollectors;
import dagger.internal.codegen.langmodel.DaggerElements;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import kotlin.Metadata;
import kotlinx.metadata.Flag;
import kotlinx.metadata.KmClassVisitor;
import kotlinx.metadata.KmConstructorVisitor;
import kotlinx.metadata.KmExtensionType;
import kotlinx.metadata.KmPropertyExtensionVisitor;
import kotlinx.metadata.KmPropertyVisitor;
import kotlinx.metadata.KmValueParameterVisitor;
import kotlinx.metadata.jvm.JvmFieldSignature;
import kotlinx.metadata.jvm.JvmMethodSignature;
import kotlinx.metadata.jvm.JvmPropertyExtensionVisitor;
import kotlinx.metadata.jvm.KotlinClassHeader;
import kotlinx.metadata.jvm.KotlinClassMetadata;

final class KotlinMetadata {
    private static final String DELEGATED_PROPERTY_NAME_SUFFIX = "$delegate";
    private final TypeElement typeElement;
    private final KotlinClassMetadata.Class data;
    private final Supplier<Integer> flags;
    private final Supplier<Optional<String>> companionObjectName;
    private final Supplier<List<Property>> properties;
    private final Supplier<Map<String, Property>> propertyDescriptors;
    private final Supplier<Map<String, ExecutableElement>> methodDescriptors;
    private final Supplier<Map<VariableElement, Optional<MethodForAnnotations>>> elementFieldAnnotationMethodMap;
    private final Supplier<Map<VariableElement, Optional<ExecutableElement>>> elementFieldGetterMethodMap;
    private final Supplier<Boolean> containsConstructorWithDefaultParam;

    private KotlinMetadata(TypeElement typeElement, KotlinClassMetadata.Class data) {
        this.typeElement = typeElement;
        this.data = data;
        this.flags = Suppliers.memoize(this::retrieveFlags);
        this.companionObjectName = Suppliers.memoize(this::retrieveCompanionObjectName);
        this.properties = Suppliers.memoize(this::retrieveProperties);
        this.propertyDescriptors = Suppliers.memoize(() -> ((List)this.properties.get()).stream().filter(property -> property.getFieldSignature().isPresent()).collect(Collectors.toMap(property -> property.getFieldSignature().get(), Function.identity())));
        this.methodDescriptors = Suppliers.memoize(() -> ElementFilter.methodsIn(typeElement.getEnclosedElements()).stream().collect(Collectors.toMap(DaggerElements::getMethodDescriptor, Function.identity())));
        this.elementFieldAnnotationMethodMap = Suppliers.memoize(() -> this.mapFieldToAnnotationMethod((Map)this.propertyDescriptors.get(), (Map)this.methodDescriptors.get()));
        this.elementFieldGetterMethodMap = Suppliers.memoize(() -> this.mapFieldToGetterMethod((Map)this.propertyDescriptors.get(), (Map)this.methodDescriptors.get()));
        this.containsConstructorWithDefaultParam = Suppliers.memoize(this::checkConstructorForDefaultParam);
    }

    private int retrieveFlags() {
        FlagsVisitor visitor = new FlagsVisitor();
        this.data.accept((KmClassVisitor)visitor);
        return visitor.flags;
    }

    private Optional<String> retrieveCompanionObjectName() {
        CompanionObjectNameVisitor visitor = new CompanionObjectNameVisitor();
        this.data.accept((KmClassVisitor)visitor);
        return visitor.name;
    }

    private List<Property> retrieveProperties() {
        PropertiesVisitor visitor = new PropertiesVisitor();
        this.data.accept((KmClassVisitor)visitor);
        return visitor.properties;
    }

    private Map<VariableElement, Optional<MethodForAnnotations>> mapFieldToAnnotationMethod(Map<String, Property> propertyDescriptors, Map<String, ExecutableElement> methodDescriptors) {
        return ElementFilter.fieldsIn(this.typeElement.getEnclosedElements()).stream().filter(field -> !field.getModifiers().contains((Object)Modifier.STATIC)).collect(Collectors.toMap(Function.identity(), field -> this.findProperty((VariableElement)field, propertyDescriptors).getMethodForAnnotationsSignature().map(signature -> Optional.ofNullable((ExecutableElement)methodDescriptors.get(signature)).map(MethodForAnnotations::new).orElse(MethodForAnnotations.MISSING))));
    }

    private Map<VariableElement, Optional<ExecutableElement>> mapFieldToGetterMethod(Map<String, Property> propertyDescriptors, Map<String, ExecutableElement> methodDescriptors) {
        return ElementFilter.fieldsIn(this.typeElement.getEnclosedElements()).stream().filter(field -> !field.getModifiers().contains((Object)Modifier.STATIC)).collect(Collectors.toMap(Function.identity(), field -> this.findProperty((VariableElement)field, propertyDescriptors).getGetterMethodSignature().flatMap(signature -> Optional.ofNullable((ExecutableElement)methodDescriptors.get(signature)))));
    }

    private Property findProperty(VariableElement field, Map<String, Property> propertyDescriptors) {
        String fieldDescriptor = DaggerElements.getFieldDescriptor(field);
        if (propertyDescriptors.containsKey(fieldDescriptor)) {
            return propertyDescriptors.get(fieldDescriptor);
        }
        String propertyName = KotlinMetadata.getPropertyNameFromField(field);
        return (Property)propertyDescriptors.values().stream().filter(property -> propertyName.contentEquals(((Property)property).name)).collect(DaggerCollectors.onlyElement());
    }

    private static String getPropertyNameFromField(VariableElement field) {
        String name = field.getSimpleName().toString();
        if (name.endsWith(DELEGATED_PROPERTY_NAME_SUFFIX)) {
            return name.substring(0, name.length() - DELEGATED_PROPERTY_NAME_SUFFIX.length());
        }
        return name;
    }

    private boolean checkConstructorForDefaultParam() {
        ConstructorWithDefaultParamVisitor visitor = new ConstructorWithDefaultParamVisitor();
        this.data.accept((KmClassVisitor)visitor);
        return visitor.containsConstructorWithDefaultParam;
    }

    TypeElement getTypeElement() {
        return this.typeElement;
    }

    Optional<ExecutableElement> getSyntheticAnnotationMethod(VariableElement fieldElement) {
        Preconditions.checkArgument((boolean)((Map)this.elementFieldAnnotationMethodMap.get()).containsKey(fieldElement));
        return ((Optional)((Map)this.elementFieldAnnotationMethodMap.get()).get(fieldElement)).map(methodForAnnotations -> {
            if (methodForAnnotations == MethodForAnnotations.MISSING) {
                throw new IllegalStateException("Method for annotations is missing for " + fieldElement);
            }
            return methodForAnnotations.getMethod();
        });
    }

    boolean isMissingSyntheticAnnotationMethod(VariableElement fieldElement) {
        Preconditions.checkArgument((boolean)((Map)this.elementFieldAnnotationMethodMap.get()).containsKey(fieldElement));
        return ((Optional)((Map)this.elementFieldAnnotationMethodMap.get()).get(fieldElement)).map(methodForAnnotations -> methodForAnnotations == MethodForAnnotations.MISSING).orElse(false);
    }

    boolean isObjectClass() {
        return Flag.Class.IS_OBJECT.invoke(((Integer)this.flags.get()).intValue());
    }

    boolean isCompanionObjectClass() {
        return Flag.Class.IS_COMPANION_OBJECT.invoke(((Integer)this.flags.get()).intValue());
    }

    Optional<String> getCompanionObjectName() {
        return (Optional)this.companionObjectName.get();
    }

    boolean isPrivate() {
        return Flag.IS_PRIVATE.invoke(((Integer)this.flags.get()).intValue());
    }

    Optional<ExecutableElement> getPropertyGetter(VariableElement fieldElement) {
        Preconditions.checkArgument((boolean)((Map)this.elementFieldGetterMethodMap.get()).containsKey(fieldElement));
        return (Optional)((Map)this.elementFieldGetterMethodMap.get()).get(fieldElement);
    }

    public boolean containsConstructorWithDefaultParam() {
        return (Boolean)this.containsConstructorWithDefaultParam.get();
    }

    static KotlinMetadata from(TypeElement typeElement) {
        return new KotlinMetadata(typeElement, KotlinMetadata.metadataOf(typeElement));
    }

    private static KotlinClassMetadata.Class metadataOf(TypeElement typeElement) {
        Optional<AnnotationMirror> metadataAnnotation = DaggerElements.getAnnotationMirror(typeElement, Metadata.class);
        Preconditions.checkState((boolean)metadataAnnotation.isPresent());
        KotlinClassHeader header = new KotlinClassHeader(Integer.valueOf(MoreAnnotationValues.getIntValue(metadataAnnotation.get(), "k")), MoreAnnotationValues.getIntArrayValue(metadataAnnotation.get(), "mv"), MoreAnnotationValues.getIntArrayValue(metadataAnnotation.get(), "bv"), MoreAnnotationValues.getStringArrayValue(metadataAnnotation.get(), "d1"), MoreAnnotationValues.getStringArrayValue(metadataAnnotation.get(), "d2"), MoreAnnotationValues.getStringValue(metadataAnnotation.get(), "xs"), (String)MoreAnnotationValues.getOptionalStringValue(metadataAnnotation.get(), "pn").orElse(null), (Integer)MoreAnnotationValues.getOptionalIntValue(metadataAnnotation.get(), "xi").orElse(null));
        KotlinClassMetadata metadata = KotlinClassMetadata.read((KotlinClassHeader)header);
        if (metadata == null) {
            throw new IllegalStateException("Unsupported metadata version. Check that your Kotlin version is >= 1.0");
        }
        if (metadata instanceof KotlinClassMetadata.Class) {
            return (KotlinClassMetadata.Class)metadata;
        }
        throw new IllegalStateException("Unsupported metadata type: " + metadata);
    }

    private static final class MethodForAnnotations {
        static final MethodForAnnotations MISSING = new MethodForAnnotations(null);
        private final ExecutableElement method;

        MethodForAnnotations(ExecutableElement method) {
            this.method = method;
        }

        public ExecutableElement getMethod() {
            return this.method;
        }
    }

    private static final class Property {
        private final String name;
        private final int flags;
        private final Optional<String> fieldSignature;
        private final Optional<String> getterSignature;
        private final Optional<String> methodForAnnotationsSignature;

        Property(String name, int flags, Optional<String> fieldSignature, Optional<String> getterSignature, Optional<String> methodForAnnotationsSignature) {
            this.name = name;
            this.flags = flags;
            this.fieldSignature = fieldSignature;
            this.getterSignature = getterSignature;
            this.methodForAnnotationsSignature = methodForAnnotationsSignature;
        }

        String getName() {
            return this.name;
        }

        int getFlags() {
            return this.flags;
        }

        Optional<String> getFieldSignature() {
            return this.fieldSignature;
        }

        Optional<String> getGetterMethodSignature() {
            return this.getterSignature;
        }

        Optional<String> getMethodForAnnotationsSignature() {
            return this.methodForAnnotationsSignature;
        }
    }

    private static final class ConstructorWithDefaultParamVisitor
    extends KmClassVisitor {
        boolean containsConstructorWithDefaultParam;

        private ConstructorWithDefaultParamVisitor() {
        }

        public KmConstructorVisitor visitConstructor(int flags) {
            return new KmConstructorVisitor(){

                public KmValueParameterVisitor visitValueParameter(int flags, String name) {
                    containsConstructorWithDefaultParam |= Flag.ValueParameter.DECLARES_DEFAULT_VALUE.invoke(flags);
                    return super.visitValueParameter(flags, name);
                }
            };
        }
    }

    private static final class PropertiesVisitor
    extends KmClassVisitor {
        List<Property> properties = new ArrayList<Property>();

        private PropertiesVisitor() {
        }

        public KmPropertyVisitor visitProperty(final int flags, final String name, int getterFlags, int setterFlags) {
            return new KmPropertyVisitor(){
                Optional<String> fieldSignature;
                Optional<String> getterSignature = Optional.empty();
                Optional<String> methodForAnnotationsSignature = Optional.empty();

                public KmPropertyExtensionVisitor visitExtensions(KmExtensionType kmExtensionType) {
                    if (!kmExtensionType.equals((Object)JvmPropertyExtensionVisitor.TYPE)) {
                        return null;
                    }
                    return new JvmPropertyExtensionVisitor(){

                        public void visit(int jvmFlags, @Nullable JvmFieldSignature jvmFieldSignature, @Nullable JvmMethodSignature jvmGetterSignature, @Nullable JvmMethodSignature jvmSetterSignature) {
                            fieldSignature = Optional.ofNullable(jvmFieldSignature).map(JvmFieldSignature::asString);
                            getterSignature = Optional.ofNullable(jvmGetterSignature).map(JvmMethodSignature::asString);
                        }

                        public void visitSyntheticMethodForAnnotations(@Nullable JvmMethodSignature methodSignature) {
                            methodForAnnotationsSignature = Optional.ofNullable(methodSignature).map(JvmMethodSignature::asString);
                        }
                    };
                }

                public void visitEnd() {
                    properties.add(new Property(name, flags, this.fieldSignature, this.getterSignature, this.methodForAnnotationsSignature));
                }
            };
        }
    }

    private static final class CompanionObjectNameVisitor
    extends KmClassVisitor {
        Optional<String> name = Optional.empty();

        private CompanionObjectNameVisitor() {
        }

        public void visitCompanionObject(String name) {
            this.name = Optional.of(name);
        }
    }

    private static final class FlagsVisitor
    extends KmClassVisitor {
        int flags;

        private FlagsVisitor() {
        }

        public void visit(int flags, String name) {
            this.flags = flags;
        }
    }
}

