/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.langmodel;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.graph.Traverser;
import com.squareup.javapoet.ClassName;
import dagger.Reusable;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.AbstractTypeVisitor8;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor8;
import javax.lang.model.util.Types;

@Reusable
public final class DaggerElements
implements Elements {
    private final Elements elements;
    private final Types types;
    private static final Traverser<Element> GET_ENCLOSED_ELEMENTS = Traverser.forTree(Element::getEnclosedElements);
    private static final ElementVisitor<TypeElement, Void> CLOSEST_ENCLOSING_TYPE_ELEMENT = new SimpleElementVisitor8<TypeElement, Void>(){

        @Override
        protected TypeElement defaultAction(Element element, Void p) {
            return element.getEnclosingElement().accept(this, null);
        }

        @Override
        public TypeElement visitType(TypeElement type, Void p) {
            return type;
        }
    };
    public static final Comparator<Element> DECLARATION_ORDER = Comparator.comparing(element -> DaggerElements.siblings(element).indexOf(element));
    private static final AbstractTypeVisitor8<String, Void> JVM_DESCRIPTOR_TYPE_VISITOR = new AbstractTypeVisitor8<String, Void>(){

        @Override
        public String visitArray(ArrayType arrayType, Void v) {
            return "[" + DaggerElements.getDescriptor(arrayType.getComponentType());
        }

        @Override
        public String visitDeclared(DeclaredType declaredType, Void v) {
            return "L" + this.getInternalName(declaredType.asElement()) + ";";
        }

        @Override
        public String visitError(ErrorType errorType, Void v) {
            return this.visitDeclared((DeclaredType)errorType, v);
        }

        @Override
        public String visitExecutable(ExecutableType executableType, Void v) {
            String parameterDescriptors = executableType.getParameterTypes().stream().map(x$0 -> DaggerElements.getDescriptor(x$0)).collect(Collectors.joining());
            String returnDescriptor = DaggerElements.getDescriptor(executableType.getReturnType());
            return "(" + parameterDescriptors + ")" + returnDescriptor;
        }

        @Override
        public String visitIntersection(IntersectionType intersectionType, Void v) {
            return DaggerElements.getDescriptor(intersectionType.getBounds().get(0));
        }

        @Override
        public String visitNoType(NoType noType, Void v) {
            return "V";
        }

        @Override
        public String visitNull(NullType nullType, Void v) {
            return this.visitUnknown((TypeMirror)nullType, null);
        }

        @Override
        public String visitPrimitive(PrimitiveType primitiveType, Void v) {
            switch (primitiveType.getKind()) {
                case BOOLEAN: {
                    return "Z";
                }
                case BYTE: {
                    return "B";
                }
                case SHORT: {
                    return "S";
                }
                case INT: {
                    return "I";
                }
                case LONG: {
                    return "J";
                }
                case CHAR: {
                    return "C";
                }
                case FLOAT: {
                    return "F";
                }
                case DOUBLE: {
                    return "D";
                }
            }
            throw new IllegalArgumentException("Unknown primitive type.");
        }

        @Override
        public String visitTypeVariable(TypeVariable typeVariable, Void v) {
            return DaggerElements.getDescriptor(typeVariable.getUpperBound());
        }

        @Override
        public String visitUnion(UnionType unionType, Void v) {
            return this.visitUnknown((TypeMirror)unionType, null);
        }

        @Override
        public String visitUnknown(TypeMirror typeMirror, Void v) {
            throw new IllegalArgumentException("Unsupported type: " + typeMirror);
        }

        @Override
        public String visitWildcard(WildcardType wildcardType, Void v) {
            return "";
        }

        private String getInternalName(Element element) {
            try {
                TypeElement typeElement = MoreElements.asType(element);
                switch (typeElement.getNestingKind()) {
                    case TOP_LEVEL: {
                        return typeElement.getQualifiedName().toString().replace('.', '/');
                    }
                    case MEMBER: {
                        return this.getInternalName(typeElement.getEnclosingElement()) + "$" + typeElement.getSimpleName();
                    }
                }
                throw new IllegalArgumentException("Unsupported nesting kind.");
            }
            catch (IllegalArgumentException typeElement) {
                if (element instanceof QualifiedNameable) {
                    QualifiedNameable qualifiedNameElement = (QualifiedNameable)element;
                    return qualifiedNameElement.getQualifiedName().toString().replace('.', '/');
                }
                return element.getSimpleName().toString();
            }
        }
    };

    public DaggerElements(Elements elements, Types types) {
        this.elements = (Elements)Preconditions.checkNotNull((Object)elements);
        this.types = (Types)Preconditions.checkNotNull((Object)types);
    }

    public DaggerElements(ProcessingEnvironment processingEnv) {
        this(processingEnv.getElementUtils(), processingEnv.getTypeUtils());
    }

    public static boolean elementEncloses(TypeElement encloser, Element enclosed) {
        return Iterables.contains((Iterable)GET_ENCLOSED_ELEMENTS.breadthFirst((Object)encloser), (Object)enclosed);
    }

    public ImmutableSet<ExecutableElement> getUnimplementedMethods(TypeElement type) {
        return FluentIterable.from(MoreElements.getLocalAndInheritedMethods(type, this.types, this.elements)).filter(MoreElements.hasModifiers(Modifier.ABSTRACT)).toSet();
    }

    public TypeElement getTypeElement(Class<?> clazz) {
        return this.getTypeElement(clazz.getCanonicalName());
    }

    @Override
    public TypeElement getTypeElement(CharSequence name) {
        return this.elements.getTypeElement(name);
    }

    public TypeElement getTypeElement(ClassName className) {
        return this.getTypeElement(className.withoutAnnotations().toString());
    }

    public static TypeElement closestEnclosingTypeElement(Element element) {
        return element.accept(CLOSEST_ENCLOSING_TYPE_ELEMENT, null);
    }

    private static List<? extends Element> siblings(Element element) {
        return element.getKind().equals((Object)ElementKind.PARAMETER) ? MoreElements.asExecutable(element.getEnclosingElement()).getParameters() : element.getEnclosingElement().getEnclosedElements();
    }

    public static boolean isAnyAnnotationPresent(Element element, Iterable<? extends Class<? extends Annotation>> annotationClasses) {
        for (Class<? extends Annotation> clazz : annotationClasses) {
            if (!MoreElements.isAnnotationPresent(element, clazz)) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static boolean isAnyAnnotationPresent(Element element, Class<? extends Annotation> first, Class<? extends Annotation> ... otherAnnotations) {
        return DaggerElements.isAnyAnnotationPresent(element, Lists.asList(first, (Object[])otherAnnotations));
    }

    public static boolean isAnnotationPresent(Element element, TypeMirror annotationType) {
        return element.getAnnotationMirrors().stream().map(AnnotationMirror::getAnnotationType).anyMatch(candidate -> MoreTypes.equivalence().equivalent(candidate, (Object)annotationType));
    }

    @SafeVarargs
    public static Optional<AnnotationMirror> getAnyAnnotation(Element element, Class<? extends Annotation> first, Class<? extends Annotation> ... rest) {
        return DaggerElements.getAnyAnnotation(element, Lists.asList(first, (Object[])rest));
    }

    public static Optional<AnnotationMirror> getAnyAnnotation(Element element, Collection<? extends Class<? extends Annotation>> annotations) {
        return element.getAnnotationMirrors().stream().filter(DaggerElements.hasAnnotationTypeIn(annotations)).map(a -> a).findFirst();
    }

    @SafeVarargs
    public static ImmutableSet<AnnotationMirror> getAllAnnotations(Element element, Class<? extends Annotation> first, Class<? extends Annotation> ... rest) {
        return ImmutableSet.copyOf((Iterable)Iterables.filter(element.getAnnotationMirrors(), DaggerElements.hasAnnotationTypeIn(Lists.asList(first, (Object[])rest))::test));
    }

    public static Optional<AnnotationMirror> getAnnotationMirror(Element element, Class<? extends Annotation> annotationClass) {
        return Optional.ofNullable((AnnotationMirror)MoreElements.getAnnotationMirror(element, annotationClass).orNull());
    }

    private static Predicate<AnnotationMirror> hasAnnotationTypeIn(Collection<? extends Class<? extends Annotation>> annotations) {
        Set annotationClassNames = annotations.stream().map(Class::getCanonicalName).collect(Collectors.toSet());
        return annotation -> annotationClassNames.contains(MoreTypes.asTypeElement(annotation.getAnnotationType()).getQualifiedName().toString());
    }

    public static ImmutableSet<String> suppressedWarnings(Element element) {
        SuppressWarnings suppressedWarnings = element.getAnnotation(SuppressWarnings.class);
        if (suppressedWarnings == null) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf((Object[])suppressedWarnings.value());
    }

    public static String getFieldDescriptor(VariableElement element) {
        return element.getSimpleName() + ":" + DaggerElements.getDescriptor(element.asType());
    }

    public static String getMethodDescriptor(ExecutableElement element) {
        return element.getSimpleName() + DaggerElements.getDescriptor(element.asType());
    }

    private static String getDescriptor(TypeMirror t) {
        return t.accept(JVM_DESCRIPTOR_TYPE_VISITOR, null);
    }

    public TypeElement checkTypePresent(String typeName) {
        TypeElement type = this.elements.getTypeElement(typeName);
        if (type == null) {
            throw new TypeNotPresentException(typeName, null);
        }
        return type;
    }

    @Override
    public PackageElement getPackageElement(CharSequence name) {
        return this.elements.getPackageElement(name);
    }

    @Override
    public Map<? extends ExecutableElement, ? extends AnnotationValue> getElementValuesWithDefaults(AnnotationMirror a) {
        return this.elements.getElementValuesWithDefaults(a);
    }

    public Map<String, ? extends AnnotationValue> getElementValuesWithDefaultsByName(AnnotationMirror a) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.getElementValuesWithDefaults(a).forEach((k, v) -> builder.put((Object)k.getSimpleName().toString(), v));
        return builder.build();
    }

    @Override
    public String getDocComment(Element e) {
        return this.elements.getDocComment(e);
    }

    @Override
    public boolean isDeprecated(Element e) {
        return this.elements.isDeprecated(e);
    }

    @Override
    public Name getBinaryName(TypeElement type) {
        return this.elements.getBinaryName(type);
    }

    @Override
    public PackageElement getPackageOf(Element type) {
        return this.elements.getPackageOf(type);
    }

    @Override
    public List<? extends Element> getAllMembers(TypeElement type) {
        return this.elements.getAllMembers(type);
    }

    @Override
    public List<? extends AnnotationMirror> getAllAnnotationMirrors(Element e) {
        return this.elements.getAllAnnotationMirrors(e);
    }

    @Override
    public boolean hides(Element hider, Element hidden) {
        return this.elements.hides(hider, hidden);
    }

    @Override
    public boolean overrides(ExecutableElement overrider, ExecutableElement overridden, TypeElement type) {
        return this.elements.overrides(overrider, overridden, type);
    }

    @Override
    public String getConstantExpression(Object value) {
        return this.elements.getConstantExpression(value);
    }

    @Override
    public void printElements(Writer w, Element ... elements) {
        this.elements.printElements(w, elements);
    }

    @Override
    public Name getName(CharSequence cs) {
        return this.elements.getName(cs);
    }

    @Override
    public boolean isFunctionalInterface(TypeElement type) {
        return this.elements.isFunctionalInterface(type);
    }
}

