/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.collect.ImmutableCollection;
import dagger.MembersInjector;
import dagger.internal.codegen.base.FrameworkTypes;
import dagger.internal.codegen.base.RequestKinds;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.validation.MembersInjectionValidator;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

final class DependencyRequestValidator {
    private final MembersInjectionValidator membersInjectionValidator;
    private final InjectionAnnotations injectionAnnotations;
    private final KotlinMetadataUtil metadataUtil;
    private final DaggerElements elements;

    @Inject
    DependencyRequestValidator(MembersInjectionValidator membersInjectionValidator, InjectionAnnotations injectionAnnotations, KotlinMetadataUtil metadataUtil, DaggerElements elements) {
        this.membersInjectionValidator = membersInjectionValidator;
        this.injectionAnnotations = injectionAnnotations;
        this.metadataUtil = metadataUtil;
        this.elements = elements;
    }

    void validateDependencyRequest(ValidationReport.Builder<?> report, Element requestElement, TypeMirror requestType) {
        this.checkQualifiers(report, requestElement);
        this.checkType(report, requestElement, requestType);
    }

    private void checkQualifiers(ValidationReport.Builder<?> report, Element requestElement) {
        Optional<TypeElement> membersInjector;
        if (requestElement.getKind() == ElementKind.FIELD && !requestElement.getModifiers().contains((Object)Modifier.STATIC) && this.metadataUtil.hasMetadata(requestElement) && this.metadataUtil.isMissingSyntheticPropertyForAnnotations(MoreElements.asVariable(requestElement)) && !(membersInjector = Optional.ofNullable(this.elements.getTypeElement(SourceFiles.membersInjectorNameForType(MoreElements.asType(requestElement.getEnclosingElement()))))).isPresent()) {
            report.addError("Unable to read annotations on an injected Kotlin property. The Dagger compiler must also be applied to any project containing @Inject properties.", requestElement);
            return;
        }
        ImmutableCollection<? extends AnnotationMirror> qualifiers = this.injectionAnnotations.getQualifiers(requestElement);
        if (qualifiers.size() > 1) {
            for (AnnotationMirror qualifier : qualifiers) {
                report.addError("A single dependency request may not use more than one @Qualifier", requestElement, qualifier);
            }
        }
    }

    private void checkType(ValidationReport.Builder<?> report, Element requestElement, TypeMirror requestType) {
        TypeMirror keyType = RequestKinds.extractKeyType(requestType);
        if (keyType.getKind().equals((Object)TypeKind.WILDCARD)) {
            report.addError("Dagger does not support injecting Provider<T>, Lazy<T>, Producer<T>, or Produced<T> when T is a wildcard type such as " + keyType, requestElement);
        }
        if (MoreTypes.isType(keyType) && MoreTypes.isTypeOf(MembersInjector.class, keyType)) {
            DeclaredType membersInjectorType = MoreTypes.asDeclared(keyType);
            if (membersInjectorType.getTypeArguments().isEmpty()) {
                report.addError("Cannot inject a raw MembersInjector", requestElement);
            } else {
                report.addSubreport(this.membersInjectionValidator.validateMembersInjectionRequest(requestElement, membersInjectorType.getTypeArguments().get(0)));
            }
        }
    }

    void checkNotProducer(ValidationReport.Builder<?> report, VariableElement requestElement) {
        TypeMirror requestType = requestElement.asType();
        if (FrameworkTypes.isProducerType(requestType)) {
            report.addError(String.format("%s may only be injected in @Produces methods", MoreTypes.asTypeElement(requestType).getSimpleName()), requestElement);
        }
    }
}

